/*
 * Decompiled with CFR 0.152.
 */
package pl.moresteck;

import java.io.File;
import java.util.ArrayList;
import pl.moresteck.BCWrapper;
import pl.moresteck.OS;

public class GameStandaloneLauncher {
    private String[] known_main_classes = new String[]{"com.mojang.rubydung.RubyDung", "com.mojang.minecraft.RubyDung", "net.minecraft.client.main.Main"};
    public ArrayList<String> arguments;
    public String main_class_path;
    private ClassLoader class_loader;
    public static boolean prefer_workDir = System.getProperty("betacraft.standalone.args.prefer_workDir") != null;

    public GameStandaloneLauncher(String main_class_path) {
        String[] paths;
        boolean reconstruct_assets = System.getProperty("betacraft.standalone.reconstruct_assets") != null;
        this.main_class_path = main_class_path;
        this.arguments = GameStandaloneLauncher.createArguments();
        try {
            this.class_loader = this.getClass().getClassLoader();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (!this.findMainClass()) {
            System.exit(0);
        }
        File dest = reconstruct_assets ? new File(BCWrapper.arguments.get("gameDir"), "assets/") : new File(BCWrapper.arguments.get("assetsDir"));
        dest.mkdirs();
        if (reconstruct_assets) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("objects");
            list.add("virtual");
            list.add("indexes");
            BCWrapper.removeRecursively(dest, false, list);
            BCWrapper.moveRecursively(new File(BCWrapper.arguments.get("assetsDir")), dest, false);
        }
        String[] stringArray = paths = BCWrapper.arguments.get("assetsToOverwrite").split("<separator>");
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            BCWrapper.unzip(path, dest.toPath().toString(), false);
            ++n2;
        }
    }

    public void launchGame() {
        ArrayList<String> command = new ArrayList<String>();
        String dir = BCWrapper.arguments.get("appdata");
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + File.separator;
        }
        dir = dir.replaceAll("\\./", "");
        File appdata = new File(dir);
        appdata.mkdirs();
        String natives = BCWrapper.arguments.get("nativesDir").replaceAll("\\./", "");
        if (!natives.endsWith("/") && !natives.endsWith("\\")) {
            natives = String.valueOf(natives) + File.separator;
        }
        String java_cmd = String.valueOf(System.getProperty("java.home")) + (OS.isWindows() ? "\\bin\\javaw.exe" : "/bin/java");
        command.add(java_cmd);
        command.add("-javaagent:" + natives + "bcwrapper-" + BCWrapper.arguments.get("wrapperVersion") + ".jar=overwriteURLs," + BCWrapper.proxy_host + "," + BCWrapper.proxy_port);
        command.addAll(BCWrapper.jvmargs);
        command.add("-Duser.home=" + dir);
        command.add("-Dorg.lwjgl.librarypath=" + natives);
        command.add("-Dnet.java.games.input.librarypath=" + natives);
        command.add("-cp");
        command.add(((String)System.getProperties().get("java.class.path")).replaceAll("\\./", ""));
        command.add(this.main_class_path);
        command.addAll(this.arguments);
        System.out.println(command);
        try {
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(appdata);
            pb.environment().put("APPDATA", dir);
            Process p = pb.inheritIO().start();
            System.out.println("Ended with: " + p.waitFor());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean findMainClass() {
        block6: {
            main_class = null;
            errors = new Throwable[2];
            try {
                main_class = this.class_loader.loadClass(this.main_class_path);
                break block6;
            }
            catch (Throwable t) {
                errors[0] = t;
                i = 0;
                ** while (i < this.known_main_classes.length)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    main_class = this.class_loader.loadClass(this.known_main_classes[i]);
                    break;
                }
                catch (Throwable t1) {
                    errors[1] = t1;
                    ++i;
                }
                continue;
            }
        }
        if (main_class == null) {
            System.out.println("Could not find the main class of the game jar!");
            errors[0].printStackTrace();
            errors[1].printStackTrace();
            return false;
        }
        return true;
    }

    public static ArrayList<String> createArguments() {
        ArrayList<String> arg_list = new ArrayList<String>();
        if (System.getProperty("betacraft.standalone.use_arguments") == null) {
            return arg_list;
        }
        boolean prefer_session = System.getProperty("betacraft.standalone.args.prefer_session") != null;
        boolean set_version = System.getProperty("betacraft.standalone.args.set_version") != null;
        boolean set_resolution = System.getProperty("betacraft.standalone.args.set_resolution") != null;
        boolean set_uuid = System.getProperty("betacraft.standalone.args.set_uuid") != null;
        boolean set_assetIndex = System.getProperty("betacraft.standalone.args.set_assetIndex") != null;
        boolean set_userProperties = System.getProperty("betacraft.standalone.args.set_userProperties") != null;
        boolean set_versionType = System.getProperty("betacraft.standalone.args.set_versionType") != null;
        for (String arg : BCWrapper.arguments.keySet()) {
            String value = BCWrapper.arguments.get(arg);
            if (arg.equalsIgnoreCase("versionName") && set_version) {
                arg_list.add("--version");
                arg_list.add(value.replaceAll("IJ ", ""));
                continue;
            }
            if (arg.equalsIgnoreCase("username")) {
                arg_list.add("--username");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("sessionid")) {
                if (prefer_session) {
                    arg_list.add("--session");
                    arg_list.add(value);
                    continue;
                }
                String[] session_parts = value.split(":");
                if (session_parts.length == 3) {
                    value = session_parts[1];
                }
                arg_list.add("--accessToken");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("gameDir")) {
                if (prefer_workDir) {
                    arg_list.add("--workDir");
                    if (!value.endsWith("/") && !value.endsWith("\\")) {
                        value = String.valueOf(value) + File.separator;
                    }
                    arg_list.add(value.replaceAll("\\./", ""));
                    continue;
                }
                arg_list.add("--gameDir");
                if (!value.endsWith("/") && !value.endsWith("\\")) {
                    value = String.valueOf(value) + File.separator;
                }
                arg_list.add(value.replaceAll("\\./", ""));
                continue;
            }
            if (arg.equalsIgnoreCase("assetsDir") && !prefer_workDir) {
                arg_list.add("--assetsDir");
                if (!value.endsWith("/") && !value.endsWith("\\")) {
                    value = String.valueOf(value) + File.separator;
                }
                arg_list.add(value.replaceAll("\\./", ""));
                continue;
            }
            if (arg.equalsIgnoreCase("assetIndex") && set_assetIndex) {
                arg_list.add("--assetIndex");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("userProperties") && set_userProperties) {
                arg_list.add("--userProperties");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("versionType") && set_versionType) {
                arg_list.add("--versionType");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("width") && set_resolution) {
                arg_list.add("--width");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("height") && set_resolution) {
                arg_list.add("--height");
                arg_list.add(value);
                continue;
            }
            if (arg.equalsIgnoreCase("uuid") && set_uuid) {
                arg_list.add("--uuid");
                arg_list.add(value);
                continue;
            }
            if (!arg.equalsIgnoreCase("demo")) continue;
            arg_list.add("--demo");
        }
        if (BCWrapper.server != null) {
            arg_list.add("--server");
            arg_list.add(BCWrapper.server);
            arg_list.add("--port");
            arg_list.add(BCWrapper.port);
        }
        if (System.getProperty("betacraft.force_fullscreen") != null) {
            arg_list.add("--fullscreen");
        }
        return arg_list;
    }
}

