import java.applet.Applet;
import java.awt.Canvas;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;

import org.betacraft.Addon;
import org.betacraft.Wrapper;

public class Fullscreen extends Addon {

    @Override
    public WhatToDo preAppletInit(final Wrapper wrapper, ArrayList<Addon> addonsLeft) {
        wrapper.params.put("fullscreen", "true");

        HashMap<String, String> names = new HashMap<String, String>();
        try {
            for (final Field minecraftField : wrapper.mainClass.getDeclaredFields()) {

                // 15a and 12a have their own wrappers which handle fullscreen
                // disable the addon for preclassic
                if (wrapper.version.contains("rd-") || wrapper.version.contains("mc-") || wrapper.version.contains("c0.0.15a-") || wrapper.version.contains("12a")) {
                    break;
                    /*wrapper.mainClassInstance = new RD15(null, wrapper);
                    break;
                } else if (wrapper.version.contains("mc-161148")) {
                    wrapper.mainClassInstance = new MC16(null, wrapper);
                    break;
                } else {*/
                }

                String name = minecraftField.getType().getName();
                if (name.contains("minecraft")) {

                    final Class<?> clazz = wrapper.classLoader.loadClass(name);
                    Constructor<?> con = null;

                    // Copied init() method from MinecraftApplet
                    @SuppressWarnings("serial")
                    Canvas canvas = new Canvas() {

                        @SuppressWarnings("unchecked")
                        @Override
                        public void addNotify() {
                            super.addNotify();
                            try {
                                wrapper.mainClass.getMethod("startGameThread").invoke(wrapper.mainClassInstance);
                            } catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }

                        @SuppressWarnings("unchecked")
                        @Override
                        public void removeNotify() {
                            try {
                                wrapper.mainClass.getMethod("stopGameThread").invoke(wrapper.mainClassInstance);
                            } catch (Throwable t) {
                                t.printStackTrace();
                            }
                            super.removeNotify();
                        }
                    };

                    minecraftField.setAccessible(true);

                    Object mc = null;
                    try {
                        mc = minecraftField.get(wrapper.mainClassInstance);
                    } catch (Throwable t) {}

                    final boolean mcnull = mc == null;

                    Runnable run = null;
                    if (!mcnull)
                        run = (Runnable) mc;

                    if (wrapper.version.contains("12a") || 
                            wrapper.version.contains("13a-dev") || 
                            wrapper.version.contains("11a")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                    } else if (wrapper.version.contains("13a_03")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "e");
                        names.put("userinfo", "d");
                        names.put("mapuser", "j");
                        names.put("mapid", "k");
                        names.put("userinfoclass", "com.mojang.minecraft.d");

                    } else if (wrapper.version.contains("14a_08")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "d");
                        names.put("userinfo", "c");
                        names.put("mapuser", "h");
                        names.put("mapid", "i");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("16a_02-081047")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "f");
                        names.put("userinfo", "e");
                        names.put("mapuser", "j");
                        names.put("mapid", "k");
                        names.put("server", "G");
                        names.put("port", "H");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("17a") ||
                            wrapper.version.contains("18a")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "f");
                        names.put("mppass", "d");
                        names.put("userinfo", "e");
                        names.put("mapuser", "k");
                        names.put("mapid", "l");
                        names.put("server", "n");
                        names.put("port", "o");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("19a")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "g");
                        names.put("mppass", "d");
                        names.put("userinfo", "f");
                        names.put("mapuser", "n");
                        names.put("mapid", "o");
                        names.put("server", "q");
                        names.put("port", "r");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("20a") || 
                            wrapper.version.contains("21a")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "f");
                        names.put("mppass", "d");
                        names.put("userinfo", "e");
                        names.put("mapuser", "m");
                        names.put("mapid", "n");
                        names.put("server", "p");
                        names.put("port", "q");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("22a") || 
                            wrapper.version.contains("23a")) {
                        // 22a_05, 23a_01

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "h");
                        names.put("mppass", "d");
                        names.put("userinfo", "g");
                        names.put("mapuser", "t");
                        names.put("mapid", "u");
                        names.put("server", "D");
                        names.put("port", "E");
                        names.put("userinfoclass", "com.mojang.minecraft.a");
                    } else if (wrapper.version.contains("0.24")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, wrapper.mainClass, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, ((Applet)wrapper.mainClassInstance), wrapper.panel.getWidth(), wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "i");
                        names.put("mppass", "c");
                        names.put("userinfo", "h");
                        names.put("mapuser", "t");
                        names.put("mapid", "u");
                        names.put("server", "C");
                        names.put("port", "D");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("0.25") ||
                            wrapper.version.contains("0.26") || 
                            wrapper.version.contains("0.27") || 
                            wrapper.version.contains("0.28") || 
                            wrapper.version.contains("0.29") || 
                            wrapper.version.contains("0.30")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, wrapper.mainClass, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, ((Applet)wrapper.mainClassInstance), wrapper.panel.getWidth(),wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "i");
                        names.put("mppass", "d");

                        if (wrapper.version.contains("0.30"))
                            names.put("haspaid", "e");

                        names.put("userinfo", "h");
                        names.put("mapuser", "t");
                        names.put("mapid", "u");
                        names.put("server", "C");
                        names.put("port", "D");
                        names.put("userinfoclass", "com.mojang.minecraft.a");

                    } else if (wrapper.version.contains("in-2009")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, wrapper.panel.getWidth(),wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "i");
                        names.put("userinfo", "h");
                        names.put("server", "q");
                        names.put("userinfoclass", "net.minecraft.client.d");

                    } else if (wrapper.version.contains("in-20100110") || 
                            wrapper.version.contains("in-20100104")) {

                        con = clazz.getConstructor(java.awt.Canvas.class, wrapper.mainClass, int.class, int.class, boolean.class);

                        if (mcnull)
                            run = (Runnable) con.newInstance(wrapper.params.containsKey("fullscreen") ? null : canvas, ((Applet)wrapper.mainClassInstance), wrapper.panel.getWidth(),wrapper.panel.getHeight(), wrapper.params.containsKey("fullscreen"));

                        names.put("host", "i");
                        names.put("userinfo", "h");
                        names.put("mapuser", "q");
                        names.put("mapid", "r");
                        names.put("server", "H");
                        names.put("userinfoclass", "net.minecraft.client.j");

                    }

                    if (mcnull) {

                        if (names.containsKey("host"))
                            clazz.getField(names.get("host")).set(run, wrapper.getDocumentBase().getHost());

                        if (wrapper.getDocumentBase().getPort() > 0 && wrapper.launchType.contains("mp")) {
                            final StringBuilder sb = new StringBuilder();
                            if (names.containsKey("host"))
                                clazz.getDeclaredField(names.get("host")).set(run, sb.append(wrapper.getDocumentBase().getHost()).append(":").append(wrapper.getDocumentBase().getPort()).toString());
                        }

                        if (wrapper.getParameter("username") != null && wrapper.getParameter("sessionid") != null) {

                            Class<?> userinfoclass = null;

                            if (names.containsKey("userinfoclass"))
                                userinfoclass = wrapper.classLoader.loadClass(names.get("userinfoclass"));

                            Object userinfo = null;
                            if (userinfoclass != null) {

                                if (wrapper.version.contains("in-2009"))
                                    userinfo = userinfoclass.getConstructor(String.class).newInstance(wrapper.getParameter("username"));
                                else
                                    userinfo = userinfoclass.getConstructor(String.class, String.class).newInstance(wrapper.getParameter("username"), wrapper.getParameter("sessionid"));
                            }

                            if (wrapper.getParameter("mppass") != null) {
                                if (names.containsKey("mppass"))
                                    userinfoclass.getDeclaredField(names.get("mppass")).set(userinfo, wrapper.getParameter("mppass"));
                            }

                            if (names.containsKey("haspaid"))
                                userinfoclass.getDeclaredField(names.get("haspaid")).set(userinfo, "true".equals(wrapper.getParameter("haspaid")));

                            if (names.containsKey("userinfo"))
                                clazz.getDeclaredField(names.get("userinfo")).set(run, userinfo);

                        }

                        if (wrapper.getParameter("loadmap_user") != null && wrapper.getParameter("loadmap_id") != null) {

                            if (names.containsKey("mapuser"))
                                clazz.getDeclaredField(names.get("mapuser")).set(run, wrapper.getParameter("loadmap_user"));

                            if (names.containsKey("mapid"))
                                clazz.getDeclaredField(names.get("mapid")).set(run, Integer.parseInt(wrapper.getParameter("loadmap_id")));

                        } else if (wrapper.getParameter("server") != null && wrapper.getParameter("port") != null) {

                            final String parameter = wrapper.getParameter("server");
                            final int int1 = Integer.parseInt(wrapper.getParameter("port"));

                            if (names.containsKey("server")) {
                                Field f = clazz.getDeclaredField(names.get("server"));
                                f.setAccessible(true);
                                f.set(run, parameter);
                            }

                            if (names.containsKey("port")) {
                                Field f = clazz.getDeclaredField(names.get("port"));
                                f.setAccessible(true);
                                f.set(run, int1);
                            }
                        }
                    }

                    if (!wrapper.params.containsKey("fullscreen")) {
                        // unused, but works
                        /*for (final Field appletModeField : clazz.getDeclaredFields()) {
                            if (appletModeField.getType().getName().equalsIgnoreCase("boolean") && Modifier.isPublic(appletModeField.getModifiers())) {
                                appletModeField.setAccessible(true);
                                appletModeField.set(run, true);
                                break;
                            }
                        }
                        for (final Field mcField : wrapper.mainClass.getDeclaredFields()) {
                            if (!mcField.getType().getName().contains("java.") && !mcField.getType().getName().contains("long")) {
                                mcField.setAccessible(true);
                                mcField.set(wrapper.mainClassInstance, run);
                                break;
                            }
                        }
                        wrapper.addonsPreAppletInit(addonsLeft);
                        wrapper.mainClass.getMethod("setLayout", LayoutManager.class).invoke(wrapper.mainClassInstance, new BorderLayout());
                        wrapper.mainClass.getMethod("add", Component.class, Object.class).invoke(wrapper.mainClassInstance, canvas, "Center");
                        canvas.setFocusable(true);
                        wrapper.mainClass.getMethod("validate").invoke(wrapper.mainClassInstance);
                        wrapper.addonsPostAppletInit(wrapper.addons);
                        return WhatToDo.STOP_CODE;*/
                    } else {
                    }

                    for (final Field fullscreenField : clazz.getDeclaredFields()) {
                        if (fullscreenField.getType().getName().equalsIgnoreCase("boolean") && Modifier.isPrivate(fullscreenField.getModifiers())) {
                            fullscreenField.setAccessible(true);
                            fullscreenField.set(run, true);
                            break;
                        }
                    }

                    for (final Field mcField : wrapper.mainClass.getDeclaredFields()) {
                        if (!mcField.getType().getName().contains("java.") && !mcField.getType().getName().contains("long")) {
                            mcField.setAccessible(true);
                            mcField.set(wrapper.mainClassInstance, run);
                            break;
                        }
                    }

                    wrapper.addonsPreAppletInit(addonsLeft);
                    wrapper.addonsPostAppletInit(wrapper.addons);

                    for (final Field mcField : wrapper.mainClass.getDeclaredFields()) {
                        if (!mcField.getType().getName().contains("java.") && !mcField.getType().getName().contains("long")) {
                            mcField.setAccessible(true);
                            run = (Runnable) mcField.get(wrapper.mainClassInstance);
                            break;
                        }
                    }

                    wrapper.gameFrame.setVisible(false);
                    run.run();

                    System.exit(0);
                    return WhatToDo.STOP_CODE;
                }
            }
        } catch (Throwable t) {
            t.printStackTrace();
        }

        return WhatToDo.NORMAL;
    }
}
