import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

import org.betacraft.Addon;
import org.betacraft.Wrapper;
import org.betacraft.launcher.Logger;

public class UnlicensedCopy extends Addon {

	@Override
	public WhatToDo postAppletInit(Wrapper wrapper, ArrayList<Addon> addonsLeft) {
		try {
			for (final Field field : wrapper.mainClass.getDeclaredFields()) {
				final String name = field.getType().getName();
				if (!name.contains("awt") && !name.contains("java")) {
					Field buttonTriggerField = null;

					field.setAccessible(true);
					Object mc = field.get(wrapper.mainClassInstance);

					final Class<?> clazz = wrapper.classLoader.loadClass(name);
					for (final Field field1 : clazz.getDeclaredFields()) {
						if (Modifier.isPublic(field1.getModifiers()) && Modifier.isStatic(field1.getModifiers())) {

							if (!field1.getType().isPrimitive()) continue;
							if (field1.getType().getName().equals("long")) {
								long li = field1.getLong(mc);
								if (li == 0L) {
									buttonTriggerField = field1;
									break;
								}
							}
						}
					}
					if (buttonTriggerField != null) {
						buttonTriggerField.setAccessible(true);
						buttonTriggerField.set(mc, 1L);
						break;
					}
				}
			}
		} catch (Exception ex) {
			ex.printStackTrace();
			Logger.printException(ex);
		}
		return WhatToDo.NORMAL;
	}
}
