import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.JFrame;
import javax.swing.JLabel;

import org.betacraft.Wrapper;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.Util;

public class DL_12w18a_19a extends Wrapper {

	public DL_12w18a_19a(String user, String ver_prefix, String version, String sessionid, String mainFolder,
			Integer height, Integer width, Boolean RPC, String launchMethod, String server, String mppass, String uuid, String USR,
			String VER, Image img, ArrayList addons) {
		super(user, ver_prefix, version, sessionid, mainFolder, height, width, RPC, launchMethod, server, mppass, uuid, USR, VER, img,
				addons);
	}

	public static HashMap<String, String> hashes = new HashMap<String, String>();

	@Override
	public void play() {
		this.launchType = "indev";

		File serverDir = new File(this.mainFolder, "server/");
		serverDir.mkdirs();

		File serverFile = new File(serverDir, "minecraft_server.jar");
		if (serverFile.exists()) {
			if (Util.getSHA1(serverFile).equalsIgnoreCase(hashes.get(version))) {
				super.play();
				return;
			}
		}

		String url = "http://files.betacraft.uk/server-archive/release/1.3/prerelease/" + this.version + ".jar";
		JFrame frame = new JFrame("Downloading dependencies...");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setLayout(new GridBagLayout());
		JLabel infolabel = new JLabel("Downloading: " + this.version + " server (" + url + ")");
		GridBagConstraints constr = new GridBagConstraints();

		constr.gridx = 0;
		constr.gridy = 0;
		constr.fill = GridBagConstraints.HORIZONTAL;
		constr.gridwidth = 1;
		constr.weightx = 1.0;
		constr.insets = new Insets(10, 10, 10, 10);

		frame.add(infolabel, constr);
		frame.pack();

		frame.setIconImage(this.icon);
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);

		if (Launcher.download(url, serverFile) == DownloadResult.FAILED_WITHOUT_BACKUP) {
			infolabel.setText("Failed to download! Check your Internet connection!");
			frame.setTitle("Failed!");
		} else {
			frame.setVisible(false);
		}
		super.play();
	}

	static {
		hashes.put("12w18a", "3FDB52ED2C179F53558E477F27E563F9CA3A6EDF");
		hashes.put("12w19a", "B134D6E290C3D6FCDB1B42B459CEE728B3F1F2E8");
		hashes.put("12w21a", "FAB5807AEE92C487BA6B823A22792FD3774FE682");
	}
}
