package moresteck;

import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;

public class AWTJaajAgent {

	public static void premain(String args, Instrumentation inst) {
		try {
			final byte[] pointerclass = Files.readAllBytes(new File(args + "launcher/macos-java-mod/PointerInfo.class").toPath());
			final byte[] robotclass = Files.readAllBytes(new File(args + "launcher/macos-java-mod/Robot.class").toPath());
			//final byte[] robotdispclass = Files.readAllBytes(new File("../launcher/RobotDisposer.class").toPath());
			//final byte[] robot1class = Files.readAllBytes(new File("../launcher/EmptyRunnable.class").toPath());
			inst.appendToSystemClassLoaderSearch(new JarFile(args + "launcher/macos-mousefix-lwjgl.jar"));
			inst.appendToSystemClassLoaderSearch(new JarFile(args + "bin/lwjgl_util.jar"));
			inst.appendToSystemClassLoaderSearch(new JarFile(args + "bin/jinput.jar"));
			inst.addTransformer(new ClassFileTransformer() {
				@Override
				public byte[] transform(ClassLoader loader, 
						String className, 
						Class<?> classBeingRedefined, 
						ProtectionDomain protectionDomain, 
						byte[] classfileBuffer) {
					if (className.equals("java/awt/PointerInfo")) {
						return pointerclass;
					} else if (className.equals("java/awt/Robot")) {
						return robotclass;
					} else {
						return null;
					}
				}
			});
			System.setProperty("betacraft.loaded_libraries", "true");
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}
}
