/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.net.NetHandler;
import net.minecraft.client.net.packet.Packet0KeepAlive;
import net.minecraft.client.net.packet.Packet100OpenWindow;
import net.minecraft.client.net.packet.Packet101CloseWindow;
import net.minecraft.client.net.packet.Packet102WindowClick;
import net.minecraft.client.net.packet.Packet103SetSlot;
import net.minecraft.client.net.packet.Packet104WindowItems;
import net.minecraft.client.net.packet.Packet105UpdateProgressbar;
import net.minecraft.client.net.packet.Packet106Transaction;
import net.minecraft.client.net.packet.Packet10Flying;
import net.minecraft.client.net.packet.Packet11PlayerPosition;
import net.minecraft.client.net.packet.Packet12PlayerLook;
import net.minecraft.client.net.packet.Packet13PlayerLookMove;
import net.minecraft.client.net.packet.Packet14BlockDig;
import net.minecraft.client.net.packet.Packet15Place;
import net.minecraft.client.net.packet.Packet16BlockItemSwitch;
import net.minecraft.client.net.packet.Packet17Gamemode;
import net.minecraft.client.net.packet.Packet18CreativeInventory;
import net.minecraft.client.net.packet.Packet1Login;
import net.minecraft.client.net.packet.Packet20NamedEntitySpawn;
import net.minecraft.client.net.packet.Packet21PickupSpawn;
import net.minecraft.client.net.packet.Packet22Collect;
import net.minecraft.client.net.packet.Packet23VehicleSpawn;
import net.minecraft.client.net.packet.Packet24MobSpawn;
import net.minecraft.client.net.packet.Packet255KickDisconnect;
import net.minecraft.client.net.packet.Packet28EntityVelocity;
import net.minecraft.client.net.packet.Packet29DestroyEntity;
import net.minecraft.client.net.packet.Packet2Handshake;
import net.minecraft.client.net.packet.Packet30Entity;
import net.minecraft.client.net.packet.Packet31RelEntityMove;
import net.minecraft.client.net.packet.Packet32EntityLook;
import net.minecraft.client.net.packet.Packet33RelEntityMoveLook;
import net.minecraft.client.net.packet.Packet34EntityTeleport;
import net.minecraft.client.net.packet.Packet38EntityStatus;
import net.minecraft.client.net.packet.Packet3Chat;
import net.minecraft.client.net.packet.Packet40EntityMetadata;
import net.minecraft.client.net.packet.Packet4UpdateTime;
import net.minecraft.client.net.packet.Packet50LevelData;
import net.minecraft.client.net.packet.Packet51LevelFinalize;
import net.minecraft.client.net.packet.Packet53BlockChange;
import net.minecraft.client.net.packet.Packet5PlayerInventory;
import net.minecraft.client.net.packet.Packet6SpawnPosition;
import net.minecraft.client.net.packet.Packet71Score;
import net.minecraft.client.net.packet.Packet7UseEntity;
import net.minecraft.client.net.packet.Packet8UpdateHealth;
import net.minecraft.client.net.packet.Packet9Respawn;
import net.minecraft.client.net.packet.PacketCounter;

public abstract class Packet {
    public boolean isChunkDataPacket = false;
    private static Map packetClassToIdMap = new HashMap();
    public final long creationTimeMillis = System.currentTimeMillis();
    private static Set serverPacketIdList = new HashSet();
    private static int totalPacketsCount = 0;
    private static HashMap packetStats = new HashMap();
    private static Set clientPacketIdList = new HashSet();
    private static Map packetIdToClassMap = new HashMap();

    static void addIdClassMapping(int n2, boolean bl, boolean bl2, Class clazz) {
        if (packetIdToClassMap.containsKey(n2)) {
            throw new IllegalArgumentException("Duplicate packet id:" + n2);
        }
        if (packetClassToIdMap.containsKey(clazz)) {
            throw new IllegalArgumentException("Duplicate packet class:" + clazz);
        }
        packetIdToClassMap.put(n2, clazz);
        packetClassToIdMap.put(clazz, n2);
        if (bl) {
            clientPacketIdList.add(n2);
        }
        if (bl2) {
            serverPacketIdList.add(n2);
        }
    }

    public static void writePacket(Packet packet, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(packet.getPacketId());
        packet.writePacketData(dataOutputStream);
    }

    public abstract void writePacketData(DataOutputStream var1) throws IOException;

    public static Packet readPacket(DataInputStream dataInputStream, boolean bl) throws IOException {
        int n2 = 0;
        Packet packet = null;
        try {
            n2 = dataInputStream.read();
            if (n2 == -1) {
                return null;
            }
            if (bl && !serverPacketIdList.contains(n2) || !bl && !clientPacketIdList.contains(n2)) {
                throw new IOException("Bad packet id " + n2);
            }
            packet = Packet.getNewPacket(n2);
            if (packet == null) {
                throw new IOException("Bad packet id " + n2);
            }
            packet.readPacketData(dataInputStream);
        }
        catch (EOFException eOFException) {
            System.out.println("Reached end of stream");
            return null;
        }
        PacketCounter packetCounter = (PacketCounter)packetStats.get(n2);
        if (packetCounter == null) {
            packetCounter = new PacketCounter(null);
            packetStats.put(n2, packetCounter);
        }
        packetCounter.addPacket(packet.getPacketSize());
        if (++totalPacketsCount % 1000 != 0) {
            // empty if block
        }
        return packet;
    }

    public abstract void readPacketData(DataInputStream var1) throws IOException;

    public static Packet getNewPacket(int n2) {
        try {
            Class clazz = (Class)packetIdToClassMap.get(n2);
            if (clazz == null) {
                return null;
            }
            return (Packet)clazz.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Skipping packet with id " + n2);
            return null;
        }
    }

    public abstract int getPacketSize();

    public final int getPacketId() {
        return (Integer)packetClassToIdMap.get(this.getClass());
    }

    public abstract void processPacket(NetHandler var1);

    static Class _mthclass$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void registerPacket(Packet packet) {
    }

    public static void writeString(String string, DataOutputStream dataOutputStream) throws IOException {
        if (string.length() > Short.MAX_VALUE) {
            throw new IOException("String too big");
        }
        dataOutputStream.writeShort(string.length());
        dataOutputStream.writeChars(string);
    }

    public static String readString(DataInputStream dataInputStream, int n2) throws IOException {
        int n3 = dataInputStream.readShort();
        if (n3 > n2) {
            throw new IOException("Received string length longer than maximum allowed (" + n3 + " > " + n2 + ")");
        }
        if (n3 < 0) {
            throw new IOException("Received string length is less than zero! Weird string!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(dataInputStream.readChar());
        }
        return stringBuilder.toString();
    }

    static {
        Packet.addIdClassMapping(0, true, true, Packet0KeepAlive.class);
        Packet.addIdClassMapping(1, true, true, Packet1Login.class);
        Packet.addIdClassMapping(2, true, true, Packet2Handshake.class);
        Packet.addIdClassMapping(3, true, true, Packet3Chat.class);
        Packet.addIdClassMapping(4, true, false, Packet4UpdateTime.class);
        Packet.addIdClassMapping(5, true, false, Packet5PlayerInventory.class);
        Packet.addIdClassMapping(6, true, false, Packet6SpawnPosition.class);
        Packet.addIdClassMapping(7, false, true, Packet7UseEntity.class);
        Packet.addIdClassMapping(8, true, false, Packet8UpdateHealth.class);
        Packet.addIdClassMapping(9, true, true, Packet9Respawn.class);
        Packet.addIdClassMapping(10, true, true, Packet10Flying.class);
        Packet.addIdClassMapping(11, true, true, Packet11PlayerPosition.class);
        Packet.addIdClassMapping(12, true, true, Packet12PlayerLook.class);
        Packet.addIdClassMapping(13, true, true, Packet13PlayerLookMove.class);
        Packet.addIdClassMapping(14, false, true, Packet14BlockDig.class);
        Packet.addIdClassMapping(15, false, true, Packet15Place.class);
        Packet.addIdClassMapping(16, false, true, Packet16BlockItemSwitch.class);
        Packet.addIdClassMapping(17, true, false, Packet17Gamemode.class);
        Packet.addIdClassMapping(18, false, true, Packet18CreativeInventory.class);
        Packet.addIdClassMapping(20, true, false, Packet20NamedEntitySpawn.class);
        Packet.addIdClassMapping(21, true, false, Packet21PickupSpawn.class);
        Packet.addIdClassMapping(22, true, false, Packet22Collect.class);
        Packet.addIdClassMapping(23, true, false, Packet23VehicleSpawn.class);
        Packet.addIdClassMapping(24, true, false, Packet24MobSpawn.class);
        Packet.addIdClassMapping(28, true, false, Packet28EntityVelocity.class);
        Packet.addIdClassMapping(29, true, false, Packet29DestroyEntity.class);
        Packet.addIdClassMapping(30, true, false, Packet30Entity.class);
        Packet.addIdClassMapping(31, true, false, Packet31RelEntityMove.class);
        Packet.addIdClassMapping(32, true, false, Packet32EntityLook.class);
        Packet.addIdClassMapping(33, true, false, Packet33RelEntityMoveLook.class);
        Packet.addIdClassMapping(34, true, false, Packet34EntityTeleport.class);
        Packet.addIdClassMapping(38, true, false, Packet38EntityStatus.class);
        Packet.addIdClassMapping(40, true, false, Packet40EntityMetadata.class);
        Packet.addIdClassMapping(50, true, false, Packet50LevelData.class);
        Packet.addIdClassMapping(51, true, true, Packet51LevelFinalize.class);
        Packet.addIdClassMapping(53, true, false, Packet53BlockChange.class);
        Packet.addIdClassMapping(71, true, false, Packet71Score.class);
        Packet.addIdClassMapping(100, true, false, Packet100OpenWindow.class);
        Packet.addIdClassMapping(101, true, true, Packet101CloseWindow.class);
        Packet.addIdClassMapping(102, false, true, Packet102WindowClick.class);
        Packet.addIdClassMapping(103, true, false, Packet103SetSlot.class);
        Packet.addIdClassMapping(104, true, false, Packet104WindowItems.class);
        Packet.addIdClassMapping(105, true, false, Packet105UpdateProgressbar.class);
        Packet.addIdClassMapping(106, true, true, Packet106Transaction.class);
        Packet.addIdClassMapping(255, true, true, Packet255KickDisconnect.class);
    }
}

