/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Random;
import net.minecraft.a.a.g;
import net.minecraft.a.b.k;
import net.minecraft.a.c.b;
import net.minecraft.a.c.d.a;
import net.minecraft.client.c.i;
import net.minecraft.client.controller.PlayerControllerMP;
import net.minecraft.client.d;
import net.minecraft.client.f.e;
import net.minecraft.client.gui.container.Container;
import net.minecraft.client.net.GuiDownloadTerrain;
import net.minecraft.client.net.InventoryBasic;
import net.minecraft.client.net.NetHandler;
import net.minecraft.client.net.NetworkManager;
import net.minecraft.client.net.gui.GuiConnectFailed;
import net.minecraft.client.net.packet.Packet;
import net.minecraft.client.net.packet.Packet0KeepAlive;
import net.minecraft.client.net.packet.Packet100OpenWindow;
import net.minecraft.client.net.packet.Packet101CloseWindow;
import net.minecraft.client.net.packet.Packet103SetSlot;
import net.minecraft.client.net.packet.Packet104WindowItems;
import net.minecraft.client.net.packet.Packet105UpdateProgressbar;
import net.minecraft.client.net.packet.Packet106Transaction;
import net.minecraft.client.net.packet.Packet10Flying;
import net.minecraft.client.net.packet.Packet17Gamemode;
import net.minecraft.client.net.packet.Packet1Login;
import net.minecraft.client.net.packet.Packet20NamedEntitySpawn;
import net.minecraft.client.net.packet.Packet21PickupSpawn;
import net.minecraft.client.net.packet.Packet22Collect;
import net.minecraft.client.net.packet.Packet23VehicleSpawn;
import net.minecraft.client.net.packet.Packet24MobSpawn;
import net.minecraft.client.net.packet.Packet255KickDisconnect;
import net.minecraft.client.net.packet.Packet25EntityPainting;
import net.minecraft.client.net.packet.Packet28EntityVelocity;
import net.minecraft.client.net.packet.Packet29DestroyEntity;
import net.minecraft.client.net.packet.Packet2Handshake;
import net.minecraft.client.net.packet.Packet30Entity;
import net.minecraft.client.net.packet.Packet34EntityTeleport;
import net.minecraft.client.net.packet.Packet38EntityStatus;
import net.minecraft.client.net.packet.Packet3Chat;
import net.minecraft.client.net.packet.Packet40EntityMetadata;
import net.minecraft.client.net.packet.Packet4UpdateTime;
import net.minecraft.client.net.packet.Packet50LevelData;
import net.minecraft.client.net.packet.Packet51LevelFinalize;
import net.minecraft.client.net.packet.Packet52MultiBlockChange;
import net.minecraft.client.net.packet.Packet53BlockChange;
import net.minecraft.client.net.packet.Packet5PlayerInventory;
import net.minecraft.client.net.packet.Packet6SpawnPosition;
import net.minecraft.client.net.packet.Packet71Score;
import net.minecraft.client.net.packet.Packet8UpdateHealth;
import net.minecraft.client.net.packet.Packet9Respawn;
import net.minecraft.client.player.EntityOtherPlayerMP;
import net.minecraft.game.entity.EntityList;
import net.minecraft.game.level.server.WorldClient;

public class NetClientHandler
extends NetHandler {
    private d mc;
    private NetworkManager netManager;
    private boolean disconnected = false;
    public String field_1209_a;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    public ByteArrayOutputStream levelData;
    public int levelProgress;
    int savedId;
    byte[] blockData = null;
    byte[] blockMetaData = null;
    int updateCounter = 0;
    public boolean loggedIn = false;
    Random rand;
    int spawnX = 0;
    int spawnY = 0;
    int spawnZ = 0;
    public String motd;
    public String srvName;

    public NetClientHandler(d d2, String string, int n2) throws UnknownHostException, IOException {
        this.mc = d2;
        this.rand = new Random();
        Socket socket = new Socket(InetAddress.getByName(string), n2);
        this.netManager = new NetworkManager(socket, "Client", this);
        this.levelProgress = 0;
        this.savedId = 0;
        this.motd = null;
        this.srvName = null;
        this.worldClient = new WorldClient(this);
        this.worldClient.a(8, 8, 8, new byte[512], new byte[512]);
        this.worldClient.multiplayerWorld = true;
    }

    @Override
    public boolean isServerHandler() {
        return false;
    }

    public void processReadPackets() {
        if (!this.disconnected) {
            ++this.updateCounter;
            if (this.updateCounter % 20 == 0) {
                this.addToSendQueue(new Packet0KeepAlive());
            }
            this.netManager.processReadPackets();
        }
        this.netManager.wakeThreads();
        if (this.worldClient != null && this.mc.f != null && (double)this.mc.f.i < 0.5 && !this.mc.f.u) {
            this.mc.f.b(this.spawnX, this.spawnY, this.spawnZ, 0.0f, 1.0f);
        }
    }

    @Override
    public void handleErrorMessage(String string, Object[] objectArray) {
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        this.mc.a(new GuiConnectFailed("Lost connection!", string, objectArray));
        this.mc.a((g)null);
    }

    public void disconnect() {
        this.disconnected = true;
        this.netManager.wakeThreads();
        this.netManager.networkShutdown("Connection closed!", new Object[0]);
    }

    public void addToSendQueue(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
    }

    @Override
    public void handleLogin(Packet1Login packet1Login) {
        this.mc.a = new PlayerControllerMP(this.mc, this);
        this.mc.a(this.worldClient);
        this.mc.f.b(64.0f, 32.0f, 64.0f);
        this.mc.f.canMove = false;
        this.mc.a(new GuiDownloadTerrain(this));
        this.savedId = packet1Login.protocolVersion;
        this.levelData = new ByteArrayOutputStream();
        this.motd = packet1Login.motd;
        this.srvName = packet1Login.srvName;
    }

    @Override
    public void handleHandshake(Packet2Handshake packet2Handshake) {
        if (packet2Handshake.username.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.h.b, 7));
        } else {
            try {
                URL uRL = new URL("http://session.minecraft.net/game/joinserver.jsp?user=" + this.mc.h.b + "&sessionId=" + this.mc.h.c + "&serverId=" + packet2Handshake.username);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                if (string.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.h.b, 7));
                } else {
                    this.netManager.networkShutdown("Failed to log in!", new Object[]{string});
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.netManager.networkShutdown("End of connection!", new Object[]{"Internal client error: " + exception.toString()});
            }
        }
    }

    @Override
    public void handleChat(Packet3Chat packet3Chat) {
        this.mc.t.addChatMessage(packet3Chat.message);
    }

    @Override
    public void handleUpdateTime(Packet4UpdateTime packet4UpdateTime) {
        this.mc.d.D = (int)packet4UpdateTime.time;
    }

    @Override
    public void handlePlayerInventory(Packet5PlayerInventory packet5PlayerInventory) {
        b b2 = this.getEntityByID(packet5PlayerInventory.entityID);
        if (b2 != null) {
            b2.outfitWithItem(packet5PlayerInventory.slot, packet5PlayerInventory.itemID, packet5PlayerInventory.itemDamage);
        }
    }

    @Override
    public void handleSpawnPosition(Packet6SpawnPosition packet6SpawnPosition) {
        this.mc.d.i = packet6SpawnPosition.xPosition;
        this.mc.d.j = packet6SpawnPosition.yPosition;
        this.mc.d.k = packet6SpawnPosition.zPosition;
        this.spawnX = packet6SpawnPosition.xPosition;
        this.spawnY = packet6SpawnPosition.yPosition;
        this.spawnZ = packet6SpawnPosition.zPosition;
    }

    @Override
    public void handleHealth(Packet8UpdateHealth packet8UpdateHealth) {
        this.mc.f.setHealth(packet8UpdateHealth.healthMP);
    }

    @Override
    public void func_9448_a(Packet9Respawn packet9Respawn) {
        this.mc.respawn(true, packet9Respawn.field_28048_a);
    }

    @Override
    public void handleFlying(Packet10Flying packet10Flying) {
        net.minecraft.client.g.a a2 = this.mc.f;
        float f2 = a2.h;
        float f3 = a2.i;
        float f4 = a2.j;
        float f5 = a2.n;
        float f6 = a2.o;
        if (packet10Flying.moving) {
            f2 = packet10Flying.xPosition;
            f3 = packet10Flying.yPosition;
            f4 = packet10Flying.zPosition;
        }
        if (packet10Flying.rotating) {
            f5 = packet10Flying.yaw;
            f6 = packet10Flying.pitch;
        }
        a2.P = 0.0f;
        a2.m = 0.0f;
        a2.l = 0.0f;
        a2.k = 0.0f;
        a2.b(f2, f3 - a2.v - 1.5f, f4, f5, f6);
        packet10Flying.xPosition = a2.h;
        packet10Flying.yPosition = a2.r.b;
        packet10Flying.zPosition = a2.j;
        packet10Flying.stance = a2.i - a2.v - 1.5f;
        a2.m = 0.0f;
        a2.l = 0.0f;
        a2.k = 0.0f;
        this.netManager.addToSendQueue(packet10Flying);
    }

    @Override
    public void handleGamemode(Packet17Gamemode packet17Gamemode) {
        b b2 = this.getEntityByID(packet17Gamemode.entityID);
        if (b2 != null && b2 instanceof net.minecraft.a.c.e.a) {
            this.mc.a.b = packet17Gamemode.gamemode == 1;
            this.mc.d.z = false;
            ((net.minecraft.a.c.e.a)b2).O = packet17Gamemode.op;
        }
    }

    @Override
    public void handleNamedEntitySpawn(Packet20NamedEntitySpawn packet20NamedEntitySpawn) {
        float f2 = (float)packet20NamedEntitySpawn.xPosition / 32.0f;
        float f3 = (float)packet20NamedEntitySpawn.yPosition / 32.0f;
        float f4 = (float)packet20NamedEntitySpawn.zPosition / 32.0f;
        float f5 = (float)(packet20NamedEntitySpawn.rotation * 360) / 256.0f;
        float f6 = (float)(packet20NamedEntitySpawn.pitch * 360) / 256.0f;
        EntityOtherPlayerMP entityOtherPlayerMP = new EntityOtherPlayerMP(this.mc.d, packet20NamedEntitySpawn.name);
        entityOtherPlayerMP.serverPosX = packet20NamedEntitySpawn.xPosition;
        entityOtherPlayerMP.e = entityOtherPlayerMP.B = (float)entityOtherPlayerMP.serverPosX;
        entityOtherPlayerMP.serverPosY = packet20NamedEntitySpawn.yPosition;
        entityOtherPlayerMP.f = entityOtherPlayerMP.C = (float)entityOtherPlayerMP.serverPosY;
        entityOtherPlayerMP.serverPosZ = packet20NamedEntitySpawn.zPosition;
        entityOtherPlayerMP.g = entityOtherPlayerMP.D = (float)entityOtherPlayerMP.serverPosZ;
        int n2 = packet20NamedEntitySpawn.currentItem;
        entityOtherPlayerMP.b.a[entityOtherPlayerMP.b.c] = n2 == 0 ? null : new k(n2, 1, 0);
        entityOtherPlayerMP.b(f2, f3, f4, f5, f6);
        this.worldClient.func_712_a(packet20NamedEntitySpawn.entityId, entityOtherPlayerMP);
    }

    @Override
    public void handlePickupSpawn(Packet21PickupSpawn packet21PickupSpawn) {
        float f2 = (float)packet21PickupSpawn.xPosition / 32.0f;
        float f3 = (float)packet21PickupSpawn.yPosition / 32.0f;
        float f4 = (float)packet21PickupSpawn.zPosition / 32.0f;
        net.minecraft.a.c.c.b b2 = new net.minecraft.a.c.c.b(this.worldClient, f2, f3, f4, new k(packet21PickupSpawn.itemID, packet21PickupSpawn.count, packet21PickupSpawn.itemDamage));
        b2.k = (float)packet21PickupSpawn.rotation / 128.0f;
        b2.l = (float)packet21PickupSpawn.pitch / 128.0f;
        b2.m = (float)packet21PickupSpawn.roll / 128.0f;
        b2.serverPosX = packet21PickupSpawn.xPosition;
        b2.serverPosY = packet21PickupSpawn.yPosition;
        b2.serverPosZ = packet21PickupSpawn.zPosition;
        this.worldClient.func_712_a(packet21PickupSpawn.entityId, b2);
    }

    @Override
    public void handleCollect(Packet22Collect packet22Collect) {
        b b2 = this.getEntityByID(packet22Collect.collectedEntityId);
        net.minecraft.a.c.e e2 = (net.minecraft.a.c.e)this.getEntityByID(packet22Collect.collectorEntityId);
        if (e2 == null) {
            e2 = this.mc.f;
        }
        if (b2 != null) {
            this.worldClient.a(b2, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.g.a(new e(this.mc.d, b2, e2, -0.5f));
            this.worldClient.releaseEntitySkin(packet22Collect.collectedEntityId);
        }
    }

    @Override
    public void handleVehicleSpawn(Packet23VehicleSpawn packet23VehicleSpawn) {
        float f2 = (float)packet23VehicleSpawn.xPosition / 32.0f;
        float f3 = (float)packet23VehicleSpawn.yPosition / 32.0f;
        float f4 = (float)packet23VehicleSpawn.zPosition / 32.0f;
        b b2 = null;
        if (packet23VehicleSpawn.type == 60) {
            b2 = new a(this.worldClient, f2, f3, f4);
        }
        if (packet23VehicleSpawn.type == 50) {
            b2 = new net.minecraft.a.c.c.a(this.worldClient, f2, f3, f4);
        }
        if (b2 != null) {
            b2.serverPosX = packet23VehicleSpawn.xPosition;
            b2.serverPosY = packet23VehicleSpawn.yPosition;
            b2.serverPosZ = packet23VehicleSpawn.zPosition;
            b2.n = 0.0f;
            b2.o = 0.0f;
            b2.entityId = packet23VehicleSpawn.entityId;
            this.worldClient.func_712_a(packet23VehicleSpawn.entityId, b2);
            if (packet23VehicleSpawn.field_28044_i > 0) {
                b b3;
                if (packet23VehicleSpawn.type == 60 && (b3 = this.getEntityByID(packet23VehicleSpawn.field_28044_i)) instanceof net.minecraft.a.c.e) {
                    ((a)b2).S = (net.minecraft.a.c.e)b3;
                }
                b2.setVelocity((float)packet23VehicleSpawn.field_28047_e / 8000.0f, (float)packet23VehicleSpawn.field_28046_f / 8000.0f, (float)packet23VehicleSpawn.field_28045_g / 8000.0f);
            }
        }
    }

    @Override
    public void handleMobSpawn(Packet24MobSpawn packet24MobSpawn) {
        float f2 = (float)packet24MobSpawn.xPosition / 32.0f;
        float f3 = (float)packet24MobSpawn.yPosition / 32.0f;
        float f4 = (float)packet24MobSpawn.zPosition / 32.0f;
        float f5 = (float)(packet24MobSpawn.yaw * 360) / 256.0f;
        float f6 = (float)(packet24MobSpawn.pitch * 360) / 256.0f;
        net.minecraft.a.c.e e2 = (net.minecraft.a.c.e)EntityList.createEntity(packet24MobSpawn.type, this.mc.d);
        e2.serverPosX = packet24MobSpawn.xPosition;
        e2.serverPosY = packet24MobSpawn.yPosition;
        e2.serverPosZ = packet24MobSpawn.zPosition;
        e2.entityId = packet24MobSpawn.entityId;
        e2.b(f2, f3, f4, f5, f6);
        e2.isMultiplayerEntity = true;
        this.worldClient.func_712_a(packet24MobSpawn.entityId, e2);
        List list = packet24MobSpawn.getMetadata();
        if (list != null) {
            e2.getDataWatcher().updateWatchedObjectsFromList(list);
        }
    }

    @Override
    public void func_21146_a(Packet25EntityPainting packet25EntityPainting) {
        net.minecraft.a.c.a a2 = new net.minecraft.a.c.a(this.worldClient, packet25EntityPainting.xPosition, packet25EntityPainting.yPosition, packet25EntityPainting.zPosition, packet25EntityPainting.direction, packet25EntityPainting.title);
        this.worldClient.func_712_a(packet25EntityPainting.entityId, a2);
    }

    @Override
    public void func_6498_a(Packet28EntityVelocity packet28EntityVelocity) {
        b b2 = this.getEntityByID(packet28EntityVelocity.entityId);
        if (b2 == null) {
            return;
        }
        b2.setVelocity((float)packet28EntityVelocity.motionX / 8000.0f, (float)packet28EntityVelocity.motionY / 8000.0f, (float)packet28EntityVelocity.motionZ / 8000.0f);
    }

    @Override
    public void handleDestroyEntity(Packet29DestroyEntity packet29DestroyEntity) {
        this.worldClient.releaseEntitySkin(packet29DestroyEntity.entityId);
    }

    @Override
    public void handleEntity(Packet30Entity packet30Entity) {
        b b2 = this.getEntityByID(packet30Entity.entityId);
        if (b2 == null) {
            return;
        }
        b2.serverPosX += packet30Entity.xPosition;
        b2.serverPosY += packet30Entity.yPosition;
        b2.serverPosZ += packet30Entity.zPosition;
        float f2 = (float)b2.serverPosX / 32.0f;
        float f3 = (float)b2.serverPosY / 32.0f;
        float f4 = (float)b2.serverPosZ / 32.0f;
        float f5 = packet30Entity.rotating ? (float)(packet30Entity.yaw * 360) / 256.0f : b2.n;
        float f6 = packet30Entity.rotating ? (float)(packet30Entity.pitch * 360) / 256.0f : b2.o;
        b2.setPositionAndRotation2(f2, f3, f4, f5, f6, 3);
    }

    @Override
    public void handleEntityTeleport(Packet34EntityTeleport packet34EntityTeleport) {
        b b2 = this.getEntityByID(packet34EntityTeleport.entityId);
        if (b2 == null) {
            return;
        }
        b2.serverPosX = packet34EntityTeleport.xPosition;
        b2.serverPosY = packet34EntityTeleport.yPosition;
        b2.serverPosZ = packet34EntityTeleport.zPosition;
        float f2 = (float)b2.serverPosX / 32.0f;
        float f3 = (float)b2.serverPosY / 32.0f + 0.015625f;
        float f4 = (float)b2.serverPosZ / 32.0f;
        float f5 = (float)(packet34EntityTeleport.yaw * 360) / 256.0f;
        float f6 = (float)(packet34EntityTeleport.pitch * 360) / 256.0f;
        b2.setPositionAndRotation2(f2, f3, f4, f5, f6, 3);
    }

    @Override
    public void func_9447_a(Packet38EntityStatus packet38EntityStatus) {
        b b2 = this.getEntityByID(packet38EntityStatus.entityId);
        if (b2 != null) {
            b2.handleHealthUpdate(packet38EntityStatus.entityStatus);
        }
    }

    @Override
    public void func_21148_a(Packet40EntityMetadata packet40EntityMetadata) {
        b b2 = this.getEntityByID(packet40EntityMetadata.entityId);
        if (b2 != null && packet40EntityMetadata.func_21047_b() != null) {
            b2.getDataWatcher().updateWatchedObjectsFromList(packet40EntityMetadata.func_21047_b());
        }
    }

    @Override
    public void handleLevelData(Packet50LevelData packet50LevelData) {
        byte[] byArray = packet50LevelData.message2;
        byte[] byArray2 = packet50LevelData.meta;
        this.levelProgress = packet50LevelData.message3;
        this.blockData = byArray;
        this.blockMetaData = byArray2;
    }

    @Override
    public void handleLevelFinalized(Packet51LevelFinalize packet51LevelFinalize) {
        System.out.println("Size: " + this.blockData.length + ", Meta: " + this.blockMetaData.length);
        try {
            this.levelData.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        byte[] byArray = null;
        byArray = net.minecraft.a.a.a.decompress(new ByteArrayInputStream(this.blockData));
        int n2 = packet51LevelFinalize.worldTime;
        byte[] byArray2 = net.minecraft.a.a.a.decompress(new ByteArrayInputStream(this.blockMetaData));
        this.mc.p.a("");
        this.mc.p.b("Loading level..");
        this.mc.f.canMove = true;
        g g2 = this.mc.setLevelThemes(this.mc.d, packet51LevelFinalize.levelSize, packet51LevelFinalize.levelShape, packet51LevelFinalize.levelType, packet51LevelFinalize.levelTheme, n2, byArray, packet51LevelFinalize.width, packet51LevelFinalize.height, packet51LevelFinalize.depth, byArray2);
        this.levelData = null;
        g2.multiplayerWorld = true;
        this.mc.a(g2);
        this.mc.e.a();
        System.gc();
        this.mc.f.entityId = this.savedId;
        this.loggedIn = true;
        if (!this.field_1210_g) {
            if (this.mc.f.h <= 0.0f || this.mc.f.i < 0.0f || this.mc.f.j <= 0.0f) {
                this.mc.f.b(this.spawnX, this.spawnY, this.spawnZ, 0.0f, 1.0f);
                this.mc.f.setLocationAndAngles(this.spawnX, this.spawnY, this.spawnZ, 0.0f, 1.0f);
            }
            this.mc.f.e = this.mc.f.h;
            this.mc.f.f = this.mc.f.i;
            this.mc.f.g = this.mc.f.j;
            this.field_1210_g = true;
            this.mc.a((i)null);
        }
    }

    @Override
    public void handleMultiBlockChange(Packet52MultiBlockChange packet52MultiBlockChange) {
    }

    @Override
    public void handleBlockChange(Packet53BlockChange packet53BlockChange) {
        this.worldClient.b(packet53BlockChange.xPosition, packet53BlockChange.yPosition, packet53BlockChange.zPosition, packet53BlockChange.type);
        this.worldClient.setBlockMetadata(packet53BlockChange.xPosition, packet53BlockChange.yPosition, packet53BlockChange.zPosition, packet53BlockChange.metadata);
        this.mc.e.a(packet53BlockChange.xPosition, packet53BlockChange.yPosition, packet53BlockChange.zPosition);
    }

    @Override
    public void handleScore(Packet71Score packet71Score) {
        b b2 = this.getEntityByID(packet71Score.entityID);
        if (b2 != null && b2 instanceof net.minecraft.a.c.e.a) {
            ((net.minecraft.a.c.e.a)b2).P = packet71Score.score;
        }
    }

    @Override
    public void func_20087_a(Packet100OpenWindow packet100OpenWindow) {
        if (packet100OpenWindow.inventoryType == 0) {
            InventoryBasic inventoryBasic = new InventoryBasic(packet100OpenWindow.windowTitle, packet100OpenWindow.slotsCount);
            this.mc.f.a(inventoryBasic);
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        } else if (packet100OpenWindow.inventoryType == 2) {
            net.minecraft.a.a.b.a.b b2 = new net.minecraft.a.a.b.a.b();
            this.mc.f.a(b2);
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        } else if (packet100OpenWindow.inventoryType == 1) {
            net.minecraft.client.g.a a2 = this.mc.f;
            this.mc.f.displayWorkbenchGUI(a.a.a((double)a2.h), a.a.a((double)a2.i), a.a.a((double)a2.j));
            this.mc.f.craftingInventory.windowId = packet100OpenWindow.windowId;
        }
    }

    @Override
    public void func_20092_a(Packet101CloseWindow packet101CloseWindow) {
        this.mc.f.closeScreen();
    }

    @Override
    public void func_20088_a(Packet103SetSlot packet103SetSlot) {
        if (packet103SetSlot.windowId == -1) {
            this.mc.f.b.setItemStack(packet103SetSlot.myItemStack);
        } else if (packet103SetSlot.windowId == 0 && packet103SetSlot.itemSlot >= 36 && packet103SetSlot.itemSlot < 45) {
            k k2 = this.mc.f.inventorySlots.getSlot(packet103SetSlot.itemSlot).getStack();
            if (packet103SetSlot.myItemStack != null && (k2 == null || k2.a < packet103SetSlot.myItemStack.a)) {
                packet103SetSlot.myItemStack.b = 5;
            }
            this.mc.f.inventorySlots.putStackInSlot(packet103SetSlot.itemSlot, packet103SetSlot.myItemStack);
        } else if (packet103SetSlot.windowId == this.mc.f.craftingInventory.windowId) {
            this.mc.f.craftingInventory.putStackInSlot(packet103SetSlot.itemSlot, packet103SetSlot.myItemStack);
        }
    }

    @Override
    public void func_20094_a(Packet104WindowItems packet104WindowItems) {
        if (packet104WindowItems.windowId == 0) {
            this.mc.f.inventorySlots.putStacksInSlots(packet104WindowItems.itemStack);
        } else if (packet104WindowItems.windowId == this.mc.f.craftingInventory.windowId) {
            this.mc.f.craftingInventory.putStacksInSlots(packet104WindowItems.itemStack);
        }
    }

    @Override
    public void func_20090_a(Packet105UpdateProgressbar packet105UpdateProgressbar) {
        this.registerPacket(packet105UpdateProgressbar);
        if (this.mc.f.craftingInventory != null && this.mc.f.craftingInventory.windowId == packet105UpdateProgressbar.windowId) {
            this.mc.f.craftingInventory.func_20112_a(packet105UpdateProgressbar.progressBar, packet105UpdateProgressbar.progressBarValue);
        }
    }

    @Override
    public void func_20089_a(Packet106Transaction packet106Transaction) {
        Container container = null;
        if (packet106Transaction.windowId == 0) {
            container = this.mc.f.inventorySlots;
        } else if (packet106Transaction.windowId == this.mc.f.craftingInventory.windowId) {
            container = this.mc.f.craftingInventory;
        }
        if (container != null) {
            if (packet106Transaction.field_20030_c) {
                container.func_20113_a(packet106Transaction.field_20028_b);
            } else {
                container.func_20110_b(packet106Transaction.field_20028_b);
                this.addToSendQueue(new Packet106Transaction(packet106Transaction.windowId, packet106Transaction.field_20028_b, true));
            }
        }
    }

    @Override
    public void handleKickDisconnect(Packet255KickDisconnect packet255KickDisconnect) {
        this.netManager.networkShutdown("Disconnected", new Object[0]);
        this.disconnected = true;
        this.mc.a(new GuiConnectFailed("Disconnected!", packet255KickDisconnect.reason, new Object[]{packet255KickDisconnect.reason}));
        this.mc.a((g)null);
    }

    public void func_28117_a(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.netManager.addToSendQueue(packet);
        this.netManager.func_28142_c();
    }

    private b getEntityByID(int n2) {
        if (n2 == this.mc.f.entityId) {
            return this.mc.f;
        }
        return this.worldClient.func_709_b(n2);
    }
}

