/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.net.NetHandler;
import net.minecraft.client.net.packet.Packet;

public class Packet60Explosion
extends Packet {
    public float explosionX;
    public float explosionY;
    public float explosionZ;
    public float explosionSize;
    public Set destroyedBlockPositions;

    public Packet60Explosion() {
    }

    public Packet60Explosion(float f2, float f3, float f4, float f5, Set set) {
        this.explosionX = f2;
        this.explosionY = f3;
        this.explosionZ = f4;
        this.explosionSize = f5;
        this.destroyedBlockPositions = new HashSet(set);
    }

    @Override
    public void readPacketData(DataInputStream dataInputStream) throws IOException {
        this.explosionX = dataInputStream.readFloat();
        this.explosionY = dataInputStream.readFloat();
        this.explosionZ = dataInputStream.readFloat();
        this.explosionSize = dataInputStream.readFloat();
        int n2 = dataInputStream.readInt();
        this.destroyedBlockPositions = new HashSet();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.destroyedBlockPositions.add(Integer.valueOf(dataInputStream.readByte()));
        }
    }

    @Override
    public void writePacketData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat(this.explosionX);
        dataOutputStream.writeFloat(this.explosionY);
        dataOutputStream.writeFloat(this.explosionZ);
        dataOutputStream.writeFloat(this.explosionSize);
        dataOutputStream.writeInt(this.destroyedBlockPositions.size());
        for (Integer n2 : this.destroyedBlockPositions) {
            dataOutputStream.writeByte(n2);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.func_12245_a(this);
    }

    @Override
    public int getPacketSize() {
        return 16 + this.destroyedBlockPositions.size() * 3;
    }
}

