/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.game.entity;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.a.b.k;
import net.minecraft.client.net.packet.Packet;
import net.minecraft.game.entity.ChunkCoordinates;
import net.minecraft.game.entity.WatchableObject;

public class DataWatcher {
    private static final HashMap dataTypes = new HashMap();
    private final Map watchedObjects = new HashMap();
    private boolean objectChanged;

    public void addObject(int n2, Object object) {
        Integer n3 = (Integer)dataTypes.get(object.getClass());
        if (n3 == null) {
            throw new IllegalArgumentException("Unknown data type: " + object.getClass());
        }
        if (n2 > 31) {
            throw new IllegalArgumentException("Data value id is too big with " + n2 + "! (Max is " + 31 + ")");
        }
        if (this.watchedObjects.containsKey(n2)) {
            throw new IllegalArgumentException("Duplicate id value for " + n2 + "!");
        }
        WatchableObject watchableObject = new WatchableObject(n3, n2, object);
        this.watchedObjects.put(n2, watchableObject);
    }

    public byte getWatchableObjectByte(int n2) {
        return (Byte)((WatchableObject)this.watchedObjects.get(n2)).getObject();
    }

    public int getWatchableObjectInt(int n2) {
        return (Integer)((WatchableObject)this.watchedObjects.get(n2)).getObject();
    }

    public String getWatchableObjectString(int n2) {
        return (String)((WatchableObject)this.watchedObjects.get(n2)).getObject();
    }

    public void updateObject(int n2, Object object) {
        WatchableObject watchableObject = (WatchableObject)this.watchedObjects.get(n2);
        if (!object.equals(watchableObject.getObject())) {
            watchableObject.setObject(object);
            watchableObject.setWatching(true);
            this.objectChanged = true;
        }
    }

    public static void writeObjectsInListToStream(List list, DataOutputStream dataOutputStream) throws IOException {
        if (list != null) {
            for (WatchableObject watchableObject : list) {
                DataWatcher.writeWatchableObject(dataOutputStream, watchableObject);
            }
        }
        dataOutputStream.writeByte(127);
    }

    public void writeWatchableObjects(DataOutputStream dataOutputStream) throws IOException {
        for (WatchableObject watchableObject : this.watchedObjects.values()) {
            DataWatcher.writeWatchableObject(dataOutputStream, watchableObject);
        }
        dataOutputStream.writeByte(127);
    }

    private static void writeWatchableObject(DataOutputStream dataOutputStream, WatchableObject watchableObject) throws IOException {
        int n2 = (watchableObject.getObjectType() << 5 | watchableObject.getDataValueId() & 0x1F) & 0xFF;
        dataOutputStream.writeByte(n2);
        switch (watchableObject.getObjectType()) {
            case 0: {
                dataOutputStream.writeByte(((Byte)watchableObject.getObject()).byteValue());
                break;
            }
            case 1: {
                dataOutputStream.writeShort(((Short)watchableObject.getObject()).shortValue());
                break;
            }
            case 2: {
                dataOutputStream.writeInt((Integer)watchableObject.getObject());
                break;
            }
            case 3: {
                dataOutputStream.writeFloat(((Float)watchableObject.getObject()).floatValue());
                break;
            }
            case 4: {
                Packet.writeString((String)watchableObject.getObject(), dataOutputStream);
                break;
            }
            case 5: {
                k k2 = (k)watchableObject.getObject();
                dataOutputStream.writeShort(k2.a().ap);
                dataOutputStream.writeByte(k2.a);
                dataOutputStream.writeShort(k2.d);
                break;
            }
            case 6: {
                ChunkCoordinates chunkCoordinates = (ChunkCoordinates)watchableObject.getObject();
                dataOutputStream.writeInt(chunkCoordinates.x);
                dataOutputStream.writeInt(chunkCoordinates.y);
                dataOutputStream.writeInt(chunkCoordinates.z);
            }
        }
    }

    public static List readWatchableObjects(DataInputStream dataInputStream) throws IOException {
        ArrayList<WatchableObject> arrayList = null;
        byte by = dataInputStream.readByte();
        while (by != 127) {
            if (arrayList == null) {
                arrayList = new ArrayList<WatchableObject>();
            }
            int n2 = (by & 0xE0) >> 5;
            int n3 = by & 0x1F;
            WatchableObject watchableObject = null;
            switch (n2) {
                case 0: {
                    watchableObject = new WatchableObject(n2, n3, dataInputStream.readByte());
                    break;
                }
                case 1: {
                    watchableObject = new WatchableObject(n2, n3, dataInputStream.readShort());
                    break;
                }
                case 2: {
                    watchableObject = new WatchableObject(n2, n3, dataInputStream.readInt());
                    break;
                }
                case 3: {
                    watchableObject = new WatchableObject(n2, n3, Float.valueOf(dataInputStream.readFloat()));
                    break;
                }
                case 4: {
                    watchableObject = new WatchableObject(n2, n3, Packet.readString(dataInputStream, 64));
                    break;
                }
                case 5: {
                    short s2 = dataInputStream.readShort();
                    byte by2 = dataInputStream.readByte();
                    short s3 = dataInputStream.readShort();
                    watchableObject = new WatchableObject(n2, n3, new k(s2, (int)by2, (int)s3));
                    break;
                }
                case 6: {
                    int n4 = dataInputStream.readInt();
                    int n5 = dataInputStream.readInt();
                    int n6 = dataInputStream.readInt();
                    watchableObject = new WatchableObject(n2, n3, new ChunkCoordinates(n4, n5, n6));
                }
            }
            arrayList.add(watchableObject);
            by = dataInputStream.readByte();
        }
        return arrayList;
    }

    public void updateWatchedObjectsFromList(List list) {
        for (WatchableObject watchableObject : list) {
            WatchableObject watchableObject2 = (WatchableObject)this.watchedObjects.get(watchableObject.getDataValueId());
            if (watchableObject2 == null) continue;
            watchableObject2.setObject(watchableObject.getObject());
        }
    }

    static Class _mthclass$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        dataTypes.put(Byte.class, 0);
        dataTypes.put(Short.class, 1);
        dataTypes.put(Integer.class, 2);
        dataTypes.put(Float.class, 3);
        dataTypes.put(String.class, 4);
        dataTypes.put(k.class, 5);
        dataTypes.put(ChunkCoordinates.class, 6);
    }
}

