/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.net.NetHandler;
import net.minecraft.client.net.packet.Packet;

public class Packet1Login
extends Packet {
    public int protocolVersion;
    public String username;
    public long mapSeed;
    public String motd;
    public String srvName;

    public Packet1Login() {
        this.isChunkDataPacket = true;
    }

    public Packet1Login(String string, int n2) {
        this.isChunkDataPacket = true;
        this.username = string;
        this.protocolVersion = n2;
        this.motd = "Loading level..";
        this.srvName = "Loading server..";
    }

    @Override
    public void readPacketData(DataInputStream dataInputStream) throws IOException {
        this.protocolVersion = dataInputStream.readInt();
        this.username = Packet1Login.readString(dataInputStream, 16);
        this.mapSeed = dataInputStream.readLong();
        this.motd = Packet1Login.readString(dataInputStream, 64);
        this.srvName = Packet1Login.readString(dataInputStream, 64);
    }

    @Override
    public void writePacketData(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.protocolVersion);
        Packet1Login.writeString(this.username, dataOutputStream);
        dataOutputStream.writeLong(this.mapSeed);
        Packet1Login.writeString(this.motd, dataOutputStream);
        Packet1Login.writeString(this.srvName, dataOutputStream);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleLogin(this);
    }

    @Override
    public int getPacketSize() {
        return 4 + this.username.length() + 8 + this.motd.length() + this.srvName.length();
    }
}

