/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.net;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.net.NetHandler;
import net.minecraft.client.net.NetworkMasterThread;
import net.minecraft.client.net.NetworkReaderThread;
import net.minecraft.client.net.NetworkWriterThread;
import net.minecraft.client.net.ThreadCloseConnection;
import net.minecraft.client.net.packet.Packet;

public class NetworkManager {
    public static final Object threadSyncObject = new Object();
    public static int numReadThreads;
    public static int numWriteThreads;
    private Object sendQueueLock = new Object();
    private Socket networkSocket;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private NetHandler netHandler;
    private Thread writeThread;
    private Thread readThread;
    private boolean isTerminating = false;
    private String terminationReason = "";
    private boolean isServerTerminating = false;
    private boolean isRunning = true;
    private List readPackets = Collections.synchronizedList(new ArrayList());
    private List dataPackets = Collections.synchronizedList(new ArrayList());
    private final SocketAddress remoteSocketAddress;
    private int field_20100_w = 50;
    private int timeSinceLastRead = 0;
    private int sendQueueByteLength = 0;
    private Object[] field_20101_t;
    private List chunkDataPackets = Collections.synchronizedList(new ArrayList());
    public int chunkDataSendCounter = 0;
    public static int[] field_28145_d;
    public static int[] field_28144_e;

    public NetworkManager(Socket socket, String string, NetHandler netHandler) throws IOException {
        this.networkSocket = socket;
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.netHandler = netHandler;
        try {
            socket.setSoTimeout(30000);
            socket.setTrafficClass(24);
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            System.err.println(socketException.getMessage());
        }
        this.socketInputStream = new DataInputStream(socket.getInputStream());
        this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 5120));
        this.readThread = new NetworkReaderThread(this, string + " read thread");
        this.writeThread = new NetworkWriterThread(this, string + " write thread");
        this.readThread.start();
        this.writeThread.start();
    }

    static boolean isRunning(NetworkManager networkManager) {
        return networkManager.isRunning;
    }

    public void networkShutdown(String string, Object[] objectArray) {
        if (!this.isRunning) {
            return;
        }
        this.isTerminating = true;
        this.terminationReason = string;
        this.field_20101_t = objectArray;
        new NetworkMasterThread(this).start();
        this.isRunning = false;
        try {
            this.socketInputStream.close();
            this.socketInputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socketOutputStream.close();
            this.socketOutputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.networkSocket.close();
            this.networkSocket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static boolean isServerTerminating(NetworkManager networkManager) {
        return networkManager.isServerTerminating;
    }

    static DataOutputStream func_28140_f(NetworkManager networkManager) {
        return networkManager.socketOutputStream;
    }

    static boolean func_28138_e(NetworkManager networkManager) {
        return networkManager.isTerminating;
    }

    static void func_30005_a(NetworkManager networkManager, Exception exception) {
        networkManager.onNetworkError(exception);
    }

    private void onNetworkError(Exception exception) {
        exception.printStackTrace();
        this.networkShutdown("Server shut down?", new Object[]{"Internal exception: " + exception.toString()});
    }

    static Thread getReadThread(NetworkManager networkManager) {
        return networkManager.readThread;
    }

    static Thread getWriteThread(NetworkManager networkManager) {
        return networkManager.writeThread;
    }

    static boolean readNetworkPacket(NetworkManager networkManager) {
        return networkManager.readPacket();
    }

    static boolean sendNetworkPacket(NetworkManager networkManager) {
        return networkManager.sendPacket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPacket() {
        boolean bl;
        block10: {
            bl = false;
            try {
                Packet packet;
                Object object;
                if (!(this.dataPackets.isEmpty() || this.chunkDataSendCounter != 0 && System.currentTimeMillis() - ((Packet)this.dataPackets.get((int)0)).creationTimeMillis < (long)this.chunkDataSendCounter)) {
                    object = this.sendQueueLock;
                    synchronized (object) {
                        packet = (Packet)this.dataPackets.remove(0);
                        this.sendQueueByteLength -= packet.getPacketSize() + 1;
                    }
                    Packet.writePacket(packet, this.socketOutputStream);
                    int n2 = packet.getPacketId();
                    field_28144_e[n2] = field_28144_e[n2] + (packet.getPacketSize() + 1);
                    bl = true;
                }
                if (this.field_20100_w-- > 0 || this.chunkDataPackets.isEmpty() || this.chunkDataSendCounter != 0 && System.currentTimeMillis() - ((Packet)this.chunkDataPackets.get((int)0)).creationTimeMillis < (long)this.chunkDataSendCounter) break block10;
                object = this.sendQueueLock;
                synchronized (object) {
                    packet = (Packet)this.chunkDataPackets.remove(0);
                    this.sendQueueByteLength -= packet.getPacketSize() + 1;
                }
                Packet.writePacket(packet, this.socketOutputStream);
                int n3 = packet.getPacketId();
                field_28144_e[n3] = field_28144_e[n3] + (packet.getPacketSize() + 1);
                this.field_20100_w = 0;
                bl = true;
            }
            catch (Exception exception) {
                if (!this.isTerminating) {
                    this.onNetworkError(exception);
                }
                return false;
            }
        }
        return bl;
    }

    private boolean readPacket() {
        boolean bl = false;
        try {
            Packet packet = Packet.readPacket(this.socketInputStream, this.netHandler.isServerHandler());
            if (packet != null) {
                if (this.chunkDataSendCounter > 0 && packet.isChunkDataPacket) {
                    int n2 = packet.getPacketId();
                    field_28145_d[n2] = field_28145_d[n2] + (packet.getPacketSize() + 1);
                    this.readPackets.add(packet);
                    bl = true;
                } else {
                    int n3 = packet.getPacketId();
                    field_28145_d[n3] = field_28145_d[n3] + (packet.getPacketSize() + 1);
                    this.readPackets.add(packet);
                    bl = true;
                }
            } else {
                this.networkShutdown("End of stream!", new Object[0]);
            }
        }
        catch (Exception exception) {
            if (!this.isTerminating) {
                this.onNetworkError(exception);
            }
            return false;
        }
        return bl;
    }

    public void processReadPackets() {
        if (this.sendQueueByteLength > 0x200000) {
            this.networkShutdown("Overflow!!!!!", new Object[0]);
        }
        if (this.readPackets.isEmpty()) {
            if (this.timeSinceLastRead++ == 1200) {
                this.networkShutdown("Timed out!", new Object[0]);
            }
        } else {
            this.timeSinceLastRead = 0;
        }
        int n2 = 100;
        while (!this.readPackets.isEmpty() && n2-- >= 0) {
            Packet packet = (Packet)this.readPackets.remove(0);
            packet.processPacket(this.netHandler);
        }
        this.wakeThreads();
        if (this.isTerminating && this.readPackets.isEmpty()) {
            this.netHandler.handleErrorMessage(this.terminationReason, this.field_20101_t);
        }
    }

    public void wakeThreads() {
        this.readThread.interrupt();
        this.writeThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSendQueue(Packet packet) {
        if (this.isServerTerminating) {
            return;
        }
        Object object = this.sendQueueLock;
        synchronized (object) {
            this.sendQueueByteLength += packet.getPacketSize() + 1;
            if (packet.isChunkDataPacket) {
                this.chunkDataPackets.add(packet);
            } else {
                this.dataPackets.add(packet);
            }
        }
    }

    public void func_28142_c() {
        this.wakeThreads();
        this.isServerTerminating = true;
        this.readThread.interrupt();
        new ThreadCloseConnection(this).start();
    }

    static {
        field_28145_d = new int[256];
        field_28144_e = new int[256];
    }
}

