/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.MinecraftException;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.Explosion;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.path.PathEntity;
import com.mojang.minecraft.entity.path.Pathfinder;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.enums.EnumSkyBlock;
import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.NextTickListEntry;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.level.chunk.ChunkCache;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkLoader;
import com.mojang.minecraft.level.chunk.ChunkProviderCorruption;
import com.mojang.minecraft.level.chunk.ChunkProviderDesert;
import com.mojang.minecraft.level.chunk.ChunkProviderGenerate;
import com.mojang.minecraft.level.chunk.ChunkProviderIndev;
import com.mojang.minecraft.level.chunk.ChunkProviderLoadOrGenerate;
import com.mojang.minecraft.level.chunk.ChunkProviderSky;
import com.mojang.minecraft.level.chunk.MetadataChunkBlock;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.level.region.RegionFileCache;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.CompressedStreamTools;
import com.mojang.minecraft.util.MathHelper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class World
implements IBlockAccess {
    public static final int NORMAL = 0;
    public static final int FLOATING = 1;
    public static final int CORRUPTION = 2;
    public static final int DESERT = 3;
    public static final int INDEV = 4;
    public static final HashMap<Integer, String> TYPENAMES = new HashMap<Integer, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(0, "NORMAL");
            this.put(1, "FLOATING");
            this.put(2, "CORRUPTION");
            this.put(3, "DESERT");
            this.put(4, "2D PERLIN");
        }
    };
    public float cloudHeight = 108.0f;
    private List<MetadataChunkBlock> field_1025_z;
    public List<Entity> field_1050_a;
    private List<Object> field_1024_A;
    private TreeSet<NextTickListEntry> field_1023_B;
    private Set<NextTickListEntry> field_1022_C;
    public List<Object> field_1049_b;
    public long worldTime;
    public boolean snowCovered;
    private long field_1021_D;
    private long field_1020_E;
    private long field_1019_F;
    public int skyLightSubtracted;
    protected int field_1045_f;
    protected int field_1044_g;
    public boolean etitingBlocks;
    public static float[] field_1042_i = new float[16];
    private final long field_1018_G;
    protected int field_1041_j;
    public List<EntityPlayer> playerEntities;
    public int difficulty;
    public Object field_1038_m;
    public Random rand;
    public int spawnX;
    public int spawnY;
    public int spawnZ;
    public boolean field_1033_r;
    protected List<IWorldAccess> worldAccesses;
    public IChunkProvider chunkProvider;
    public File field_1031_t;
    public long randomSeed;
    private NBTTagCompound nbtCompoundPlayer;
    public long sizeOnDisk;
    public final String field_1028_w;
    public boolean field_1027_x;
    private ArrayList<AxisAlignedBB> field_1015_J;
    private Set<ChunkCoordIntPair> field_1014_K;
    private int ambienceChance;
    private List<Entity> field_1012_M;
    public boolean multiplayerWorld;
    public boolean cheatsDisabled;
    public int worldType;

    static {
        float f = 0.05f;
        int i = 0;
        while (i <= 15) {
            float f1 = 1.0f - (float)i / 15.0f;
            World.field_1042_i[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            ++i;
        }
    }

    public static NBTTagCompound func_629_a(File file, String s) {
        File file1 = new File(file, "saves");
        File file2 = new File(file1, s);
        if (!file2.exists()) {
            return null;
        }
        File file3 = new File(file2, "level.dat");
        if (file3.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file3));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_743_k("Data");
                return nbttagcompound1;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void func_615_b(File file, String s) {
        File file1 = new File(file, "saves");
        File file2 = new File(file1, s);
        if (!file2.exists()) {
            return;
        }
        World.func_653_a(file2.listFiles());
        file2.delete();
    }

    private static void func_653_a(File[] afile) {
        RegionFileCache.clear();
        int i = 0;
        while (i < afile.length) {
            if (afile[i].isDirectory()) {
                World.func_653_a(afile[i].listFiles());
            }
            afile[i].delete();
            ++i;
        }
    }

    public World(File file, String s, boolean snow, boolean cheatsDisabled, int worldType) {
        this(file, s, new Random().nextLong(), snow, cheatsDisabled, worldType);
    }

    public World(String s) {
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.field_1050_a = new ArrayList<Entity>();
        this.field_1024_A = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = false;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.field_1041_j = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.rand = new Random();
        this.field_1033_r = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.field_1014_K = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s;
        this.chunkProvider = this.getWorldChunkProvider(this.field_1031_t);
        this.func_644_f();
    }

    public World(File file, String s, long l, boolean snowCovereds, boolean cheatsDisableds, int worldTypes) {
        this.cheatsDisabled = cheatsDisableds;
        this.field_1025_z = new ArrayList<MetadataChunkBlock>();
        this.field_1050_a = new ArrayList<Entity>();
        this.field_1024_A = new ArrayList<Object>();
        this.field_1023_B = new TreeSet();
        this.field_1022_C = new HashSet<NextTickListEntry>();
        this.field_1049_b = new ArrayList<Object>();
        this.worldTime = 0L;
        this.snowCovered = snowCovereds;
        this.worldType = worldTypes;
        this.field_1021_D = 0x88BBFFL;
        this.field_1020_E = 12638463L;
        this.field_1019_F = 0xFFFFFFL;
        this.skyLightSubtracted = 0;
        this.field_1045_f = new Random().nextInt();
        this.field_1044_g = 1013904223;
        this.etitingBlocks = false;
        this.field_1018_G = System.currentTimeMillis();
        this.field_1041_j = 40;
        this.playerEntities = new ArrayList<EntityPlayer>();
        this.rand = new Random();
        this.field_1033_r = false;
        this.worldAccesses = new ArrayList<IWorldAccess>();
        this.randomSeed = 0L;
        this.sizeOnDisk = 0L;
        this.field_1015_J = new ArrayList();
        this.field_1014_K = new HashSet<ChunkCoordIntPair>();
        this.ambienceChance = this.rand.nextInt(12000);
        this.field_1012_M = new ArrayList<Entity>();
        this.multiplayerWorld = false;
        this.field_1028_w = s;
        file.mkdirs();
        this.field_1031_t = new File(file, s);
        this.field_1031_t.mkdirs();
        try {
            File file1 = new File(this.field_1031_t, "session.lock");
            DataOutputStream dataoutputstream = new DataOutputStream(new FileOutputStream(file1));
            try {
                dataoutputstream.writeLong(this.field_1018_G);
            }
            finally {
                dataoutputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new RuntimeException("Failed to check session lock, aborting");
        }
        File file2 = new File(this.field_1031_t, "level.dat");
        boolean bl = this.field_1033_r = !file2.exists();
        if (file2.exists()) {
            try {
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_1138_a(new FileInputStream(file2));
                NBTTagCompound nbttagcompound1 = nbttagcompound.func_743_k("Data");
                this.randomSeed = nbttagcompound1.func_764_f("RandomSeed");
                this.spawnX = nbttagcompound1.func_756_e("SpawnX");
                this.spawnY = nbttagcompound1.func_756_e("SpawnY");
                this.spawnZ = nbttagcompound1.func_756_e("SpawnZ");
                this.worldTime = nbttagcompound1.func_764_f("Time");
                this.sizeOnDisk = nbttagcompound1.func_764_f("SizeOnDisk");
                this.snowCovered = nbttagcompound1.tag("SnowCovered");
                this.cheatsDisabled = nbttagcompound1.tag("cheatsDisabled");
                this.worldType = nbttagcompound1.tag("isFloating") ? 1 : nbttagcompound1.func_756_e("WorldType");
                if (nbttagcompound1.func_751_b("Player")) {
                    this.nbtCompoundPlayer = nbttagcompound1.func_743_k("Player");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        boolean flag = false;
        if (this.randomSeed == 0L) {
            this.randomSeed = l;
            flag = true;
        }
        this.chunkProvider = this.getWorldChunkProvider(this.field_1031_t);
        if (flag) {
            this.field_1027_x = true;
            this.spawnX = 0;
            this.spawnY = 64;
            this.spawnZ = 0;
            while (!this.func_703_f(this.spawnX, this.spawnZ)) {
                this.spawnX += this.rand.nextInt(64) - this.rand.nextInt(64);
                this.spawnZ += this.rand.nextInt(64) - this.rand.nextInt(64);
            }
            this.field_1027_x = false;
        }
        this.func_644_f();
    }

    protected IChunkProvider getWorldChunkProvider(File file) {
        if (this.worldType == 1) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderSky(this, this.randomSeed));
        }
        if (this.worldType == 2) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderCorruption(this, this.randomSeed));
        }
        if (this.worldType == 3) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderDesert(this, this.randomSeed));
        }
        if (this.worldType == 4) {
            return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderIndev(this, this.randomSeed));
        }
        return new ChunkProviderLoadOrGenerate(this, new ChunkLoader(file, true), new ChunkProviderGenerate(this, this.randomSeed));
    }

    public void func_622_a() {
        if (this.spawnY <= 0) {
            this.spawnY = 64;
        }
        while (this.func_614_g(this.spawnX, this.spawnZ) == 0) {
            this.spawnX += this.rand.nextInt(8) - this.rand.nextInt(8);
            this.spawnZ += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
    }

    private boolean func_703_f(int i, int j) {
        int k = this.func_614_g(i, j);
        if (this.worldType == 1 || this.worldType == 2 || this.worldType == 3) {
            return k == Block.grass.blockID;
        }
        return k == Block.sand.blockID;
    }

    private int func_614_g(int i, int j) {
        int k = 63;
        while (this.getBlockId(i, k + 1, j) != 0) {
            ++k;
        }
        return this.getBlockId(i, k, j);
    }

    public void func_608_a(EntityPlayer entityplayer) {
        try {
            if (this.nbtCompoundPlayer != null) {
                entityplayer.func_368_e(this.nbtCompoundPlayer);
                this.nbtCompoundPlayer = null;
            }
            this.entityJoinedWorld(entityplayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void func_639_a(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.unknownBoolean2()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_594_b("Saving level");
        }
        this.func_669_m();
        if (iprogressupdate != null) {
            iprogressupdate.func_595_d("Saving chunks");
        }
        this.chunkProvider.booleanProgress(flag, iprogressupdate);
        if (iprogressupdate != null) {
            RegionFileCache.clear();
        }
    }

    public void setSpawn(int x, int y, int z) {
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
    }

    private void func_669_m() {
        this.func_663_l();
        File getName = new File(this.field_1031_t, "name.data");
        String lvlName = "New World";
        if (getName.exists()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(getName));
                lvlName = br.readLine().replace("\u0000", "");
                br.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setString("LevelName", lvlName);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setBool("SnowCovered", this.snowCovered);
        nbttagcompound.setBool("cheatsDisabled", this.cheatsDisabled);
        nbttagcompound.setInteger("WorldType", this.worldType);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        EntityPlayer entityplayer = null;
        if (this.playerEntities.size() > 0) {
            entityplayer = this.playerEntities.get(0);
        }
        if (entityplayer != null) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            entityplayer.func_363_d(nbttagcompound1);
            nbttagcompound.func_763_a("Player", nbttagcompound1);
        }
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.func_762_a("Data", nbttagcompound);
        try {
            File file = new File(this.field_1031_t, "level.dat_new");
            File file1 = new File(this.field_1031_t, "level.dat_old");
            File file2 = new File(this.field_1031_t, "level.dat");
            CompressedStreamTools.func_1143_a(nbttagcompound2, new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean func_650_a(int i) {
        if (!this.chunkProvider.unknownBoolean2()) {
            return true;
        }
        if (i == 0) {
            this.func_669_m();
        }
        return this.chunkProvider.booleanProgress(false, null);
    }

    @Override
    public int getBlockId(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 0;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        return this.getChunkFromChunkCoords(i >> 4, k >> 4).getBlockId(i & 0xF, j, k & 0xF);
    }

    public boolean blockExists(int i, int j, int k) {
        if (j < 0 || j >= 128) {
            return false;
        }
        return this.chunkExists(i >> 4, k >> 4);
    }

    public boolean checkChunksExist(int i, int j, int k, int l, int i1, int j1) {
        if (i1 < 0 || j >= 128) {
            return false;
        }
        i >>= 4;
        j >>= 4;
        k >>= 4;
        l >>= 4;
        i1 >>= 4;
        j1 >>= 4;
        int k1 = i;
        while (k1 <= l) {
            int l1 = k;
            while (l1 <= j1) {
                if (!this.chunkExists(k1, l1)) {
                    return false;
                }
                ++l1;
            }
            ++k1;
        }
        return true;
    }

    private boolean chunkExists(int i, int j) {
        return this.chunkProvider.unknownBoolean(i, j);
    }

    public Chunk getChunkFromBlockCoords(int i, int j) {
        return this.getChunkFromChunkCoords(i >> 4, j >> 4);
    }

    public Chunk getChunkFromChunkCoords(int i, int j) {
        return this.chunkProvider.getChunkAt(i, j);
    }

    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.setBlockIDWithMetadata(i & 0xF, j, k & 0xF, l, i1);
    }

    public boolean setBlock(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.func_1022_a(i & 0xF, j, k & 0xF, l);
    }

    @Override
    public Material getMaterialXYZ(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        if (l == 0) {
            return Material.air;
        }
        return Block.allBlocks[l].blockMaterial;
    }

    public boolean isAirBlock(int i, int j, int k) {
        int l = this.getBlockId(i, j, k);
        return l == 0;
    }

    @Override
    public int getBlockMetadata(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 0;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.func_1021_b(i &= 0xF, j, k &= 0xF);
    }

    public void setBlockMetadataWithNotify(int i, int j, int k, int l) {
        this.setBlockMetadata(i, j, k, l);
        this.notifyBlockChange(i, j, k, l);
    }

    public boolean setBlockMetadata(int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.func_1009_b(i &= 0xF, j, k &= 0xF, l);
        return true;
    }

    public boolean setBlockWithNotify(int i, int j, int k, int l) {
        if (this.setBlock(i, j, k, l)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int i, int j, int k, int l, int i1) {
        if (this.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).func_934_a(i, j, k);
            ++l;
        }
    }

    protected void notifyBlockChange(int i, int j, int k, int l) {
        this.markBlockNeedsUpdate(i, j, k);
        this.notifyBlocksOfNeighborChange(i, j, k, l);
    }

    public void func_680_f(int i, int j, int k, int l) {
        if (k > l) {
            int i1 = l;
            l = k;
            k = i1;
        }
        this.markBlocksDirty(i, k, j, i, l, j);
    }

    public void markBlocksDirty(int i, int j, int k, int l, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.worldAccesses.size()) {
            this.worldAccesses.get(k1).markBlockRangeNeedsUpdate(i, j, k, l, i1, j1);
            ++k1;
        }
    }

    public void notifyBlocksOfNeighborChange(int i, int j, int k, int l) {
        this.notifyBlockOfNeighborChange(i - 1, j, k, l);
        this.notifyBlockOfNeighborChange(i + 1, j, k, l);
        this.notifyBlockOfNeighborChange(i, j - 1, k, l);
        this.notifyBlockOfNeighborChange(i, j + 1, k, l);
        this.notifyBlockOfNeighborChange(i, j, k - 1, l);
        this.notifyBlockOfNeighborChange(i, j, k + 1, l);
    }

    private void notifyBlockOfNeighborChange(int i, int j, int k, int l) {
        if (this.etitingBlocks || this.multiplayerWorld) {
            return;
        }
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block != null) {
            block.onNeighborBlockChange(this, i, j, k, l);
        }
    }

    public boolean func_647_i(int i, int j, int k) {
        return this.getChunkFromChunkCoords(i >> 4, k >> 4).func_1007_c(i & 0xF, j, k & 0xF);
    }

    public int func_618_j(int i, int j, int k) {
        return this.func_699_a(i, j, k, true);
    }

    public int func_699_a(int i, int j, int k, boolean flag) {
        int l;
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return 15;
        }
        if (flag && ((l = this.getBlockId(i, j, k)) == Block.stairSingle.blockID || l == Block.tilledField.blockID)) {
            int j1 = this.func_699_a(i, j + 1, k, false);
            int k1 = this.func_699_a(i + 1, j, k, false);
            int l1 = this.func_699_a(i - 1, j, k, false);
            int i2 = this.func_699_a(i, j, k + 1, false);
            int j2 = this.func_699_a(i, j, k - 1, false);
            if (k1 > j1) {
                j1 = k1;
            }
            if (l1 > j1) {
                j1 = l1;
            }
            if (i2 > j1) {
                j1 = i2;
            }
            if (j2 > j1) {
                j1 = j2;
            }
            return j1;
        }
        if (j < 0) {
            return 0;
        }
        if (j >= 128) {
            int i1 = 15 - this.skyLightSubtracted;
            if (i1 < 0) {
                i1 = 0;
            }
            return i1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.func_1019_c(i &= 0xF, j, k &= 0xF, this.skyLightSubtracted);
    }

    public boolean func_708_k(int i, int j, int k) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        if (j >= 128) {
            return true;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        return chunk.func_1007_c(i &= 0xF, j, k &= 0xF);
    }

    public int func_666_c(int i, int j) {
        if (i < -32000000 || j < -32000000 || i >= 32000000 || j > 32000000) {
            return 0;
        }
        if (!this.chunkExists(i >> 4, j >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, j >> 4);
        return chunk.func_999_b(i & 0xF, j & 0xF);
    }

    public void func_631_a(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        int i1;
        if (!this.blockExists(i, j, k)) {
            return;
        }
        if (enumskyblock == EnumSkyBlock.Sky) {
            if (this.func_708_k(i, j, k)) {
                l = 15;
            }
        } else if (enumskyblock == EnumSkyBlock.Block && Block.lightValue[i1 = this.getBlockId(i, j, k)] > l) {
            l = Block.lightValue[i1];
        }
        if (this.getBlockLighting(enumskyblock, i, j, k) != l) {
            this.func_616_a(enumskyblock, i, j, k, i, j, k);
        }
    }

    public int getBlockLighting(EnumSkyBlock enumskyblock, int i, int j, int k) {
        if (j < 0 || j >= 128 || i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return enumskyblock.field_1722_c;
        }
        int l = i >> 4;
        int i1 = k >> 4;
        if (!this.chunkExists(l, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l, i1);
        return chunk.func_1025_a(enumskyblock, i & 0xF, j, k & 0xF);
    }

    public void func_664_b(EnumSkyBlock enumskyblock, int i, int j, int k, int l) {
        if (i < -32000000 || k < -32000000 || i >= 32000000 || k > 32000000) {
            return;
        }
        if (j < 0) {
            return;
        }
        if (j >= 128) {
            return;
        }
        if (!this.chunkExists(i >> 4, k >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        chunk.func_1011_a(enumskyblock, i & 0xF, j, k & 0xF, l);
        int i1 = 0;
        while (i1 < this.worldAccesses.size()) {
            this.worldAccesses.get(i1).func_934_a(i, j, k);
            ++i1;
        }
    }

    @Override
    public float getBrightness(int i, int j, int k) {
        return field_1042_i[this.func_618_j(i, j, k)];
    }

    public boolean func_624_b() {
        return this.skyLightSubtracted < 4;
    }

    public MovingObjectPosition clip(Vec3D vec3d, Vec3D vec3d1) {
        return this.func_642_a(vec3d, vec3d1, false);
    }

    public MovingObjectPosition func_642_a(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i = MathHelper.floor_double(vec3d1.xCoord);
        int j = MathHelper.floor_double(vec3d1.yCoord);
        int k = MathHelper.floor_double(vec3d1.zCoord);
        int l = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = 20;
        while (k1-- >= 0) {
            MovingObjectPosition movingobjectposition;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l == i && i1 == j && j1 == k) {
                return null;
            }
            double d = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d = (double)l + 1.0;
            }
            if (i < l) {
                d = (double)l + 0.0;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            }
            if (j < i1) {
                d1 = (double)i1 + 0.0;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            }
            if (k < j1) {
                d2 = (double)j1 + 0.0;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (d != 999.0) {
                d3 = (d - vec3d.xCoord) / d6;
            }
            if (d1 != 999.0) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (d2 != 999.0) {
                d5 = (d2 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i > l ? 4 : 5;
                vec3d.xCoord = d;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d2;
            }
            Vec3D vec3d2 = Vec3D.newVectorAndAddToPool(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int l1 = this.getBlockId(l, i1, j1);
            int i2 = this.getBlockMetadata(l, i1, j1);
            Block block = Block.allBlocks[l1];
            if (l1 <= 0 || !block.canCollideCheck(i2, flag) || (movingobjectposition = block.collisionRayTrace(this, l, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeSound(s, entity.posX, entity.posY - (double)entity.eyeHeight, entity.posZ, f, f1);
            ++i;
        }
    }

    public void playSoundEffect(double d, double d1, double d2, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeSound(s, d, d1, d2, f, f1);
            ++i;
        }
    }

    public void playAmbience(double d, double d1, double d2, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).makeAmbience(s, d, d1, d2, f, f1);
            ++i;
        }
    }

    public void updateAmbience(double d, double d1, double d2, String s, float f, float f1) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).updateAmbience(s, d, d1, d2, f, f1);
            ++i;
        }
    }

    public boolean isAmbienceEnabled() {
        return this.worldAccesses.get(0).isAmbienceEnabled();
    }

    public void func_670_a(String s, int i, int j, int k) {
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).func_933_a(s, i, j, k);
            ++l;
        }
    }

    public void spawnParticle(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            try {
                this.worldAccesses.get(i).func_939_a(s, d, d1, d2, d3, d4, d5);
            }
            catch (Exception ex) {
                System.out.println("Tried to render non-existant entity! Left server?");
            }
            ++i;
        }
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
        }
        if (flag || this.chunkExists(i, j)) {
            if (entity instanceof EntityPlayer) {
                this.playerEntities.add((EntityPlayer)entity);
                System.out.println("Player count: " + this.playerEntities.size());
            }
            this.getChunkFromChunkCoords(i, j).func_1000_a(entity);
            this.field_1050_a.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).func_941_a(entity);
            ++i;
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        int i = 0;
        while (i < this.worldAccesses.size()) {
            this.worldAccesses.get(i).func_938_b(entity);
            ++i;
        }
    }

    public void setEntityDead(Entity entity) {
        entity.func_395_F();
        if (entity instanceof EntityPlayer) {
            this.playerEntities.remove((EntityPlayer)entity);
            System.out.println("Player count: " + this.playerEntities.size());
        }
    }

    public void func_613_a(IWorldAccess iworldaccess) {
        this.worldAccesses.add(iworldaccess);
    }

    public void func_672_b(IWorldAccess iworldaccess) {
        this.worldAccesses.remove(iworldaccess);
    }

    public List<AxisAlignedBB> func_697_a(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1015_J.clear();
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = i1;
            while (l1 < j1) {
                if (this.blockExists(k1, 64, l1)) {
                    int i2 = k - 1;
                    while (i2 < l) {
                        Block block = Block.allBlocks[this.getBlockId(k1, i2, l1)];
                        if (block != null) {
                            block.setCollisionBlock(this, k1, i2, l1, axisalignedbb, this.field_1015_J);
                        }
                        ++i2;
                    }
                }
                ++l1;
            }
            ++k1;
        }
        double d = 0.25;
        List<Entity> list = this.func_659_b(entity, axisalignedbb.func_1177_b(d, d, d));
        int j2 = 0;
        while (j2 < list.size()) {
            AxisAlignedBB axisalignedbb1 = list.get(j2).func_372_f_();
            if (axisalignedbb1 != null && axisalignedbb1.func_1178_a(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.func_383_b_(list.get(j2))) != null && axisalignedbb1.func_1178_a(axisalignedbb)) {
                this.field_1015_J.add(axisalignedbb1);
            }
            ++j2;
        }
        return this.field_1015_J;
    }

    public int func_671_a(float f) {
        float f1 = this.func_619_c(f);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return (int)(f2 * 11.0f);
    }

    public Vec3D func_626_b(float f) {
        float f1 = this.func_619_c(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.field_1021_D >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1021_D >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1021_D & 0xFFL) / 255.0f;
        return Vec3D.newVectorAndAddToPool(f3 *= f2, f4 *= f2, f5 *= f2);
    }

    public float func_619_c(float f) {
        int i = (int)(this.worldTime % 24000L);
        float f1 = ((float)i + f) / 24000.0f - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public Vec3D func_628_d(float f) {
        float f1 = this.func_619_c(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.field_1019_F >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1019_F >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1019_F & 0xFFL) / 255.0f;
        return Vec3D.newVectorAndAddToPool(f3 *= f2 * 0.9f + 0.1f, f4 *= f2 * 0.9f + 0.1f, f5 *= f2 * 0.85f + 0.15f);
    }

    public Vec3D func_686_e(float f) {
        float f1 = this.func_619_c(f);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.field_1020_E >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.field_1020_E >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.field_1020_E & 0xFFL) / 255.0f;
        return Vec3D.newVectorAndAddToPool(f3 *= f2 * 0.94f + 0.06f, f4 *= f2 * 0.94f + 0.06f, f5 *= f2 * 0.91f + 0.09f);
    }

    public int func_685_d(int i, int j) {
        Chunk chunk = this.getChunkFromBlockCoords(i, j);
        i &= 0xF;
        j &= 0xF;
        for (int k = 127; k > 0; --k) {
            int l = chunk.getBlockId(i, k, j);
            if (l == 0 || !Block.allBlocks[l].blockMaterial.blocksMovement() && !Block.allBlocks[l].blockMaterial.getIsGroundCover()) {
                continue;
            }
            return k + 1;
        }
        return -1;
    }

    public int func_696_e(int i, int j) {
        return this.getChunkFromBlockCoords(i, j).func_999_b(i & 0xF, j & 0xF);
    }

    public float func_679_f(float f) {
        float f1 = this.func_619_c(f);
        float f2 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return f2 * f2 * 0.5f;
    }

    public void func_681_h(int i, int j, int k, int l) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i, j, k, l);
        int byte0 = 8;
        if (this.checkChunksExist(i - byte0, j - byte0, k - byte0, i + byte0, j + byte0, k + byte0)) {
            if (l > 0) {
                nextticklistentry.func_900_a((long)Block.allBlocks[l].tickRate() + this.worldTime);
            }
            if (!this.field_1022_C.contains(nextticklistentry)) {
                this.field_1022_C.add(nextticklistentry);
                this.field_1023_B.add(nextticklistentry);
            }
        }
    }

    public void func_633_c() {
        this.field_1050_a.removeAll(this.field_1024_A);
        int i = 0;
        while (i < this.field_1024_A.size()) {
            Entity entity = (Entity)this.field_1024_A.get(i);
            int i1 = entity.chunkCoordX;
            int k1 = entity.chunkCoordZ;
            if (entity.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).func_1015_b(entity);
            }
            ++i;
        }
        int j = 0;
        while (j < this.field_1024_A.size()) {
            this.releaseEntitySkin((Entity)this.field_1024_A.get(j));
            ++j;
        }
        this.field_1024_A.clear();
        int k = 0;
        while (k < this.field_1050_a.size()) {
            block12: {
                Entity entity1;
                block11: {
                    entity1 = this.field_1050_a.get(k);
                    if (entity1.entityBeingRidden == null) break block11;
                    if (!entity1.entityBeingRidden.hasDied && entity1.entityBeingRidden.riddenByEntity == entity1) break block12;
                    entity1.entityBeingRidden.riddenByEntity = null;
                    entity1.entityBeingRidden = null;
                }
                if (!entity1.hasDied) {
                    this.func_667_e(entity1);
                }
                if (entity1.hasDied) {
                    int j1 = entity1.chunkCoordX;
                    int l1 = entity1.chunkCoordZ;
                    if (entity1.addedToChunk && this.chunkExists(j1, l1)) {
                        this.getChunkFromChunkCoords(j1, l1).func_1015_b(entity1);
                    }
                    this.field_1050_a.remove(k--);
                    this.releaseEntitySkin(entity1);
                }
            }
            ++k;
        }
        int l = 0;
        while (l < this.field_1049_b.size()) {
            TileEntity tileentity = (TileEntity)this.field_1049_b.get(l);
            tileentity.func_475_b();
            ++l;
        }
    }

    protected void func_667_e(Entity entity) {
        int j;
        int byte0;
        int i = MathHelper.floor_double(entity.posX);
        if (!this.checkChunksExist(i - (byte0 = 16), 0, (j = MathHelper.floor_double(entity.posZ)) - byte0, i + byte0, 128, j + byte0)) {
            return;
        }
        entity.lastTickPosX = entity.posX;
        entity.lastTickPosY = entity.posY;
        entity.lastTickPosZ = entity.posZ;
        entity.headYaw = entity.rotationYaw;
        entity.headPitch = entity.rotationPitch;
        if (entity.entityBeingRidden != null) {
            entity.func_350_p();
        } else {
            entity.onUpdate();
        }
        int k = MathHelper.floor_double(entity.posX / 16.0);
        int l = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k || entity.chunkCoordY != l || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.chunkExists(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).func_1016_a(entity, entity.chunkCoordY);
            }
            if (this.chunkExists(k, i1)) {
                this.getChunkFromChunkCoords(k, i1).func_1000_a(entity);
            } else {
                entity.addedToChunk = false;
                System.out.println("Removing entity because it's not in a chunk!!");
                entity.func_395_F();
            }
        }
        if (entity.riddenByEntity != null) {
            if (entity.riddenByEntity.hasDied || entity.riddenByEntity.entityBeingRidden != entity) {
                entity.riddenByEntity.entityBeingRidden = null;
                entity.riddenByEntity = null;
            } else {
                this.func_667_e(entity.riddenByEntity);
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.lastTickPosX;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.lastTickPosY;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.lastTickPosZ;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.headPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.headYaw;
        }
    }

    public boolean func_604_a(AxisAlignedBB axisalignedbb) {
        List<Entity> list = this.func_659_b(null, axisalignedbb);
        int i = 0;
        while (i < list.size()) {
            Entity entity = list.get(i);
            if (!entity.hasDied && entity.preventEntitySpawning) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean func_662_b(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        if (axisalignedbb.field_1698_a < 0.0) {
            --i;
        }
        if (axisalignedbb.minY < 0.0) {
            --k;
        }
        if (axisalignedbb.field_1704_c < 0.0) {
            --i1;
        }
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial.getIsGroundCover()) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_605_c(AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    int j2 = this.getBlockId(k1, l1, i2);
                    if (j2 == Block.fire.blockID || j2 == Block.lavaMoving.blockID || j2 == Block.lavaStill.blockID) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_682_a(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        boolean flag = false;
        Vec3D vec3d = Vec3D.newVectorAndAddToPool(0.0, 0.0, 0.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    double d1;
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material && (double)l >= (d1 = (double)((float)(l1 + 1) - BlockFluids.getFluidLevel(this.getBlockMetadata(k1, l1, i2))))) {
                        flag = true;
                        block.velocityToAddToEntity(this, k1, l1, i2, entity, vec3d);
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        if (vec3d.magnitude() > 0.0) {
            vec3d = vec3d.func_1252_b();
            double d = 0.004;
            entity.motionX += vec3d.xCoord * d;
            entity.motionY += vec3d.yCoord * d;
            entity.motionZ += vec3d.zCoord * d;
        }
        return flag;
    }

    public boolean func_689_a(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        return true;
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public boolean func_707_b(AxisAlignedBB axisalignedbb, Material material) {
        int i = MathHelper.floor_double(axisalignedbb.field_1698_a);
        int j = MathHelper.floor_double(axisalignedbb.field_1703_d + 1.0);
        int k = MathHelper.floor_double(axisalignedbb.minY);
        int l = MathHelper.floor_double(axisalignedbb.field_1702_e + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.field_1704_c);
        int j1 = MathHelper.floor_double(axisalignedbb.field_1701_f + 1.0);
        int k1 = i;
        while (k1 < j) {
            int l1 = k;
            while (l1 < l) {
                int i2 = i1;
                while (i2 < j1) {
                    Block block = Block.allBlocks[this.getBlockId(k1, l1, i2)];
                    if (block != null && block.blockMaterial == material) {
                        int j2 = this.getBlockMetadata(k1, l1, i2);
                        double d = l1 + 1;
                        if (j2 < 8) {
                            d = (double)(l1 + 1) - (double)j2 / 8.0;
                        }
                        if (d >= axisalignedbb.minY) {
                            return true;
                        }
                    }
                    ++i2;
                }
                ++l1;
            }
            ++k1;
        }
        return false;
    }

    public void func_676_a(Entity entity, double d, double d1, double d2, float f) {
        new Explosion().func_901_a(this, entity, d, d1, d2, f);
    }

    public float func_675_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d = 1.0 / ((axisalignedbb.field_1703_d - axisalignedbb.field_1698_a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.field_1702_e - axisalignedbb.minY) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.field_1701_f - axisalignedbb.field_1704_c) * 2.0 + 1.0);
        int i = 0;
        int j = 0;
        float f = 0.0f;
        while (f <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f2 = 0.0f;
                while (f2 <= 1.0f) {
                    double d3 = axisalignedbb.field_1698_a + (axisalignedbb.field_1703_d - axisalignedbb.field_1698_a) * (double)f;
                    double d4 = axisalignedbb.minY + (axisalignedbb.field_1702_e - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.field_1704_c + (axisalignedbb.field_1701_f - axisalignedbb.field_1704_c) * (double)f2;
                    if (this.clip(Vec3D.newVectorAndAddToPool(d3, d4, d5), vec3d) == null) {
                        ++i;
                    }
                    ++j;
                    f2 = (float)((double)f2 + d2);
                }
                f1 = (float)((double)f1 + d1);
            }
            f = (float)((double)f + d);
        }
        return (float)i / (float)j;
    }

    public void func_612_i(int i, int j, int k, int l) {
        if (l == 0) {
            --j;
        }
        if (l == 1) {
            ++j;
        }
        if (l == 2) {
            --k;
        }
        if (l == 3) {
            ++k;
        }
        if (l == 4) {
            --i;
        }
        if (l == 5) {
            ++i;
        }
        if (this.getBlockId(i, j, k) == Block.fire.blockID) {
            this.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.8f);
            this.setBlockWithNotify(i, j, k, 0);
        }
    }

    public Entity func_661_a(Class<?> class1) {
        return null;
    }

    public String func_687_d() {
        return "All entities: " + this.field_1050_a.size();
    }

    @Override
    public TileEntity getBlockTileEntity(int i, int j, int k) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            return chunk.genTileEntity(i & 0xF, j, k & 0xF);
        }
        return null;
    }

    public void func_654_a(int i, int j, int k, TileEntity tileentity) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            chunk.func_1005_a(i & 0xF, j, k & 0xF, tileentity);
        }
    }

    public void func_692_l(int i, int j, int k) {
        Chunk chunk = this.getChunkFromChunkCoords(i >> 4, k >> 4);
        if (chunk != null) {
            chunk.func_1023_e(i & 0xF, j, k & 0xF);
        }
    }

    @Override
    public boolean isBlockNormalCube(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean isWater(int i, int j, int k) {
        Block block = Block.allBlocks[this.getBlockId(i, j, k)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial == Material.water;
    }

    public void func_651_a(IProgressUpdate iprogressupdate) {
        this.func_639_a(true, iprogressupdate);
    }

    public boolean func_638_e() {
        int i = 1000;
        while (this.field_1025_z.size() > 0) {
            if (--i <= 0) {
                return true;
            }
            this.field_1025_z.remove(this.field_1025_z.size() - 1).func_865_a(this);
        }
        return false;
    }

    public void func_616_a(EnumSkyBlock enumskyblock, int i, int j, int k, int l, int i1, int j1) {
        this.func_627_a(enumskyblock, i, j, k, l, i1, j1, true);
    }

    public void func_627_a(EnumSkyBlock enumskyblock, int i, int j, int k, int l, int i1, int j1, boolean flag) {
        int k1 = (l + i) / 2;
        int l1 = (j1 + k) / 2;
        if (!this.blockExists(k1, 64, l1)) {
            return;
        }
        int i2 = this.field_1025_z.size();
        if (flag) {
            int j2 = 4;
            if (j2 > i2) {
                j2 = i2;
            }
            int k2 = 0;
            while (k2 < j2) {
                MetadataChunkBlock metadatachunkblock = this.field_1025_z.get(this.field_1025_z.size() - k2 - 1);
                if (metadatachunkblock.field_1299_a == enumskyblock && metadatachunkblock.func_866_a(i, j, k, l, i1, j1)) {
                    return;
                }
                ++k2;
            }
        }
        this.field_1025_z.add(new MetadataChunkBlock(enumskyblock, i, j, k, l, i1, j1));
    }

    public void func_644_f() {
        int i = this.func_671_a(1.0f);
        if (i != this.skyLightSubtracted) {
            this.skyLightSubtracted = i;
        }
    }

    public void tick() {
        this.chunkProvider.unknownBoolean1();
        int i = this.func_671_a(1.0f);
        if (i != this.skyLightSubtracted) {
            this.skyLightSubtracted = i;
            int j = 0;
            while (j < this.worldAccesses.size()) {
                this.worldAccesses.get(j).updateAllRenderers();
                ++j;
            }
        }
        ++this.worldTime;
        if (this.worldTime % (long)this.field_1041_j == 0L) {
            this.func_639_a(false, null);
        }
        this.tickUpdates(false);
        this.func_652_h();
    }

    protected void func_652_h() {
        this.field_1014_K.clear();
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer = this.playerEntities.get(i);
            int j = MathHelper.floor_double(entityplayer.posX / 16.0);
            int l = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int byte0 = 9;
            int j1 = -byte0;
            while (j1 <= byte0) {
                int j2 = -byte0;
                while (j2 <= byte0) {
                    this.field_1014_K.add(new ChunkCoordIntPair(j1 + j, j2 + l));
                    ++j2;
                }
                ++j1;
            }
            ++i;
        }
        if (this.ambienceChance > 0) {
            --this.ambienceChance;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.field_1014_K) {
            int i5;
            int j4;
            int k3;
            int l2;
            int l1;
            int chunkX = chunkcoordintpair.field_189_a * 16;
            int chunkZ = chunkcoordintpair.field_188_b * 16;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.field_189_a, chunkcoordintpair.field_188_b);
            if (this.ambienceChance == 0) {
                EntityPlayer entityplayer1;
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int k1 = this.field_1045_f >> 2;
                int k2 = k1 & 0xF;
                int j3 = k1 >> 8 & 0xF;
                int i4 = k1 >> 16 & 0x7F;
                int l4 = chunk.getBlockId(k2, i4, j3);
                if (l4 == 0 && this.func_618_j(k2 += chunkX, i4, j3 += chunkZ) <= this.rand.nextInt(8) && this.getBlockLighting(EnumSkyBlock.Sky, k2, i4, j3) <= 0 && (entityplayer1 = this.getPlayerEntity((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, 8.0)) != null && entityplayer1.getEntityPositionMagnitude((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5) > 4.0) {
                    this.playSoundEffect((double)k2 + 0.5, (double)i4 + 0.5, (double)j3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                    this.ambienceChance = this.rand.nextInt(12000) + 6000;
                }
            }
            if (this.snowCovered && this.rand.nextInt(4) == 0) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                l1 = this.field_1045_f >> 2;
                l2 = l1 & 0xF;
                k3 = l1 >> 8 & 0xF;
                j4 = this.func_685_d(l2 + chunkX, k3 + chunkZ);
                if (j4 >= 0 && j4 < 128 && chunk.func_1025_a(EnumSkyBlock.Block, l2, j4, k3) < 10) {
                    i5 = chunk.getBlockId(l2, j4 - 1, k3);
                    if (chunk.getBlockId(l2, j4, k3) == 0 && Block.snow.canPlace(this, l2 + chunkX, j4, k3 + chunkZ)) {
                        this.setBlockWithNotify(l2 + chunkX, j4, k3 + chunkZ, Block.snow.blockID);
                    }
                    if (i5 == Block.waterStill.blockID && chunk.func_1021_b(l2, j4 - 1, k3) == 0) {
                        this.setBlockWithNotify(l2 + chunkX, j4 - 1, k3 + chunkZ, Block.ice.blockID);
                    }
                }
            }
            if (!this.snowCovered && this.rand.nextInt(4) == 0) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                l1 = this.field_1045_f >> 2;
                l2 = l1 & 0xF;
                k3 = l1 >> 8 & 0xF;
                j4 = this.func_685_d(l2 + chunkX, k3 + chunkZ);
                if (j4 >= 0 && j4 < 128 && chunk.func_1025_a(EnumSkyBlock.Block, l2, j4, k3) < 10) {
                    i5 = chunk.getBlockId(l2, j4 - 1, k3);
                    if (chunk.getBlockId(l2, j4, k3) == Block.snow.blockID) {
                        this.setBlockWithNotify(l2 + chunkX, j4, k3 + chunkZ, 0);
                    }
                    if (i5 == Block.ice.blockID && chunk.func_1021_b(l2, j4 - 1, k3) == 0) {
                        this.setBlockWithNotify(l2 + chunkX, j4 - 1, k3 + chunkZ, Block.waterStill.blockID);
                    }
                }
            }
            int i2 = 0;
            while (i2 < 80) {
                this.field_1045_f = this.field_1045_f * 3 + this.field_1044_g;
                int i3 = this.field_1045_f >> 2;
                int l3 = i3 & 0xF;
                int k4 = i3 >> 8 & 0xF;
                int j5 = i3 >> 16 & 0x7F;
                byte byte1 = chunk.blocks[l3 << 11 | k4 << 7 | j5];
                if (Block.tickOnLoad[byte1]) {
                    Block.allBlocks[byte1].updateTick(this, l3 + chunkX, j5, k4 + chunkZ, this.rand);
                }
                ++i2;
            }
        }
    }

    public boolean tickUpdates(boolean flag) {
        int i = this.field_1023_B.size();
        if (i != this.field_1022_C.size()) {
            throw new IllegalStateException("TickNextTick list out of synch");
        }
        if (i > 1000) {
            i = 1000;
        }
        int j = 0;
        while (j < i) {
            int k;
            NextTickListEntry nextticklistentry = this.field_1023_B.first();
            if (!flag && nextticklistentry.field_1364_e > this.worldTime) break;
            this.field_1023_B.remove(nextticklistentry);
            this.field_1022_C.remove(nextticklistentry);
            int byte0 = 8;
            if (this.checkChunksExist(nextticklistentry.field_1361_a - byte0, nextticklistentry.field_1360_b - byte0, nextticklistentry.field_1366_c - byte0, nextticklistentry.field_1361_a + byte0, nextticklistentry.field_1360_b + byte0, nextticklistentry.field_1366_c + byte0) && (k = this.getBlockId(nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c)) == nextticklistentry.field_1365_d && k > 0) {
                Block.allBlocks[k].updateTick(this, nextticklistentry.field_1361_a, nextticklistentry.field_1360_b, nextticklistentry.field_1366_c, this.rand);
            }
            ++j;
        }
        return this.field_1023_B.size() != 0;
    }

    public void func_677_m(int i, int j, int k) {
        int byte0 = 16;
        Random random = new Random();
        int l = 0;
        while (l < 1000) {
            int k1;
            int j1;
            int i1 = i + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int l1 = this.getBlockId(i1, j1 = j + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), k1 = k + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (l1 > 0) {
                Block.allBlocks[l1].randomDisplayTick(this, i1, j1, k1, random);
            }
            ++l;
        }
    }

    public List<Entity> func_659_b(Entity entity, AxisAlignedBB axisalignedbb) {
        this.field_1012_M.clear();
        int i = MathHelper.floor_double((axisalignedbb.field_1698_a - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.field_1703_d + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.field_1704_c - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.field_1701_f + 2.0) / 16.0);
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).func_994_a(entity, axisalignedbb, this.field_1012_M);
                }
                ++j1;
            }
            ++i1;
        }
        return this.field_1012_M;
    }

    public List<Entity> func_657_a(Class<?> class1, AxisAlignedBB axisalignedbb) {
        int i = MathHelper.floor_double((axisalignedbb.field_1698_a - 2.0) / 16.0);
        int j = MathHelper.floor_double((axisalignedbb.field_1703_d + 2.0) / 16.0);
        int k = MathHelper.floor_double((axisalignedbb.field_1704_c - 2.0) / 16.0);
        int l = MathHelper.floor_double((axisalignedbb.field_1701_f + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        int i1 = i;
        while (i1 <= j) {
            int j1 = k;
            while (j1 <= l) {
                if (this.chunkExists(i1, j1)) {
                    this.getChunkFromChunkCoords(i1, j1).func_1013_a(class1, axisalignedbb, arraylist);
                }
                ++j1;
            }
            ++i1;
        }
        return arraylist;
    }

    public List<Entity> func_658_i() {
        return this.field_1050_a;
    }

    public void cacheTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (this.blockExists(i, j, k)) {
            this.getChunkFromBlockCoords(i, k).func_1006_f();
        }
        int l = 0;
        while (l < this.worldAccesses.size()) {
            this.worldAccesses.get(l).hashTileEntity(i, j, k, tileentity);
            ++l;
        }
    }

    public int func_621_b(Class<?> class1) {
        int i = 0;
        int j = 0;
        while (j < this.field_1050_a.size()) {
            Entity entity = this.field_1050_a.get(j);
            if (class1.isAssignableFrom(entity.getClass())) {
                ++i;
            }
            ++j;
        }
        return i;
    }

    public void func_636_a(List<Entity> list) {
        this.field_1050_a.addAll(list);
        int i = 0;
        while (i < list.size()) {
            this.obtainEntitySkin(list.get(i));
            ++i;
        }
    }

    public void func_632_b(List<Entity> field_1528_m) {
        this.field_1024_A.addAll(field_1528_m);
    }

    public void func_656_j() {
        while (this.chunkProvider.unknownBoolean1()) {
        }
    }

    public boolean func_695_a(int i, int j, int k, int l, boolean flag) {
        int i1 = this.getBlockId(j, k, l);
        Block block = Block.allBlocks[i1];
        Block block1 = Block.allBlocks[i];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, j, k, l);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.func_604_a(axisalignedbb)) {
            return false;
        }
        if (block == Block.waterMoving || block == Block.waterStill || block == Block.lavaMoving || block == Block.lavaStill || block == Block.fire || block == Block.snow) {
            return true;
        }
        return i > 0 && block == null && block1.canPlace(this, j, k, l);
    }

    public PathEntity getPathEntityToEntity(Entity entity, Entity entity1, float f) {
        int i = MathHelper.floor_double(entity.posX);
        int j = MathHelper.floor_double(entity.posY);
        int k = MathHelper.floor_double(entity.posZ);
        int l = (int)(f + 16.0f);
        int i1 = i - l;
        int j1 = j - l;
        int k1 = k - l;
        int l1 = i + l;
        int i2 = j + l;
        int j2 = k + l;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i2, j2);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f);
    }

    public PathEntity func_637_a(Entity entity, int i, int j, int k, float f) {
        int l = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f + 8.0f);
        int l1 = l - k1;
        int i2 = i1 - k1;
        int j2 = j1 - k1;
        int k2 = l + k1;
        int l2 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i2, j2, k2, l2, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i, j, k, f);
    }

    public boolean func_668_j(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isIndirectlyPoweringTo(this, i, j, k, l);
    }

    public boolean func_646_n(int i, int j, int k) {
        if (this.func_668_j(i, j - 1, k, 0)) {
            return true;
        }
        if (this.func_668_j(i, j + 1, k, 1)) {
            return true;
        }
        if (this.func_668_j(i, j, k - 1, 2)) {
            return true;
        }
        if (this.func_668_j(i, j, k + 1, 3)) {
            return true;
        }
        if (this.func_668_j(i - 1, j, k, 4)) {
            return true;
        }
        return this.func_668_j(i + 1, j, k, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i, int j, int k, int l) {
        if (this.isBlockNormalCube(i, j, k)) {
            return this.func_646_n(i, j, k);
        }
        int i1 = this.getBlockId(i, j, k);
        if (i1 == 0) {
            return false;
        }
        return Block.allBlocks[i1].isPoweringTo(this, i, j, k, l);
    }

    public boolean func_625_o(int i, int j, int k) {
        if (this.isBlockIndirectlyProvidingPowerTo(i, j - 1, k, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j + 1, k, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i, j, k + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i - 1, j, k, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i + 1, j, k, 5);
    }

    public EntityPlayer getPlayerEntityAtHeight(Entity entity, double d) {
        return this.getPlayerEntity(entity.posX, entity.posY, entity.posZ, d);
    }

    public EntityPlayer getPlayerEntity(double d, double d1, double d2, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        int i = 0;
        while (i < this.playerEntities.size()) {
            EntityPlayer entityplayer1 = this.playerEntities.get(i);
            double d5 = entityplayer1.getEntityPositionMagnitude(d, d1, d2);
            if ((d3 < 0.0 || d5 < d3 * d3) && (d4 == -1.0 || d5 < d4)) {
                d4 = d5;
                entityplayer = entityplayer1;
            }
            ++i;
        }
        return entityplayer;
    }

    public void setChunkData(int i, int j, int k, int l, int i1, int j1, byte[] abyte0) {
        int k1 = i >> 4;
        int l1 = k >> 4;
        int i2 = i + l - 1 >> 4;
        int j2 = k + j1 - 1 >> 4;
        int k2 = 0;
        int l2 = j;
        int i3 = j + i1;
        if (l2 < 0) {
            l2 = 0;
        }
        if (i3 > 128) {
            i3 = 128;
        }
        int j3 = k1;
        while (j3 <= i2) {
            int k3 = i - j3 * 16;
            int l3 = i + l - j3 * 16;
            if (k3 < 0) {
                k3 = 0;
            }
            if (l3 > 16) {
                l3 = 16;
            }
            int i4 = l1;
            while (i4 <= j2) {
                int j4 = k - i4 * 16;
                int k4 = k + j1 - i4 * 16;
                if (j4 < 0) {
                    j4 = 0;
                }
                if (k4 > 16) {
                    k4 = 16;
                }
                k2 = this.getChunkFromChunkCoords(j3, i4).func_1004_a(abyte0, k3, l2, j4, l3, i3, k4, k2);
                this.markBlocksDirty(j3 * 16 + k3, l2, i4 * 16 + j4, j3 * 16 + l3, i3, i4 * 16 + k4);
                ++i4;
            }
            ++j3;
        }
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void func_663_l() {
        try {
            File file = new File(this.field_1031_t, "session.lock");
            DataInputStream datainputstream = new DataInputStream(new FileInputStream(file));
            try {
                if (datainputstream.readLong() != this.field_1018_G) {
                    throw new MinecraftException("The save is being accessed from another location, aborting");
                }
            }
            finally {
                datainputstream.close();
            }
        }
        catch (IOException ioexception) {
            throw new MinecraftException("Failed to check session lock, aborting");
        }
    }

    public void setWorldTime(long l) {
        this.worldTime = l;
    }

    public void func_705_f(Entity entity) {
        int i = MathHelper.floor_double(entity.posX / 16.0);
        int j = MathHelper.floor_double(entity.posZ / 16.0);
        int byte0 = 2;
        int k = i - byte0;
        while (k <= i + byte0) {
            int l = j - byte0;
            while (l <= j + byte0) {
                this.getChunkFromChunkCoords(k, l);
                ++l;
            }
            ++k;
        }
        if (!this.field_1050_a.contains(entity)) {
            System.out.println("REINSERTING PLAYER!");
            this.field_1050_a.add(entity);
        }
    }
}

