/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import java.util.Random;

public class BlockRedstoneWire
extends Block {
    private boolean field_453_a = true;

    public BlockRedstoneWire(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.textureIndex + (j <= 0 ? 0 : 16);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 5;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    private void func_280_h(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = 0;
        this.field_453_a = false;
        boolean flag = world.func_625_o(i, j, k);
        this.field_453_a = true;
        if (flag) {
            i1 = 15;
        } else {
            int j1 = 0;
            while (j1 < 4) {
                int l1 = i;
                int j2 = k;
                if (j1 == 0) {
                    --l1;
                }
                if (j1 == 1) {
                    ++l1;
                }
                if (j1 == 2) {
                    --j2;
                }
                if (j1 == 3) {
                    ++j2;
                }
                i1 = this.func_281_g(world, l1, j, j2, i1);
                if (world.isBlockNormalCube(l1, j, j2) && !world.isBlockNormalCube(i, j + 1, k)) {
                    i1 = this.func_281_g(world, l1, j + 1, j2, i1);
                } else if (!world.isBlockNormalCube(l1, j, j2)) {
                    i1 = this.func_281_g(world, l1, j - 1, j2, i1);
                }
                ++j1;
            }
            i1 = i1 > 0 ? --i1 : 0;
        }
        if (l != i1) {
            world.setBlockMetadataWithNotify(i, j, k, i1);
            world.markBlocksDirty(i, j, k, i, j, k);
            if (i1 > 0) {
                --i1;
            }
            int k1 = 0;
            while (k1 < 4) {
                int i3;
                int i2 = i;
                int k2 = k;
                int l2 = j - 1;
                if (k1 == 0) {
                    --i2;
                }
                if (k1 == 1) {
                    ++i2;
                }
                if (k1 == 2) {
                    --k2;
                }
                if (k1 == 3) {
                    ++k2;
                }
                if (world.isBlockNormalCube(i2, j, k2)) {
                    l2 += 2;
                }
                if ((i3 = this.func_281_g(world, i2, j, k2, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i2, j, k2);
                }
                if ((i3 = this.func_281_g(world, i2, l2, k2, -1)) >= 0 && i3 != i1) {
                    this.func_280_h(world, i2, l2, k2);
                }
                ++k1;
            }
            if (l == 0 || i1 == 0) {
                world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
                world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
            }
        }
    }

    private void func_282_i(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        super.onBlockAdded(world, i, j, k);
        this.func_280_h(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.func_282_i(world, i - 1, j, k);
        this.func_282_i(world, i + 1, j, k);
        this.func_282_i(world, i, j, k - 1);
        this.func_282_i(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.func_282_i(world, i - 1, j + 1, k);
        } else {
            this.func_282_i(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.func_282_i(world, i + 1, j + 1, k);
        } else {
            this.func_282_i(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.func_282_i(world, i, j + 1, k - 1);
        } else {
            this.func_282_i(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.func_282_i(world, i, j + 1, k + 1);
        } else {
            this.func_282_i(world, i, j - 1, k + 1);
        }
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        super.onBlockRemoval(world, i, j, k);
        world.notifyBlocksOfNeighborChange(i, j + 1, k, this.blockID);
        world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        this.func_280_h(world, i, j, k);
        this.func_282_i(world, i - 1, j, k);
        this.func_282_i(world, i + 1, j, k);
        this.func_282_i(world, i, j, k - 1);
        this.func_282_i(world, i, j, k + 1);
        if (world.isBlockNormalCube(i - 1, j, k)) {
            this.func_282_i(world, i - 1, j + 1, k);
        } else {
            this.func_282_i(world, i - 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            this.func_282_i(world, i + 1, j + 1, k);
        } else {
            this.func_282_i(world, i + 1, j - 1, k);
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            this.func_282_i(world, i, j + 1, k - 1);
        } else {
            this.func_282_i(world, i, j - 1, k - 1);
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            this.func_282_i(world, i, j + 1, k + 1);
        } else {
            this.func_282_i(world, i, j - 1, k + 1);
        }
    }

    private int func_281_g(World world, int i, int j, int k, int l) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return l;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        if (i1 > l) {
            return i1;
        }
        return l;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = this.canPlace(world, i, j, k);
        if (!flag) {
            this.dropBlockAsItem(world, i, j, k, i1);
            world.setBlockWithNotify(i, j, k, 0);
        } else {
            this.func_280_h(world, i, j, k);
        }
        super.onNeighborBlockChange(world, i, j, k, l);
    }

    @Override
    public int idDropped(int i, Random random) {
        return Item.redstone.shiftedIndex;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        if (!this.field_453_a) {
            return false;
        }
        return this.isPoweringTo(world, i, j, k, l);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        boolean flag3;
        if (!this.field_453_a) {
            return false;
        }
        if (iblockaccess.getBlockMetadata(i, j, k) == 0) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        boolean flag = BlockRedstoneWire.func_279_b(iblockaccess, i - 1, j, k) || !iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.func_279_b(iblockaccess, i - 1, j - 1, k);
        boolean flag1 = BlockRedstoneWire.func_279_b(iblockaccess, i + 1, j, k) || !iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.func_279_b(iblockaccess, i + 1, j - 1, k);
        boolean flag2 = BlockRedstoneWire.func_279_b(iblockaccess, i, j, k - 1) || !iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.func_279_b(iblockaccess, i, j - 1, k - 1);
        boolean bl = flag3 = BlockRedstoneWire.func_279_b(iblockaccess, i, j, k + 1) || !iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.func_279_b(iblockaccess, i, j - 1, k + 1);
        if (!iblockaccess.isBlockNormalCube(i, j + 1, k)) {
            if (iblockaccess.isBlockNormalCube(i - 1, j, k) && BlockRedstoneWire.func_279_b(iblockaccess, i - 1, j + 1, k)) {
                flag = true;
            }
            if (iblockaccess.isBlockNormalCube(i + 1, j, k) && BlockRedstoneWire.func_279_b(iblockaccess, i + 1, j + 1, k)) {
                flag1 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k - 1) && BlockRedstoneWire.func_279_b(iblockaccess, i, j + 1, k - 1)) {
                flag2 = true;
            }
            if (iblockaccess.isBlockNormalCube(i, j, k + 1) && BlockRedstoneWire.func_279_b(iblockaccess, i, j + 1, k + 1)) {
                flag3 = true;
            }
        }
        if (!(flag2 || flag1 || flag || flag3 || l < 2 || l > 5)) {
            return true;
        }
        if (l == 2 && flag2 && !flag && !flag1) {
            return true;
        }
        if (l == 3 && flag3 && !flag && !flag1) {
            return true;
        }
        if (l == 4 && flag && !flag2 && !flag3) {
            return true;
        }
        return l == 5 && flag1 && !flag2 && !flag3;
    }

    @Override
    public boolean canProvidePower() {
        return this.field_453_a;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        if (world.getBlockMetadata(i, j, k) > 0) {
            double d = (double)i + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            double d1 = (float)j + 0.0625f;
            double d2 = (double)k + 0.5 + ((double)random.nextFloat() - 0.5) * 0.2;
            world.spawnParticle("reddust", d, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static boolean func_279_b(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockId(i, j, k);
        if (l == Block.redstoneWire.blockID) {
            return true;
        }
        if (l == 0) {
            return false;
        }
        return Block.allBlocks[l].canProvidePower();
    }
}

