/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockSpongeInactive
extends Block {
    static final byte radius = 3;

    protected BlockSpongeInactive(int i) {
        super(i, Material.sponge);
        this.textureIndex = 48;
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.sponge.blockID;
    }

    @Override
    public void onBlockAdded(World world, int a, int b, int c) {
        super.onBlockAdded(world, a, b, c);
        int x = a - 3;
        while (x <= a + 3) {
            int y = b - 3;
            while (y <= b + 3) {
                int z = c - 3;
                while (z <= c + 3) {
                    if (world.getBlockId(x, y, z) == Block.waterMoving.blockID || world.getBlockId(x, y, z) == Block.waterStill.blockID) {
                        world.setBlockWithNotify(x, y, z, Block.waterMoving.blockID);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if ((i1 & 8) != 0) {
            if (world.getBlockId(i, j, k) != this.blockID) {
                world.setBlockWithNotify(i, j, k, 19);
            }
            if (l > 0) {
                Block.allBlocks[l].canProvidePower();
            }
        }
        if (l > 0 && Block.allBlocks[l].canProvidePower() || this.canProvidePower()) {
            world.setBlockWithNotify(i, j, k, 19);
        }
    }
}

