/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.ArrayList;
import java.util.Random;

public class BlockStairs
extends Block {
    private Block baseBlock;

    protected BlockStairs(int i, Block block) {
        super(i, block.textureIndex, block.blockMaterial);
        this.baseBlock = block;
        this.setHardness(block.blockHardness);
        this.setResistance(block.blockResistance / 3.0f);
        this.setStepSound(block.stepSound);
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 10;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public void setCollisionBlock(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList<AxisAlignedBB> arraylist) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.setCollisionBlock(world, i, j, k, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.multiplayerWorld) {
            return;
        }
        if (!world.getMaterialXYZ(i, j + 1, k).isSolidMaterial()) {
            this.func_276_h(world, i, j, k);
            this.func_276_h(world, i + 1, j - 1, k);
            this.func_276_h(world, i - 1, j - 1, k);
            this.func_276_h(world, i, j - 1, k - 1);
            this.func_276_h(world, i, j - 1, k + 1);
            this.func_276_h(world, i + 1, j + 1, k);
            this.func_276_h(world, i - 1, j + 1, k);
            this.func_276_h(world, i, j + 1, k - 1);
            this.func_276_h(world, i, j + 1, k + 1);
        }
        this.baseBlock.onNeighborBlockChange(world, i, j, k, l);
    }

    private void func_276_h(World world, int i, int j, int k) {
        if (!this.func_278_j(world, i, j, k)) {
            return;
        }
        int byte0 = -1;
        if (this.func_278_j(world, i + 1, j + 1, k)) {
            byte0 = 0;
        }
        if (this.func_278_j(world, i - 1, j + 1, k)) {
            byte0 = 1;
        }
        if (this.func_278_j(world, i, j + 1, k + 1)) {
            byte0 = 2;
        }
        if (this.func_278_j(world, i, j + 1, k - 1)) {
            byte0 = 3;
        }
        if (byte0 < 0) {
            if (this.func_277_i(world, i + 1, j, k) && !this.func_277_i(world, i - 1, j, k)) {
                byte0 = 0;
            }
            if (this.func_277_i(world, i - 1, j, k) && !this.func_277_i(world, i + 1, j, k)) {
                byte0 = 1;
            }
            if (this.func_277_i(world, i, j, k + 1) && !this.func_277_i(world, i, j, k - 1)) {
                byte0 = 2;
            }
            if (this.func_277_i(world, i, j, k - 1) && !this.func_277_i(world, i, j, k + 1)) {
                byte0 = 3;
            }
        }
        if (byte0 < 0) {
            if (this.func_278_j(world, i - 1, j - 1, k)) {
                byte0 = 0;
            }
            if (this.func_278_j(world, i + 1, j - 1, k)) {
                byte0 = 1;
            }
            if (this.func_278_j(world, i, j - 1, k - 1)) {
                byte0 = 2;
            }
            if (this.func_278_j(world, i, j - 1, k + 1)) {
                byte0 = 3;
            }
        }
        if (byte0 >= 0) {
            world.setBlockMetadataWithNotify(i, j, k, byte0);
        }
    }

    private boolean func_277_i(World world, int i, int j, int k) {
        return world.getMaterialXYZ(i, j, k).isSolidMaterial();
    }

    private boolean func_278_j(World world, int i, int j, int k) {
        int l = world.getBlockId(i, j, k);
        if (l == 0) {
            return false;
        }
        return Block.allBlocks[l].getRenderType() == 10;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l) {
        EntityItem entityitem = new EntityItem(world, i, j, k, new ItemStack(this.blockID));
        entityitem.delayBeforeCanPickup = 10;
        world.entityJoinedWorld(entityitem);
        this.baseBlock.dropBlockAsItemWithChance(world, i, j, k, l);
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.baseBlock.getBlockBrightness(iblockaccess, i, j, k);
    }

    @Override
    public float getExplosionResistance(Entity entity) {
        return this.baseBlock.getExplosionResistance(entity);
    }

    @Override
    public int getRenderBlockPass() {
        return this.baseBlock.getRenderBlockPass();
    }

    @Override
    public int idDropped(int i, Random random) {
        return this.blockID;
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.baseBlock.getBlockTextureFromSideAndMetadata(i, j);
    }

    @Override
    public int getTextureIndex(int i) {
        return this.baseBlock.getTextureIndex(i);
    }

    @Override
    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.baseBlock.getTextureIndex(iblockaccess, i, j, k, l);
    }

    @Override
    public int tickRate() {
        return this.baseBlock.tickRate();
    }

    @Override
    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.baseBlock.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    @Override
    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        this.baseBlock.velocityToAddToEntity(world, i, j, k, entity, vec3d);
    }

    @Override
    public boolean isCollidable() {
        return this.baseBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int i, boolean flag) {
        return this.baseBlock.canCollideCheck(i, flag);
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return this.baseBlock.canPlace(world, i, j, k);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.baseBlock.onBlockAdded(world, i, j, k);
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
    }

    @Override
    public void dropBlockAsItem(World world, int i, int j, int k, int l) {
    }

    @Override
    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        this.baseBlock.updateTick(world, i, j, k, random);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.baseBlock.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }
}

