/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityTNTPrimed;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockTNT
extends Block {
    public BlockTNT(int i, int j) {
        super(i, j, Material.tnt);
    }

    @Override
    public int getTextureIndex(int i) {
        if (i == 0) {
            return this.textureIndex + 2;
        }
        if (i == 1) {
            return this.textureIndex + 1;
        }
        return this.textureIndex;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (l > 0 && Block.allBlocks[l].canProvidePower() && world.func_625_o(i, j, k)) {
            this.dropBlockAsItemWithChance(world, i, j, k, 0);
            world.setBlockWithNotify(i, j, k, 0);
        }
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
        entitytntprimed.field_689_a = world.rand.nextInt(entitytntprimed.field_689_a / 4) + entitytntprimed.field_689_a / 8;
        world.entityJoinedWorld(entitytntprimed);
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l) {
        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(world, (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f);
        world.entityJoinedWorld(entitytntprimed);
        world.playSoundAtEntity(entitytntprimed, "random.fuse", 1.0f, 1.0f);
    }
}

