/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew;

import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.NetworkMasterThread;
import com.mojang.minecraft.networknew.NetworkReaderThread;
import com.mojang.minecraft.networknew.NetworkWriterThread;
import com.mojang.minecraft.networknew.ThreadCloseConnection;
import com.mojang.minecraft.networknew.packet.Packet;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NetworkManager {
    public static final Object threadSyncObject = new Object();
    public static int numReadThreads;
    public static int numWriteThreads;
    private Object sendQueueLock = new Object();
    private Socket networkSocket;
    private final SocketAddress remoteSocketAddress;
    private DataInputStream socketInputStream;
    private DataOutputStream socketOutputStream;
    private boolean isRunning = true;
    private List readPackets = Collections.synchronizedList(new ArrayList());
    private List dataPackets = Collections.synchronizedList(new ArrayList());
    private List chunkDataPackets = Collections.synchronizedList(new ArrayList());
    private NetHandler netHandler;
    private boolean isServerTerminating = false;
    private Thread writeThread;
    private Thread readThread;
    private boolean isTerminating = false;
    private String terminationReason = "";
    private Object[] field_20101_t;
    private int timeSinceLastRead = 0;
    private int sendQueueByteLength = 0;
    public static int[] field_28145_d;
    public static int[] field_28144_e;
    public int chunkDataSendCounter = 0;
    private int field_20100_w = 50;

    static {
        field_28145_d = new int[256];
        field_28144_e = new int[256];
    }

    public NetworkManager(Socket socket, String s, NetHandler nethandler) throws IOException {
        this.networkSocket = socket;
        this.remoteSocketAddress = socket.getRemoteSocketAddress();
        this.netHandler = nethandler;
        try {
            socket.setSoTimeout(30000);
            socket.setTrafficClass(24);
        }
        catch (SocketException socketexception) {
            System.err.println(socketexception.getMessage());
        }
        this.socketInputStream = new DataInputStream(socket.getInputStream());
        this.socketOutputStream = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream(), 5120));
        this.readThread = new NetworkReaderThread(this, s + " read thread");
        this.writeThread = new NetworkWriterThread(this, s + " write thread");
        this.readThread.start();
        this.writeThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToSendQueue(Packet packet) {
        if (this.isServerTerminating) {
            return;
        }
        Object object = this.sendQueueLock;
        synchronized (object) {
            this.sendQueueByteLength += packet.getPacketSize() + 1;
            System.out.println("Packet to write: " + packet);
            if (packet.isChunkDataPacket) {
                this.chunkDataPackets.add(packet);
            } else {
                this.dataPackets.add(packet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPacket() {
        boolean flag;
        block10: {
            flag = false;
            try {
                Packet packet1;
                Object object;
                if (!(this.dataPackets.isEmpty() || this.chunkDataSendCounter != 0 && System.currentTimeMillis() - ((Packet)this.dataPackets.get((int)0)).creationTimeMillis < (long)this.chunkDataSendCounter)) {
                    Packet packet;
                    object = this.sendQueueLock;
                    synchronized (object) {
                        packet = (Packet)this.dataPackets.remove(0);
                        this.sendQueueByteLength -= packet.getPacketSize() + 1;
                    }
                    Packet.writePacket(packet, this.socketOutputStream);
                    int n = packet.getPacketId();
                    field_28144_e[n] = field_28144_e[n] + (packet.getPacketSize() + 1);
                    flag = true;
                }
                if (this.field_20100_w-- > 0 || this.chunkDataPackets.isEmpty() || this.chunkDataSendCounter != 0 && System.currentTimeMillis() - ((Packet)this.chunkDataPackets.get((int)0)).creationTimeMillis < (long)this.chunkDataSendCounter) break block10;
                object = this.sendQueueLock;
                synchronized (object) {
                    packet1 = (Packet)this.chunkDataPackets.remove(0);
                    this.sendQueueByteLength -= packet1.getPacketSize() + 1;
                }
                Packet.writePacket(packet1, this.socketOutputStream);
                int n = packet1.getPacketId();
                field_28144_e[n] = field_28144_e[n] + (packet1.getPacketSize() + 1);
                this.field_20100_w = 0;
                flag = true;
            }
            catch (Exception exception) {
                if (!this.isTerminating) {
                    this.onNetworkError(exception);
                }
                return false;
            }
        }
        return flag;
    }

    public void wakeThreads() {
        this.readThread.interrupt();
        this.writeThread.interrupt();
    }

    private boolean readPacket() {
        boolean flag = false;
        try {
            Packet packet = Packet.readPacket(this.socketInputStream, this.netHandler.isServerHandler());
            if (packet != null) {
                int n = packet.getPacketId();
                field_28145_d[n] = field_28145_d[n] + (packet.getPacketSize() + 1);
                this.readPackets.add(packet);
                flag = true;
            } else {
                this.networkShutdown("End of Stream", new Object[0]);
            }
        }
        catch (Exception exception) {
            if (!this.isTerminating) {
                this.onNetworkError(exception);
            }
            return false;
        }
        return flag;
    }

    private void onNetworkError(Exception exception) {
        exception.printStackTrace();
        this.networkShutdown("Disconnected: " + exception, new Object[]{"Internal exception: " + exception.toString()});
    }

    public void networkShutdown(String s, Object[] aobj) {
        if (!this.isRunning) {
            return;
        }
        this.isTerminating = true;
        this.terminationReason = s;
        this.field_20101_t = aobj;
        new NetworkMasterThread(this).start();
        this.isRunning = false;
        try {
            this.socketInputStream.close();
            this.socketInputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.socketOutputStream.close();
            this.socketOutputStream = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.networkSocket.close();
            this.networkSocket = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void processReadPackets() {
        if (this.sendQueueByteLength > 0x100000) {
            this.networkShutdown("Packet Overflow", new Object[0]);
        }
        if (this.readPackets.isEmpty()) {
            if (this.timeSinceLastRead++ == 1200) {
                this.networkShutdown("Packet Timeout", new Object[0]);
            }
        } else {
            this.timeSinceLastRead = 0;
        }
        int i = 100;
        while (!this.readPackets.isEmpty() && i-- >= 0) {
            System.out.println("Packet to read: " + this.readPackets.get(0));
            Packet packet = (Packet)this.readPackets.remove(0);
            packet.processPacket(this.netHandler);
        }
        this.wakeThreads();
        if (this.isTerminating && this.readPackets.isEmpty()) {
            this.netHandler.handleErrorMessage(this.terminationReason, this.field_20101_t);
        }
    }

    public void func_28142_c() {
        this.wakeThreads();
        this.isServerTerminating = true;
        this.readThread.interrupt();
        new ThreadCloseConnection(this).start();
    }

    static boolean isRunning(NetworkManager networkmanager) {
        return networkmanager.isRunning;
    }

    static boolean isServerTerminating(NetworkManager networkmanager) {
        return networkmanager.isServerTerminating;
    }

    static boolean readNetworkPacket(NetworkManager networkmanager) {
        return networkmanager.readPacket();
    }

    static boolean sendNetworkPacket(NetworkManager networkmanager) {
        return networkmanager.sendPacket();
    }

    static DataOutputStream func_28140_f(NetworkManager networkmanager) {
        return networkmanager.socketOutputStream;
    }

    static boolean func_28138_e(NetworkManager networkmanager) {
        return networkmanager.isTerminating;
    }

    static void func_30005_a(NetworkManager networkmanager, Exception exception) {
        networkmanager.onNetworkError(exception);
    }

    static Thread getReadThread(NetworkManager networkmanager) {
        return networkmanager.readThread;
    }

    static Thread getWriteThread(NetworkManager networkmanager) {
        return networkmanager.writeThread;
    }
}

