/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.inventory;

import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;

public class Slot {
    public final int slotIndex;
    public final IInventory inventory;
    public int slotNumber;
    public int xDisplayPosition;
    public int yDisplayPosition;

    public Slot(IInventory iinventory, int i) {
        this.inventory = iinventory;
        this.slotIndex = i;
    }

    public void onPickupFromSlot() {
        this.onSlotChanged();
    }

    public void onPickupFromSlot(ItemStack itemstack) {
        this.onSlotChanged();
    }

    public boolean isItemValid(ItemStack itemstack) {
        return true;
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(this.slotIndex);
    }

    public void putStack(ItemStack itemstack) {
        this.inventory.setInventorySlotContents(this.slotIndex, itemstack);
        this.onSlotChanged();
    }

    public int getSlotStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public int getBackgroundIconIndex() {
        return -1;
    }

    public void onSlotChanged() {
        this.inventory.onInventoryChanged();
    }

    public ItemStack decrStackSize(int i) {
        return this.inventory.decrStackSize(this.slotIndex, i);
    }
}

