/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.player.controller.GameSettings;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.Tessellator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class FontRenderer {
    private int[] charWidth = new int[256];
    public int fontTextureName = 0;
    private int fontDisplayLists;
    private IntBuffer buffer = GLAllocation.createDirectIntBuffer(1024);

    public FontRenderer(GameSettings gamesettings, String s, RenderEngine renderengine) {
        BufferedImage bufferedimage;
        try {
            bufferedimage = ImageIO.read(RenderEngine.class.getResourceAsStream(s));
        }
        catch (IOException ioexception) {
            throw new RuntimeException(ioexception);
        }
        int i = bufferedimage.getWidth();
        int j = bufferedimage.getHeight();
        int[] ai = new int[i * j];
        bufferedimage.getRGB(0, 0, i, j, ai, 0, i);
        int k = 0;
        while (k < 256) {
            int j2;
            int l = k % 16;
            int k1 = k / 16;
            for (j2 = 7; j2 >= 0; --j2) {
                int i3 = l * 8 + j2;
                boolean flag = true;
                int l3 = 0;
                while (l3 < 8 && flag) {
                    int i4 = (k1 * 8 + l3) * i;
                    int k4 = ai[i3 + i4] & 0xFF;
                    if (k4 > 0) {
                        flag = false;
                    }
                    ++l3;
                }
                if (!flag) break;
            }
            if (k == 32) {
                j2 = 2;
            }
            this.charWidth[k] = j2 + 2;
            ++k;
        }
        this.fontTextureName = renderengine.func_1074_a(bufferedimage);
        this.fontDisplayLists = GLAllocation.func_1124_a(288);
        Tessellator tessellator = Tessellator.field_1512_a;
        int i1 = 0;
        while (i1 < 256) {
            GL11.glNewList((int)(this.fontDisplayLists + i1), (int)4864);
            tessellator.func_977_b();
            int l1 = i1 % 16 * 8;
            int k2 = i1 / 16 * 8;
            float f = 7.99f;
            float f1 = 0.0f;
            float f2 = 0.0f;
            tessellator.addVertexWithUV(0.0, 0.0f + f, 0.0, (float)l1 / 128.0f + f1, ((float)k2 + f) / 128.0f + f2);
            tessellator.addVertexWithUV(0.0f + f, 0.0f + f, 0.0, ((float)l1 + f) / 128.0f + f1, ((float)k2 + f) / 128.0f + f2);
            tessellator.addVertexWithUV(0.0f + f, 0.0, 0.0, ((float)l1 + f) / 128.0f + f1, (float)k2 / 128.0f + f2);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, (float)l1 / 128.0f + f1, (float)k2 / 128.0f + f2);
            tessellator.func_982_a();
            GL11.glTranslatef((float)this.charWidth[i1], (float)0.0f, (float)0.0f);
            GL11.glEndList();
            ++i1;
        }
        int j1 = 0;
        while (j1 < 32) {
            boolean flag1;
            int i2 = (j1 >> 3 & 1) * 85;
            int l2 = (j1 >> 2 & 1) * 170 + i2;
            int j3 = (j1 >> 1 & 1) * 170 + i2;
            int k3 = (j1 >> 0 & 1) * 170 + i2;
            if (j1 == 6) {
                l2 += 85;
            }
            boolean bl = flag1 = j1 >= 16;
            if (gamesettings.anaglyph) {
                int j4 = (l2 * 30 + j3 * 59 + k3 * 11) / 100;
                int l4 = (l2 * 30 + j3 * 70) / 100;
                int i5 = (l2 * 30 + k3 * 70) / 100;
                l2 = j4;
                j3 = l4;
                k3 = i5;
            }
            if (flag1) {
                l2 /= 4;
                j3 /= 4;
                k3 /= 4;
            }
            GL11.glNewList((int)(this.fontDisplayLists + 256 + j1), (int)4864);
            GL11.glColor3f((float)((float)l2 / 255.0f), (float)((float)j3 / 255.0f), (float)((float)k3 / 255.0f));
            GL11.glEndList();
            ++j1;
        }
    }

    public void drawStringWithShadow(String s, int i, int j, int k) {
        this.renderString(s, i + 1, j + 1, k, true);
        this.drawString(s, i, j, k);
    }

    public void drawString(String s, int i, int j, int k) {
        this.renderString(s, i, j, k, false);
    }

    /*
     * Exception decompiling
     */
    public void renderString(String s, int i, int j, int k, boolean flag) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getStringWidth(String s) {
        if (s == null) {
            return 0;
        }
        int i = 0;
        int j = 0;
        while (j < s.length()) {
            if (s.charAt(j) == '\u00a7') {
                ++j;
            } else {
                int k = ChatAllowedCharacters.allowedCharacters.indexOf(s.charAt(j));
                if (k >= 0) {
                    i += this.charWidth[k + 1];
                }
            }
            ++j;
        }
        return i;
    }
}

