/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import java.util.List;

public class EntityBoat
extends Entity {
    public int field_807_a = 0;
    public int field_806_b = 0;
    public int field_808_c = 1;

    public EntityBoat(World world) {
        super(world);
        this.preventEntitySpawning = true;
        this.setBounds(1.5f, 0.6f);
        this.eyeHeight = this.height / 2.0f;
        this.field_640_aG = false;
    }

    @Override
    public AxisAlignedBB func_383_b_(Entity entity) {
        return entity.boundingBox;
    }

    @Override
    public AxisAlignedBB func_372_f_() {
        return this.boundingBox;
    }

    @Override
    public boolean func_385_d_() {
        return true;
    }

    public EntityBoat(World world, double d, double d1, double d2) {
        this(world);
        this.moveToPosDouble(d, d1 + (double)this.eyeHeight, d2);
        this.motionX = 0.0;
        this.motionY = 0.0;
        this.motionZ = 0.0;
        this.prevPosX = d;
        this.prevPosY = d1;
        this.prevPosZ = d2;
    }

    @Override
    public double func_402_h() {
        return (double)this.height * 0.0 - (double)0.3f;
    }

    @Override
    public boolean attacked(Entity entity, int i) {
        this.field_808_c = -this.field_808_c;
        this.field_806_b = 10;
        this.field_807_a += i * 10;
        if (this.field_807_a > 40) {
            this.dropItem(Item.boat.shiftedIndex, 1, 0.0f);
            this.func_395_F();
        }
        return true;
    }

    @Override
    public boolean func_401_c_() {
        return !this.hasDied;
    }

    @Override
    public void onUpdate() {
        double d3;
        super.onUpdate();
        if (this.field_806_b > 0) {
            --this.field_806_b;
        }
        if (this.field_807_a > 0) {
            --this.field_807_a;
        }
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int i = 5;
        double d = 0.0;
        int j = 0;
        while (j < i) {
            double d2 = this.boundingBox.minY + (this.boundingBox.field_1702_e - this.boundingBox.minY) * (double)(j + 0) / (double)i - 0.125;
            double d4 = this.boundingBox.minY + (this.boundingBox.field_1702_e - this.boundingBox.minY) * (double)(j + 1) / (double)i - 0.125;
            AxisAlignedBB axisalignedbb = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.field_1698_a, d2, this.boundingBox.field_1704_c, this.boundingBox.field_1703_d, d4, this.boundingBox.field_1701_f);
            if (this.worldObj.func_707_b(axisalignedbb, Material.water)) {
                d += 1.0 / (double)i;
            }
            ++j;
        }
        double d1 = d * 2.0 - 1.0;
        this.motionY += 0.04 * d1;
        if (this.riddenByEntity != null) {
            this.motionX += this.riddenByEntity.motionX * 0.4;
            this.motionZ += this.riddenByEntity.motionZ * 0.4;
        }
        if (this.motionX < -(d3 = 0.6)) {
            this.motionX = -d3;
        }
        if (this.motionX > d3) {
            this.motionX = d3;
        }
        if (this.motionZ < -d3) {
            this.motionZ = -d3;
        }
        if (this.motionZ > d3) {
            this.motionZ = d3;
        }
        if (this.onGround) {
            this.motionX *= 0.5;
            this.motionY *= 0.5;
            this.motionZ *= 0.5;
        }
        this.func_349_c(this.motionX, this.motionY, this.motionZ);
        double d5 = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        if (d5 > 0.15) {
            double d6 = Math.cos((double)this.rotationYaw * Math.PI / 180.0);
            double d8 = Math.sin((double)this.rotationYaw * Math.PI / 180.0);
            int i1 = 0;
            while ((double)i1 < 1.0 + d5 * 60.0) {
                double d11 = this.rand.nextFloat() * 2.0f - 1.0f;
                double d13 = (double)(this.rand.nextInt(2) * 2 - 1) * 0.7;
                if (this.rand.nextBoolean()) {
                    double d14 = this.posX - d6 * d11 * 0.8 + d8 * d13;
                    double d16 = this.posZ - d8 * d11 * 0.8 - d6 * d13;
                    this.worldObj.spawnParticle("splash", d14, this.posY - 0.125, d16, this.motionX, this.motionY, this.motionZ);
                } else {
                    double d15 = this.posX + d6 + d8 * d11 * 0.7;
                    double d17 = this.posZ + d8 - d6 * d11 * 0.7;
                    this.worldObj.spawnParticle("splash", d15, this.posY - 0.125, d17, this.motionX, this.motionY, this.motionZ);
                }
                ++i1;
            }
        }
        this.motionX *= (double)0.99f;
        this.motionY *= (double)0.95f;
        this.motionZ *= (double)0.99f;
        this.rotationPitch = 0.0f;
        double d7 = this.rotationYaw;
        double d9 = this.prevPosX - this.posX;
        double d10 = this.prevPosZ - this.posZ;
        if (d9 * d9 + d10 * d10 > 0.001) {
            d7 = (float)(Math.atan2(d10, d9) * 180.0 / Math.PI);
        }
        double d12 = d7 - (double)this.rotationYaw;
        while (d12 >= 180.0) {
            d12 -= 360.0;
        }
        while (d12 < -180.0) {
            d12 += 360.0;
        }
        if (d12 > 20.0) {
            d12 = 20.0;
        }
        if (d12 < -20.0) {
            d12 = -20.0;
        }
        this.rotationYaw = (float)((double)this.rotationYaw + d12);
        this.func_376_c(this.rotationYaw, this.rotationPitch);
        List<Entity> list = this.worldObj.func_659_b(this, this.boundingBox.func_1177_b(0.2f, 0.0, 0.2f));
        if (list != null && list.size() > 0) {
            int j1 = 0;
            while (j1 < list.size()) {
                Entity entity = list.get(j1);
                if (entity != this.riddenByEntity && entity.func_385_d_() && entity instanceof EntityBoat) {
                    entity.func_380_f(this);
                }
                ++j1;
            }
        }
        if (this.riddenByEntity != null && this.riddenByEntity.hasDied) {
            this.riddenByEntity = null;
        }
    }

    @Override
    protected void func_366_i_() {
        double d = Math.cos((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        double d1 = Math.sin((double)this.rotationYaw * Math.PI / 180.0) * 0.4;
        this.riddenByEntity.moveToPosDouble(this.posX + d, this.posY + this.func_402_h() + this.riddenByEntity.func_388_v(), this.posZ + d1);
    }

    @Override
    protected void addNBTTag(NBTTagCompound nbttagcompound) {
    }

    @Override
    protected void removeNBTTag(NBTTagCompound nbttagcompound) {
    }

    @Override
    public float func_392_h_() {
        return 0.0f;
    }

    @Override
    public boolean checkRide(EntityPlayer entityplayer) {
        entityplayer.mountEntity(this);
        return true;
    }
}

