/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.IMobs;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.util.MathHelper;

public class EntitySlime
extends EntityLiving
implements IMobs {
    public float field_768_a;
    public float field_767_b;
    private int field_769_d = 0;
    public int field_770_c = 1;

    public EntitySlime(World world) {
        super(world);
        this.texture = "/mob/slime.png";
        this.field_770_c = 1 << this.rand.nextInt(3);
        this.eyeHeight = 0.0f;
        this.field_769_d = this.rand.nextInt(20) + 10;
        this.func_441_c(this.field_770_c);
    }

    public void func_441_c(int i) {
        this.field_770_c = i;
        this.setBounds(0.6f * (float)i, 0.6f * (float)i);
        this.health = i * i;
        this.moveToPosDouble(this.posX, this.posY, this.posZ);
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        super.addNBTTag(nbttagcompound);
        nbttagcompound.setInteger("Size", this.field_770_c - 1);
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        super.removeNBTTag(nbttagcompound);
        this.field_770_c = nbttagcompound.func_756_e("Size") + 1;
    }

    @Override
    public void onUpdate() {
        this.field_767_b = this.field_768_a;
        boolean flag = this.onGround;
        super.onUpdate();
        if (this.onGround && !flag) {
            int i = 0;
            while (i < this.field_770_c * 8) {
                float f = this.rand.nextFloat() * 3.141593f * 2.0f;
                float f1 = this.rand.nextFloat() * 0.5f + 0.5f;
                float f2 = MathHelper.sin(f) * (float)this.field_770_c * 0.5f * f1;
                float f3 = MathHelper.cos(f) * (float)this.field_770_c * 0.5f * f1;
                this.worldObj.spawnParticle("slime", this.posX + (double)f2, this.boundingBox.minY, this.posZ + (double)f3, 0.0, 0.0, 0.0);
                ++i;
            }
            if (this.field_770_c > 2) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            }
            this.field_768_a = -0.5f;
        }
        this.field_768_a *= 0.6f;
    }

    @Override
    protected void updateEntityActionState() {
        EntityPlayer entityplayer = this.worldObj.getPlayerEntityAtHeight(this, 16.0);
        if (entityplayer != null) {
            this.func_426_b(entityplayer, 10.0f);
        }
        if (this.onGround && this.field_769_d-- <= 0) {
            this.field_769_d = this.rand.nextInt(20) + 10;
            if (entityplayer != null) {
                this.field_769_d /= 3;
            }
            this.isJumping = true;
            if (this.field_770_c > 1) {
                this.worldObj.playSoundAtEntity(this, "mob.slime", this.func_413_f(), ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f) * 0.8f);
            }
            this.field_768_a = 1.0f;
            this.movingLeftRight = 1.0f - this.rand.nextFloat() * 2.0f;
            this.movingForwardBack = 1 * this.field_770_c;
        } else {
            this.isJumping = false;
            if (this.onGround) {
                this.movingForwardBack = 0.0f;
                this.movingLeftRight = 0.0f;
            }
        }
    }

    @Override
    public void func_395_F() {
        if (this.field_770_c > 1 && this.health <= 0) {
            int i = 0;
            while (i < 4) {
                float f = ((float)(i % 2) - 0.5f) * (float)this.field_770_c / 4.0f;
                float f1 = ((float)(i / 2) - 0.5f) * (float)this.field_770_c / 4.0f;
                EntitySlime entityslime = new EntitySlime(this.worldObj);
                entityslime.func_441_c(this.field_770_c / 2);
                entityslime.spawnNewEntity(this.posX + (double)f, this.posY + 0.5, this.posZ + (double)f1, this.rand.nextFloat() * 360.0f, 0.0f);
                this.worldObj.entityJoinedWorld(entityslime);
                ++i;
            }
        }
        super.func_395_F();
    }

    @Override
    public void func_362_b(EntityPlayer entityplayer) {
        if (this.field_770_c > 1 && this.canEntityBeSeen(entityplayer) && (double)this.getDistanceToEntity(entityplayer) < 0.6 * (double)this.field_770_c && entityplayer.attacked(this, this.field_770_c)) {
            this.worldObj.playSoundAtEntity(this, "mob.slimeattack", 1.0f, (this.rand.nextFloat() - this.rand.nextFloat()) * 0.2f + 1.0f);
        }
    }

    @Override
    protected String hurtSound() {
        return "mob.slime";
    }

    @Override
    protected String deathSound() {
        return "mob.slime";
    }

    @Override
    protected int deathDropItem() {
        if (this.field_770_c == 1) {
            return Item.slimeBall.shiftedIndex;
        }
        return 0;
    }

    @Override
    public boolean func_433_a() {
        Chunk chunk = this.worldObj.getChunkFromBlockCoords(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY));
        return (this.field_770_c == 1 || this.worldObj.difficulty > 0) && this.rand.nextInt(10) == 0 && chunk.func_997_a(987234911L).nextInt(10) == 0 && this.posY < 16.0;
    }

    @Override
    protected float func_413_f() {
        return 0.6f;
    }
}

