/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.List;

public class EntitySnowball
extends Entity {
    private int field_816_b = -1;
    private int field_815_c = -1;
    private int field_814_d = -1;
    private int field_813_e = 0;
    private boolean field_812_f = false;
    public int field_817_a = 0;
    private EntityLiving field_811_g;
    private int field_810_h;
    private int field_809_i = 0;

    public EntitySnowball(World world) {
        super(world);
        this.setBounds(0.25f, 0.25f);
    }

    @Override
    public boolean func_384_a(double d) {
        double d1 = this.boundingBox.func_1164_b() * 4.0;
        return d < (d1 *= 64.0) * d1;
    }

    public EntitySnowball(World world, EntityLiving entityliving) {
        super(world);
        this.field_811_g = entityliving;
        this.setBounds(0.25f, 0.25f);
        this.spawnNewEntity(entityliving.posX, entityliving.posY, entityliving.posZ, entityliving.rotationYaw, entityliving.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.moveToPosDouble(this.posX, this.posY, this.posZ);
        this.eyeHeight = 0.0f;
        float f = 0.4f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.func_467_a(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    public void func_467_a(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.squareRootDoubleToFloat(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d *= (double)f;
        this.motionY = d1 *= (double)f;
        this.motionZ = d2 *= (double)f;
        float f3 = MathHelper.squareRootDoubleToFloat(d * d + d2 * d2);
        this.headYaw = this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.headPitch = this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.field_810_h = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onUpdate() {
        block18: {
            super.onUpdate();
            if (this.field_817_a > 0) {
                --this.field_817_a;
            }
            if (this.field_812_f) {
                int i = this.worldObj.getBlockId(this.field_816_b, this.field_815_c, this.field_814_d);
                if (i != this.field_813_e) {
                    this.field_812_f = false;
                    this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
                    this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
                    this.field_810_h = 0;
                    this.field_809_i = 0;
                    break block18;
                } else {
                    ++this.field_810_h;
                    if (this.field_810_h == 1200) {
                        this.func_395_F();
                    }
                    return;
                }
            }
            ++this.field_809_i;
        }
        Vec3D vec3d = Vec3D.newVectorAndAddToPool(this.posX, this.posY, this.posZ);
        Vec3D vec3d1 = Vec3D.newVectorAndAddToPool(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition movingobjectposition = this.worldObj.clip(vec3d, vec3d1);
        vec3d = Vec3D.newVectorAndAddToPool(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.newVectorAndAddToPool(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec3d1 = Vec3D.newVectorAndAddToPool(movingobjectposition.field_1169_f.xCoord, movingobjectposition.field_1169_f.yCoord, movingobjectposition.field_1169_f.zCoord);
        }
        Entity entity = null;
        List<Entity> list = this.worldObj.func_659_b(this, this.boundingBox.func_1170_a(this.motionX, this.motionY, this.motionZ).func_1177_b(1.0, 1.0, 1.0));
        double d = 0.0;
        int j = 0;
        while (j < list.size()) {
            double d1;
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition1;
            Entity entity1 = list.get(j);
            if (entity1.func_401_c_() && (entity1 != this.field_811_g || this.field_809_i >= 5) && (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.func_1177_b(f2 = 0.3f, f2, f2)).func_1169_a(vec3d, vec3d1)) != null && ((d1 = vec3d.getMagnitude(movingobjectposition1.field_1169_f)) < d || d == 0.0)) {
                entity = entity1;
                d = d1;
            }
            ++j;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entityHit == null || !movingobjectposition.entityHit.attacked(this.field_811_g, 0)) {
                // empty if block
            }
            int k = 0;
            while (k < 8) {
                this.worldObj.spawnParticle("snowballpoof", this.posX, this.posY, this.posZ, 0.0, 0.0, 0.0);
                ++k;
            }
            this.func_395_F();
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        float f = MathHelper.squareRootDoubleToFloat(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch - this.headPitch < -180.0f) {
            this.headPitch -= 360.0f;
        }
        while (this.rotationPitch - this.headPitch >= 180.0f) {
            this.headPitch += 360.0f;
        }
        while (this.rotationYaw - this.headYaw < -180.0f) {
            this.headYaw -= 360.0f;
        }
        while (this.rotationYaw - this.headYaw >= 180.0f) {
            this.headYaw += 360.0f;
        }
        this.rotationPitch = this.headPitch + (this.rotationPitch - this.headPitch) * 0.2f;
        this.rotationYaw = this.headYaw + (this.rotationYaw - this.headYaw) * 0.2f;
        float f1 = 0.99f;
        float f3 = 0.03f;
        if (this.isInWater()) {
            int l = 0;
            while (l < 4) {
                float f4 = 0.25f;
                this.worldObj.spawnParticle("bubble", this.posX - this.motionX * (double)f4, this.posY - this.motionY * (double)f4, this.posZ - this.motionZ * (double)f4, this.motionX, this.motionY, this.motionZ);
                ++l;
            }
            f1 = 0.8f;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.motionY -= (double)f3;
        this.moveToPosDouble(this.posX, this.posY, this.posZ);
    }

    @Override
    public void addNBTTag(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_749_a("xTile", (short)this.field_816_b);
        nbttagcompound.func_749_a("yTile", (short)this.field_815_c);
        nbttagcompound.func_749_a("zTile", (short)this.field_814_d);
        nbttagcompound.setByte("inTile", (byte)this.field_813_e);
        nbttagcompound.setByte("shake", (byte)this.field_817_a);
        nbttagcompound.setByte("inGround", (byte)(this.field_812_f ? 1 : 0));
    }

    @Override
    public void removeNBTTag(NBTTagCompound nbttagcompound) {
        this.field_816_b = nbttagcompound.func_745_d("xTile");
        this.field_815_c = nbttagcompound.func_745_d("yTile");
        this.field_814_d = nbttagcompound.func_745_d("zTile");
        this.field_813_e = nbttagcompound.func_746_c("inTile") & 0xFF;
        this.field_817_a = nbttagcompound.func_746_c("shake") & 0xFF;
        this.field_812_f = nbttagcompound.func_746_c("inGround") == 1;
    }

    @Override
    public void func_362_b(EntityPlayer entityplayer) {
        if (this.field_812_f && this.field_811_g == entityplayer && this.field_817_a <= 0 && entityplayer.inventory.func_504_a(new ItemStack(Item.arrow.shiftedIndex, 1))) {
            this.worldObj.playSoundAtEntity(this, "random.pop", 0.2f, ((this.rand.nextFloat() - this.rand.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.func_443_a_(this, 1);
            this.func_395_F();
        }
    }

    @Override
    public float func_392_h_() {
        return 0.0f;
    }
}

