/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate;

import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.entity.tile.TileEntityMobSpawner;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.generate.WorldGenerator;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class WorldGenWaterDungeons
extends WorldGenerator {
    @Override
    public boolean generate(World world, Random random, int x, int y, int z) {
        int dungeonHeight = 3;
        int randomWidthX = random.nextInt(2) + 2;
        int randomWidthZ = random.nextInt(2) + 2;
        int validSpots = 0;
        int spotCheckX = x - randomWidthX - 1;
        while (spotCheckX <= x + randomWidthX + 1) {
            int spotCheckY = y - 1;
            while (spotCheckY <= y + dungeonHeight + 1) {
                int spotCheckZ = z - randomWidthZ - 1;
                while (spotCheckZ <= z + randomWidthZ + 1) {
                    if ((spotCheckX == x - randomWidthX - 1 || spotCheckX == x + randomWidthX + 1 || spotCheckZ == z - randomWidthZ - 1 || spotCheckZ == z + randomWidthZ + 1) && spotCheckY == y && world.getBlockId(spotCheckX, spotCheckY, spotCheckZ) != 9 && world.getBlockId(spotCheckX, spotCheckY + 1, spotCheckZ) == 9 && world.getBlockId(spotCheckX, spotCheckY + 2, spotCheckZ) == 9 && world.getBlockId(spotCheckX, spotCheckY + 3, spotCheckZ) == 9 && world.getBlockId(spotCheckX, spotCheckY + 4, spotCheckZ) == 9 && world.getBlockId(spotCheckX, spotCheckY + 5, spotCheckZ) == 9 && world.getBlockId(spotCheckX, spotCheckY + 6, spotCheckZ) == 9) {
                        ++validSpots;
                    }
                    ++spotCheckZ;
                }
                ++spotCheckY;
            }
            ++spotCheckX;
        }
        if (validSpots < 1 || validSpots > 50) {
            return false;
        }
        int blockGenX = x - randomWidthX - 1;
        while (blockGenX <= x + randomWidthX + 1) {
            int blockGenY = y + dungeonHeight;
            while (blockGenY >= y - 1) {
                int blockGenZ = z - randomWidthZ - 1;
                while (blockGenZ <= z + randomWidthZ + 1) {
                    if (blockGenX == x - randomWidthX - 1 || blockGenY == y - 1 || blockGenZ == z - randomWidthZ - 1 || blockGenX == x + randomWidthX + 1 || blockGenY == y + dungeonHeight + 1 || blockGenZ == z + randomWidthZ + 1) {
                        if (blockGenY >= 0 && !world.getMaterialXYZ(blockGenX, blockGenY - 1, blockGenZ).isSolidMaterial()) {
                            if (world.getBlockId(blockGenX, blockGenY, blockGenZ) != 0 && blockGenY < 64) {
                                world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brick.blockID);
                            }
                        } else if (world.getMaterialXYZ(blockGenX, blockGenY, blockGenZ) == Material.water) {
                            if (blockGenY == y - 1 && random.nextInt(4) != 0) {
                                world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.dirt.blockID);
                            } else {
                                world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, Block.brick.blockID);
                            }
                        }
                    } else if (world.getBlockId(blockGenX, blockGenY, blockGenZ) != 0 && blockGenY < 64) {
                        world.setBlockWithNotify(blockGenX, blockGenY, blockGenZ, 0);
                        world.setBlockWithNotify(blockGenX, y + dungeonHeight, blockGenZ, Block.brick.blockID);
                    }
                    ++blockGenZ;
                }
                --blockGenY;
            }
            ++blockGenX;
        }
        int i2 = 0;
        while (i2 < 2) {
            int l2 = 0;
            while (l2 < 3) {
                int i4;
                int l3;
                int k3 = x + random.nextInt(randomWidthX * 2 + 1) - randomWidthX;
                if (world.getBlockId(k3, l3 = y, i4 = z + random.nextInt(randomWidthZ * 2 + 1) - randomWidthZ) != 9) {
                    int viableSpace = 0;
                    if (world.getMaterialXYZ(k3 - 1, l3, i4).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3 + 1, l3, i4).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 - 1).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (world.getMaterialXYZ(k3, l3, i4 + 1).isSolidMaterial()) {
                        ++viableSpace;
                    }
                    if (viableSpace == 1) {
                        world.setBlockWithNotify(k3, l3, i4, Block.crate.blockID);
                        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(k3, l3, i4);
                        for (int k4 = 0; k4 < 8; ++k4) {
                            ItemStack itemstack = this.chestLoot(random);
                            if (itemstack == null) continue;
                            tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
                        }
                        break;
                    }
                }
                ++l2;
            }
            ++i2;
        }
        world.setBlockWithNotify(x, y, z, Block.mobSpawner.blockID);
        TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(x, y, z);
        world.setBlockWithNotify(x, y - 1, z, Block.sponge.blockID);
        world.notifyBlocksOfNeighborChange(x, y - 1, z, 1);
        tileentitymobspawner.entityID = this.func_531_b(random);
        return true;
    }

    private ItemStack chestLoot(Random random) {
        int i = random.nextInt(11);
        if (i == 0) {
            return new ItemStack(Block.sponge, random.nextInt(4) + 1);
        }
        if (i == 1) {
            return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
        }
        if (i == 2) {
            return new ItemStack(Item.paper, random.nextInt(4) + 1);
        }
        if (i == 3) {
            return new ItemStack(Item.reed, random.nextInt(4) + 1);
        }
        if (i == 4) {
            return new ItemStack(Item.flint, random.nextInt(4) + 1);
        }
        if (i == 5) {
            int roll = random.nextInt(3);
            if (roll == 0) {
                return new ItemStack(Item.helmetChain);
            }
            if (roll == 1) {
                return new ItemStack(Item.plateChain);
            }
            if (roll == 2) {
                return new ItemStack(Item.legsChain);
            }
            if (roll == 3) {
                return new ItemStack(Item.bootsChain);
            }
        }
        if (i == 6) {
            return new ItemStack(Item.bucketWater);
        }
        if (i == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.appleGold);
        }
        if (i == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.redstone, random.nextInt(4) + 1);
        }
        if (i == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.diamond);
        }
        return null;
    }

    private String func_531_b(Random random) {
        int i = random.nextInt(4);
        if (i == 0) {
            return "Skeleton";
        }
        if (i == 1) {
            return "Zombie";
        }
        if (i == 2) {
            return "Zombie";
        }
        if (i == 3) {
            return "Spider";
        }
        return "";
    }
}

