/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.IInventory;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityChest;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockContainer;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.player.inventory.InventoryLargeChest;
import java.util.Random;

public class BlockChest
extends BlockContainer {
    private Random field_457_a = new Random();

    protected BlockChest(int i) {
        super(i, Material.wood);
        this.blockIndexInTexture = 26;
    }

    @Override
    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (l == 0) {
            return this.blockIndexInTexture - 1;
        }
        int i1 = iblockaccess.getBlockId(i, j, k - 1);
        int j1 = iblockaccess.getBlockId(i, j, k + 1);
        int k1 = iblockaccess.getBlockId(i - 1, j, k);
        int l1 = iblockaccess.getBlockId(i + 1, j, k);
        if (i1 == this.blockID || j1 == this.blockID) {
            if (l == 2 || l == 3) {
                return this.blockIndexInTexture;
            }
            int i2 = 0;
            if (i1 == this.blockID) {
                i2 = -1;
            }
            int k2 = iblockaccess.getBlockId(i - 1, j, i1 != this.blockID ? k + 1 : k - 1);
            int i3 = iblockaccess.getBlockId(i + 1, j, i1 != this.blockID ? k + 1 : k - 1);
            if (l == 4) {
                i2 = -1 - i2;
            }
            int byte1 = 5;
            if ((Block.opaqueCubeLookup[k1] || Block.opaqueCubeLookup[k2]) && !Block.opaqueCubeLookup[l1] && !Block.opaqueCubeLookup[i3]) {
                byte1 = 5;
            }
            if ((Block.opaqueCubeLookup[l1] || Block.opaqueCubeLookup[i3]) && !Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[k2]) {
                byte1 = 4;
            }
            return (l != byte1 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + i2;
        }
        if (k1 == this.blockID || l1 == this.blockID) {
            if (l == 4 || l == 5) {
                return this.blockIndexInTexture;
            }
            int j2 = 0;
            if (k1 == this.blockID) {
                j2 = -1;
            }
            int l2 = iblockaccess.getBlockId(k1 != this.blockID ? i + 1 : i - 1, j, k - 1);
            int j3 = iblockaccess.getBlockId(k1 != this.blockID ? i + 1 : i - 1, j, k + 1);
            if (l == 3) {
                j2 = -1 - j2;
            }
            int byte2 = 3;
            if ((Block.opaqueCubeLookup[i1] || Block.opaqueCubeLookup[l2]) && !Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[j3]) {
                byte2 = 3;
            }
            if ((Block.opaqueCubeLookup[j1] || Block.opaqueCubeLookup[j3]) && !Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[l2]) {
                byte2 = 2;
            }
            return (l != byte2 ? this.blockIndexInTexture + 32 : this.blockIndexInTexture + 16) + j2;
        }
        int byte0 = 3;
        if (Block.opaqueCubeLookup[i1] && !Block.opaqueCubeLookup[j1]) {
            byte0 = 3;
        }
        if (Block.opaqueCubeLookup[j1] && !Block.opaqueCubeLookup[i1]) {
            byte0 = 2;
        }
        if (Block.opaqueCubeLookup[k1] && !Block.opaqueCubeLookup[l1]) {
            byte0 = 5;
        }
        if (Block.opaqueCubeLookup[l1] && !Block.opaqueCubeLookup[k1]) {
            byte0 = 4;
        }
        return l != byte0 ? this.blockIndexInTexture : this.blockIndexInTexture + 1;
    }

    @Override
    public int getTextureIndex(int i) {
        if (i == 1) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 0) {
            return this.blockIndexInTexture - 1;
        }
        if (i == 3) {
            return this.blockIndexInTexture + 1;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        int l = 0;
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            ++l;
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID) {
            ++l;
        }
        if (l > 1) {
            return false;
        }
        if (this.func_286_h(world, i - 1, j, k)) {
            return false;
        }
        if (this.func_286_h(world, i + 1, j, k)) {
            return false;
        }
        if (this.func_286_h(world, i, j, k - 1)) {
            return false;
        }
        return !this.func_286_h(world, i, j, k + 1);
    }

    private boolean func_286_h(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return false;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            return true;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            return true;
        }
        return world.getBlockId(i, j, k + 1) == this.blockID;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        int l = 0;
        while (l < tileentitychest.getSizeInventory()) {
            ItemStack itemstack = tileentitychest.getStackInSlot(l);
            if (itemstack != null) {
                float f = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                float f1 = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_457_a.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.field_457_a.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)i + f, (float)j + f1, (float)k + f2, new ItemStack(itemstack.itemID, i1, itemstack.itemDamage));
                    float f3 = 0.05f;
                    entityitem.motionX = (float)this.field_457_a.nextGaussian() * f3;
                    entityitem.motionY = (float)this.field_457_a.nextGaussian() * f3 + 0.2f;
                    entityitem.motionZ = (float)this.field_457_a.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
            ++l;
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        IInventory obj = (TileEntityChest)world.getBlockTileEntity(i, j, k);
        if (world.isBlockNormalCube(i, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID && world.isBlockNormalCube(i - 1, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID && world.isBlockNormalCube(i + 1, j + 1, k)) {
            return true;
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID && world.isBlockNormalCube(i, j + 1, k - 1)) {
            return true;
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID && world.isBlockNormalCube(i, j + 1, k + 1)) {
            return true;
        }
        if (world.getBlockId(i - 1, j, k) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i - 1, j, k), obj);
        }
        if (world.getBlockId(i + 1, j, k) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i + 1, j, k));
        }
        if (world.getBlockId(i, j, k - 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", (TileEntityChest)world.getBlockTileEntity(i, j, k - 1), obj);
        }
        if (world.getBlockId(i, j, k + 1) == this.blockID) {
            obj = new InventoryLargeChest("Large chest", obj, (TileEntityChest)world.getBlockTileEntity(i, j, k + 1));
        }
        entityplayer.displayGUIChest(obj);
        return true;
    }

    @Override
    protected TileEntity getBlockEntity() {
        return new TileEntityChest();
    }
}

