/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;

public class BlockLever
extends Block {
    protected BlockLever(int i, int j) {
        super(i, j, Material.circuits);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean func_242_c() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 12;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i + 1, j, k)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k - 1)) {
            return true;
        }
        if (world.isBlockNormalCube(i, j, k + 1)) {
            return true;
        }
        return world.isBlockNormalCube(i, j - 1, k);
    }

    @Override
    public void onBlockPlaced(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        int j1 = i1 & 8;
        i1 &= 7;
        if (l == 1 && world.isBlockNormalCube(i, j - 1, k)) {
            i1 = 5 + world.rand.nextInt(2);
        }
        if (l == 2 && world.isBlockNormalCube(i, j, k + 1)) {
            i1 = 4;
        }
        if (l == 3 && world.isBlockNormalCube(i, j, k - 1)) {
            i1 = 3;
        }
        if (l == 4 && world.isBlockNormalCube(i + 1, j, k)) {
            i1 = 2;
        }
        if (l == 5 && world.isBlockNormalCube(i - 1, j, k)) {
            i1 = 1;
        }
        world.setBlockMetadataWithNotify(i, j, k, i1 + j1);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (world.isBlockNormalCube(i - 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
        } else if (world.isBlockNormalCube(i + 1, j, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        } else if (world.isBlockNormalCube(i, j, k - 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        } else if (world.isBlockNormalCube(i, j, k + 1)) {
            world.setBlockMetadataWithNotify(i, j, k, 4);
        } else if (world.isBlockNormalCube(i, j - 1, k)) {
            world.setBlockMetadataWithNotify(i, j, k, 5 + world.rand.nextInt(2));
        }
        this.func_267_h(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this.func_267_h(world, i, j, k)) {
            int i1 = world.getBlockMetadata(i, j, k) & 7;
            boolean flag = false;
            if (!world.isBlockNormalCube(i - 1, j, k) && i1 == 1) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i + 1, j, k) && i1 == 2) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k - 1) && i1 == 3) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j, k + 1) && i1 == 4) {
                flag = true;
            }
            if (!world.isBlockNormalCube(i, j - 1, k) && i1 == 5) {
                flag = true;
            }
            if (flag) {
                this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
                world.setBlockWithNotify(i, j, k, 0);
            }
        }
    }

    private boolean func_267_h(World world, int i, int j, int k) {
        if (!this.canPlace(world, i, j, k)) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
            return false;
        }
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockMetadata(i, j, k) & 7;
        float f = 0.1875f;
        if (l == 1) {
            this.setBlockBounds(0.0f, 0.2f, 0.5f - f, f * 2.0f, 0.8f, 0.5f + f);
        } else if (l == 2) {
            this.setBlockBounds(1.0f - f * 2.0f, 0.2f, 0.5f - f, 1.0f, 0.8f, 0.5f + f);
        } else if (l == 3) {
            this.setBlockBounds(0.5f - f, 0.2f, 0.0f, 0.5f + f, 0.8f, f * 2.0f);
        } else if (l == 4) {
            this.setBlockBounds(0.5f - f, 0.2f, 1.0f - f * 2.0f, 0.5f + f, 0.8f, 1.0f);
        } else {
            float f1 = 0.25f;
            this.setBlockBounds(0.5f - f1, 0.0f, 0.5f - f1, 0.5f + f1, 0.6f, 0.5f + f1);
        }
    }

    @Override
    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.blockActivated(world, i, j, k, entityplayer);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        int l = world.getBlockMetadata(i, j, k);
        int i1 = l & 7;
        int j1 = 8 - (l & 8);
        world.setBlockMetadataWithNotify(i, j, k, i1 + j1);
        world.markBlocksDirty(i, j, k, i, j, k);
        world.playSoundEffect((double)i + 0.5, (double)j + 0.5, (double)k + 0.5, "random.click", 0.3f, j1 <= 0 ? 0.5f : 0.6f);
        world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
        if (i1 == 1) {
            world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
        } else if (i1 == 2) {
            world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
        } else if (i1 == 3) {
            world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
        } else if (i1 == 4) {
            world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
        } else {
            world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
        }
        return true;
    }

    @Override
    public void onBlockRemoval(World world, int i, int j, int k) {
        int l = world.getBlockMetadata(i, j, k);
        if ((l & 8) > 0) {
            world.notifyBlocksOfNeighborChange(i, j, k, this.blockID);
            int i1 = l & 7;
            if (i1 == 1) {
                world.notifyBlocksOfNeighborChange(i - 1, j, k, this.blockID);
            } else if (i1 == 2) {
                world.notifyBlocksOfNeighborChange(i + 1, j, k, this.blockID);
            } else if (i1 == 3) {
                world.notifyBlocksOfNeighborChange(i, j, k - 1, this.blockID);
            } else if (i1 == 4) {
                world.notifyBlocksOfNeighborChange(i, j, k + 1, this.blockID);
            } else {
                world.notifyBlocksOfNeighborChange(i, j - 1, k, this.blockID);
            }
        }
        super.onBlockRemoval(world, i, j, k);
    }

    @Override
    public boolean isPoweringTo(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return (iblockaccess.getBlockMetadata(i, j, k) & 8) > 0;
    }

    @Override
    public boolean isIndirectlyPoweringTo(World world, int i, int j, int k, int l) {
        int i1 = world.getBlockMetadata(i, j, k);
        if ((i1 & 8) == 0) {
            return false;
        }
        int j1 = i1 & 7;
        if (j1 == 5 && l == 1) {
            return true;
        }
        if (j1 == 4 && l == 2) {
            return true;
        }
        if (j1 == 3 && l == 3) {
            return true;
        }
        if (j1 == 2 && l == 4) {
            return true;
        }
        return j1 == 1 && l == 5;
    }

    @Override
    public boolean canProvidePower() {
        return true;
    }
}

