/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.BlockFlower;
import java.util.Random;

public class BlockMushroom
extends BlockFlower {
    public static boolean spreading = true;

    protected BlockMushroom(int i, int j) {
        super(i, j);
        float f = 0.2f;
        this.setBlockBounds(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, f * 2.0f, 0.5f + f);
        this.setTickOnLoad(true);
    }

    @Override
    public void updateTick(World par1World, int par2, int par3, int par4, Random par5Random) {
        if (par5Random.nextInt(25) == 0 && spreading) {
            int k = par2 + par5Random.nextInt(3) - 1;
            int i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
            int k1 = par4 + par5Random.nextInt(3) - 1;
            int l1 = 0;
            while (l1 < 4) {
                if (par1World.isAirBlock(k, i1, k1) && this.canBlockStay(par1World, k, i1, k1)) {
                    par2 = k;
                    par3 = i1;
                    par4 = k1;
                }
                k = par2 + par5Random.nextInt(3) - 1;
                i1 = par3 + par5Random.nextInt(2) - par5Random.nextInt(2);
                k1 = par4 + par5Random.nextInt(3) - 1;
                ++l1;
            }
            if (par1World.isAirBlock(k, i1, k1) && this.canBlockStay(par1World, k, i1, k1)) {
                par1World.setBlockWithNotify(k, i1, k1, this.blockID);
            }
        }
    }

    public boolean canPlaceBlockAt(World par1World, int par2, int par3, int par4) {
        return super.canPlace(par1World, par2, par3, par4) && this.canBlockStay(par1World, par2, par3, par4);
    }

    @Override
    protected boolean canThisPlantGrowOnThisBlockID(int i) {
        return Block.opaqueCubeLookup[i];
    }

    @Override
    public boolean canBlockStay(World world, int i, int j, int k) {
        return world.func_618_j(i, j, k) <= 13 && this.canThisPlantGrowOnThisBlockID(world.getBlockId(i, j - 1, k));
    }
}

