/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.nbt;

import com.mojang.minecraft.nbt.NBTTagByte;
import com.mojang.minecraft.nbt.NBTTagByteArray;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.nbt.NBTTagDouble;
import com.mojang.minecraft.nbt.NBTTagEnd;
import com.mojang.minecraft.nbt.NBTTagFloat;
import com.mojang.minecraft.nbt.NBTTagInt;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.nbt.NBTTagLong;
import com.mojang.minecraft.nbt.NBTTagShort;
import com.mojang.minecraft.nbt.NBTTagString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class NBTBase {
    private String key = null;

    abstract void func_735_a(DataOutput var1) throws IOException;

    abstract void func_736_a(DataInput var1) throws IOException;

    public abstract byte func_733_a();

    public String func_737_b() {
        if (this.key == null) {
            return "";
        }
        return this.key;
    }

    public NBTBase func_732_a(String s) {
        this.key = s;
        return this;
    }

    public static NBTBase func_734_b(DataInput datainput) throws IOException {
        byte byte0 = datainput.readByte();
        if (byte0 == 0) {
            return new NBTTagEnd();
        }
        NBTBase nbtbase = NBTBase.func_739_a(byte0);
        nbtbase.key = datainput.readUTF();
        nbtbase.func_736_a(datainput);
        return nbtbase;
    }

    public static void func_738_a(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.func_733_a());
        if (nbtbase.func_733_a() == 0) {
            return;
        }
        dataoutput.writeUTF(nbtbase.func_737_b());
        nbtbase.func_735_a(dataoutput);
    }

    public static NBTBase func_739_a(byte byte0) {
        switch (byte0) {
            case 0: {
                return new NBTTagEnd();
            }
            case 1: {
                return new NBTTagByte();
            }
            case 2: {
                return new NBTTagShort();
            }
            case 3: {
                return new NBTTagInt();
            }
            case 4: {
                return new NBTTagLong();
            }
            case 5: {
                return new NBTTagFloat();
            }
            case 6: {
                return new NBTTagDouble();
            }
            case 7: {
                return new NBTTagByteArray();
            }
            case 8: {
                return new NBTTagString();
            }
            case 9: {
                return new NBTTagList();
            }
            case 10: {
                return new NBTTagCompound();
            }
        }
        return null;
    }

    public static String func_731_b(byte byte0) {
        switch (byte0) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
        }
        return "UNKNOWN";
    }
}

