/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.sound;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class AmbientLoopHandler {
    World world;
    EntityPlayer player;
    public int leaves;
    public int waterSurface;
    public int exposedOre;
    public int fallingWater;
    public int ambienceWait = 0;
    Random random = new Random();
    int birds = 45;
    int chimes = 60;
    int ocean = 60;
    int waterfall = 5;
    int killCount = 0;
    long timeOfDay = 0L;

    public AmbientLoopHandler(World wrld, EntityPlayer plyr) {
        this.world = wrld;
        this.player = plyr;
    }

    public void killLoops() {
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", 0.001f, 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", 0.001f, 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", 0.001f, 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", 0.001f, 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", 0.001f, 1.0f);
        this.killCount = 1;
    }

    public void update() {
        if (!this.world.isAmbienceEnabled()) {
            return;
        }
        this.timeOfDay = this.world.worldTime;
        if (this.ambienceWait == 1) {
            this.world.playAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", 0.001f, 1.0f);
            this.world.playAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", 0.001f, 1.0f);
            this.world.playAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", 0.001f, 1.0f);
            this.world.playAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", 0.001f, 1.0f);
            this.world.playAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", 0.001f, 1.0f);
        }
        ++this.ambienceWait;
        if (this.killCount > 0) {
            --this.killCount;
            return;
        }
        boolean underWater = false;
        if (this.player.headSpaceMaterial(Material.water)) {
            underWater = true;
        }
        this.leaves = 0;
        this.waterSurface = 0;
        this.exposedOre = 0;
        this.fallingWater = 0;
        try {
            int x = -25;
            while (x < 25) {
                int y = -15;
                while (y < 15) {
                    int z = -25;
                    while (z < 25) {
                        int block = this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ);
                        if (block == Block.leaves.blockID) {
                            ++this.leaves;
                        }
                        if (block == Block.waterStill.blockID && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY + 1, z + (int)this.player.posZ) == 0) {
                            ++this.waterSurface;
                        }
                        if (!(block != Block.oreDiamond.blockID && block != Block.oreRedstone.blockID && block != Block.oreIron.blockID && block != Block.oreGold.blockID && block != Block.oreSeecret.blockID || this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY + 1, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY - 1, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX + 1, y + (int)this.player.posY, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX - 1, y + (int)this.player.posY, z + (int)this.player.posZ) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ + 1) != 0 && this.world.getBlockId(x + (int)this.player.posX, y + (int)this.player.posY, z + (int)this.player.posZ) != -1)) {
                            ++this.exposedOre;
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.birds screaming loop", (float)this.leaves / 5000.0f * (1.001f - (float)underWater) * ((float)(24000L - this.timeOfDay % 24000L) / 14000.0f - 0.7f), 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cricketsloop", (float)this.leaves / 5000.0f * (1.001f - (float)underWater) * ((float)(this.timeOfDay % 24000L) / 14000.0f), 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.ocean", (float)(this.waterSurface - 200) / 1000.0f * (1.001f - (float)underWater), 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.underwater", (float)this.waterSurface / 1000.0f * ((float)underWater + 0.001f), 1.0f);
        this.world.updateAmbience(this.player.posX, this.player.posY, this.player.posZ, "loops.cave chimes", (float)(this.exposedOre - 20) / 50.0f, 1.0f);
    }
}

