/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityFX;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.BlockFluids;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.util.MathHelper;

public class EntityRainFX
extends EntityFX {
    public EntityRainFX(World world, double d, double d1, double d2) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.motionX *= (double)0.3f;
        this.motionY = (float)Math.random() * 0.2f + 0.1f;
        this.motionZ *= (double)0.3f;
        this.particleRed = 1.0f;
        this.particleGreen = 1.0f;
        this.particleBlue = 1.0f;
        this.particleTextureIndex = 19 + this.rand.nextInt(4);
        this.setSize(0.01f, 0.01f);
        this.field_664_h = 0.06f;
        this.particleMaxAge = (int)(8.0 / (Math.random() * 0.8 + 0.2));
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }

    public void onUpdate() {
        double d;
        Material material;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.motionY -= (double)this.field_664_h;
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.particleMaxAge-- <= 0) {
            this.setEntityDead();
        }
        if (this.onGround) {
            if (Math.random() < 0.5) {
                this.setEntityDead();
            }
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
        }
        if (((material = this.worldObj.getMaterialXYZ(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ))).getIsGroundCover() || material.isSolidMaterial()) && this.posY < (d = (double)((float)(MathHelper.floor_double(this.posY) + 1) - BlockFluids.getFluidLevel(this.worldObj.getBlockMetadata(MathHelper.floor_double(this.posX), MathHelper.floor_double(this.posY), MathHelper.floor_double(this.posZ)))))) {
            this.setEntityDead();
        }
    }
}

