/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.spawn;

import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.gui.IProgressUpdate;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.chunk.ChunkCoordIntPair;
import com.mojang.minecraft.level.chunk.ChunkPosition;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.util.MathHelper;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpawnerAnimals {
    private int maxSpawns;
    private Class<?> spawnBaseClass;
    private Class<?>[] spawnSubclasses;
    private Set<ChunkCoordIntPair> nearbyChunkSet = new HashSet<ChunkCoordIntPair>();

    public SpawnerAnimals(int i, Class<?> class1, Class<?>[] aclass) {
        this.maxSpawns = i;
        this.spawnBaseClass = class1;
        this.spawnSubclasses = aclass;
    }

    public void func_1150_a(World world) {
        int i = world.func_621_b(this.spawnBaseClass);
        if (i < this.maxSpawns) {
            int j = 0;
            while (j < 3) {
                this.func_1149_a(world, 1, null);
                ++j;
            }
        }
    }

    protected ChunkPosition func_1151_a(World world, int i, int j) {
        int k = i + world.rand.nextInt(16);
        int l = world.rand.nextInt(128);
        int i1 = j + world.rand.nextInt(16);
        return new ChunkPosition(k, l, i1);
    }

    private int func_1149_a(World world, int i, IProgressUpdate iprogressupdate) {
        this.nearbyChunkSet.clear();
        int j = 0;
        while (j < world.playerEntities.size()) {
            EntityPlayer entityplayer = world.playerEntities.get(j);
            int l = MathHelper.floor_double(entityplayer.posX / 16.0);
            int i1 = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int byte0 = 4;
            int k1 = -byte0;
            while (k1 <= byte0) {
                int i2 = -byte0;
                while (i2 <= byte0) {
                    this.nearbyChunkSet.add(new ChunkCoordIntPair(k1 + l, i2 + i1));
                    ++i2;
                }
                ++k1;
            }
            ++j;
        }
        int k = 0;
        for (ChunkCoordIntPair chunkcoordintpair : this.nearbyChunkSet) {
            if (world.rand.nextInt(10) != 0) continue;
            int j1 = world.rand.nextInt(this.spawnSubclasses.length);
            ChunkPosition chunkposition = this.func_1151_a(world, chunkcoordintpair.field_189_a * 16, chunkcoordintpair.field_188_b * 16);
            int l1 = chunkposition.x;
            int j2 = chunkposition.y;
            int k2 = chunkposition.z;
            if (world.isBlockNormalCube(l1, j2, k2)) {
                return 0;
            }
            if (world.getMaterialXYZ(l1, j2, k2) != Material.air) {
                return 0;
            }
            int l2 = 0;
            while (l2 < 3) {
                int i3 = l1;
                int j3 = j2;
                int k3 = k2;
                int byte1 = 6;
                int l3 = 0;
                while (l3 < 2) {
                    float f5;
                    float f4;
                    float f3;
                    float f6;
                    float f2;
                    float f1;
                    float f;
                    if (!(!world.isBlockNormalCube(i3 += world.rand.nextInt(byte1) - world.rand.nextInt(byte1), (j3 += world.rand.nextInt(1) - world.rand.nextInt(1)) - 1, k3 += world.rand.nextInt(byte1) - world.rand.nextInt(byte1)) || world.isBlockNormalCube(i3, j3, k3) || world.getMaterialXYZ(i3, j3, k3).getIsGroundCover() || world.isBlockNormalCube(i3, j3 + 1, k3) || world.getPlayerEntity(f = (float)i3 + 0.5f, f1 = (float)j3, f2 = (float)k3 + 0.5f, 24.0) != null || (f6 = (f3 = f - (float)world.spawnX) * f3 + (f4 = f1 - (float)world.spawnY) * f4 + (f5 = f2 - (float)world.spawnZ) * f5) < 576.0f)) {
                        EntityLiving entityliving;
                        try {
                            entityliving = (EntityLiving)this.spawnSubclasses[j1].getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            return k;
                        }
                        entityliving.setLocationAndAngles(f, f1, f2, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (entityliving.func_433_a()) {
                            ++k;
                            world.entityJoinedWorld(entityliving);
                            if (entityliving instanceof EntitySpider && world.rand.nextInt(100) == 0) {
                                EntitySkeleton entityskeleton = new EntitySkeleton(world);
                                entityskeleton.setLocationAndAngles(f, f1, f2, entityliving.rotationYaw, 0.0f);
                                world.entityJoinedWorld(entityskeleton);
                                entityskeleton.mountEntity(entityliving);
                            }
                        }
                    }
                    ++l3;
                }
                ++l2;
            }
        }
        return k;
    }
}

