/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.entity.tile.TileEntitySign;
import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.GuiButton;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.networknew.packet.Packet130UpdateSign;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditSign
extends GuiScreen {
    protected String field_999_a = "Edit sign message:";
    private TileEntitySign entitySign;
    private int updateCounter;
    private int editLine = 0;

    public GuiEditSign(TileEntitySign tileentitysign) {
        this.entitySign = tileentitysign;
    }

    public void initGui() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, "Done"));
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (this.mc.mcWorld.multiplayerWorld) {
            this.mc.getSendQueue().addToSendQueue(new Packet130UpdateSign(this.entitySign.x, this.entitySign.y, this.entitySign.z, this.entitySign.signText));
        }
    }

    public void updateScreen() {
        ++this.updateCounter;
    }

    protected void actionPerformed(GuiButton guibutton) {
        if (!guibutton.enabled) {
            return;
        }
        if (guibutton.id == 0) {
            this.entitySign.onInventoryChanged();
            this.mc.setCurrentScreen(null);
        }
    }

    protected void keyTyped(char c, int i) {
        if (i == 200) {
            this.editLine = this.editLine - 1 & 3;
        }
        if (i == 208 || i == 28) {
            this.editLine = this.editLine + 1 & 3;
        }
        if (i == 14 && this.entitySign.signText[this.editLine].length() > 0) {
            this.entitySign.signText[this.editLine] = this.entitySign.signText[this.editLine].substring(0, this.entitySign.signText[this.editLine].length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.entitySign.signText[this.editLine].length() < 15) {
            int n = this.editLine;
            this.entitySign.signText[n] = String.valueOf(this.entitySign.signText[n]) + c;
        }
    }

    public void drawScreen(int i, int j, float f) {
        try {
            this.drawDefaultBackground();
            this.drawCenteredString(this.fontRenderer, this.field_999_a, this.width / 2, 40, 0xFFFFFF);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.width / 2), (float)(this.height / 2), (float)50.0f);
            float f1 = 93.75f;
            GL11.glScalef((float)(-f1), (float)(-f1), (float)(-f1));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Block block = this.entitySign.func_478_g();
            if (block == Block.signPost) {
                float f2 = (float)(this.entitySign.func_479_f() * 360) / 16.0f;
                GL11.glRotatef((float)f2, (float)0.0f, (float)1.0f, (float)0.0f);
            } else {
                int k = this.entitySign.func_479_f();
                float f3 = 0.0f;
                if (k == 2) {
                    f3 = 180.0f;
                }
                if (k == 4) {
                    f3 = 90.0f;
                }
                if (k == 5) {
                    f3 = -90.0f;
                }
                GL11.glRotatef((float)f3, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.3125f, (float)0.0f);
            }
            if (this.updateCounter / 6 % 2 == 0) {
                this.entitySign.lineBeingEdited = this.editLine;
            }
            TileEntityRenderer.instance.renderTileEntityAt(this.entitySign, -0.5, -0.75, -0.5, 0.0f);
            this.entitySign.lineBeingEdited = -1;
            GL11.glPopMatrix();
            super.drawScreen(i, j, f);
        }
        catch (NullPointerException ex) {
            this.mc.setCurrentScreen(null);
        }
    }
}

