/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.nbt;

import com.mojang.minecraft.nbt.NBTBase;
import com.mojang.minecraft.nbt.NBTTagByte;
import com.mojang.minecraft.nbt.NBTTagByteArray;
import com.mojang.minecraft.nbt.NBTTagDouble;
import com.mojang.minecraft.nbt.NBTTagFloat;
import com.mojang.minecraft.nbt.NBTTagInt;
import com.mojang.minecraft.nbt.NBTTagList;
import com.mojang.minecraft.nbt.NBTTagLong;
import com.mojang.minecraft.nbt.NBTTagShort;
import com.mojang.minecraft.nbt.NBTTagString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class NBTTagCompound
extends NBTBase {
    private Map<String, NBTBase> tagMap = new HashMap<String, NBTBase>();

    void func_735_a(DataOutput dataoutput) throws IOException {
        for (NBTBase nbtbase : this.tagMap.values()) {
            NBTBase.func_738_a(nbtbase, dataoutput);
        }
        dataoutput.writeByte(0);
    }

    void func_736_a(DataInput datainput) throws IOException {
        NBTBase nbtbase;
        this.tagMap.clear();
        while ((nbtbase = NBTBase.func_734_b(datainput)).func_733_a() != 0) {
            this.tagMap.put(nbtbase.func_737_b(), nbtbase);
        }
    }

    public byte func_733_a() {
        return 10;
    }

    public void func_762_a(String s, NBTBase nbtbase) {
        this.tagMap.put(s, nbtbase.func_732_a(s));
    }

    public void setByte(String s, byte byte0) {
        this.tagMap.put(s, new NBTTagByte(byte0).func_732_a(s));
    }

    public void setShort(String s, short word0) {
        this.tagMap.put(s, new NBTTagShort(word0).func_732_a(s));
    }

    public void setInteger(String s, int i) {
        this.tagMap.put(s, new NBTTagInt(i).func_732_a(s));
    }

    public void setLong(String s, long l) {
        this.tagMap.put(s, new NBTTagLong(l).func_732_a(s));
    }

    public void setFloat(String s, float f) {
        this.tagMap.put(s, new NBTTagFloat(f).func_732_a(s));
    }

    public void setDouble(String s, double d) {
        this.tagMap.put(s, new NBTTagDouble(d).func_732_a(s));
    }

    public void setString(String s, String s1) {
        this.tagMap.put(s, new NBTTagString(s1).func_732_a(s));
    }

    public void func_747_a(String s, byte[] abyte0) {
        this.tagMap.put(s, new NBTTagByteArray(abyte0).func_732_a(s));
    }

    public void func_763_a(String s, NBTTagCompound nbttagcompound) {
        this.tagMap.put(s, nbttagcompound.func_732_a(s));
    }

    public void setBool(String s, boolean flag) {
        this.setByte(s, (byte)(flag ? 1 : 0));
    }

    public boolean func_751_b(String s) {
        return this.tagMap.containsKey(s);
    }

    public byte getByte(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0;
        }
        return ((NBTTagByte)this.tagMap.get((Object)s)).byteValue;
    }

    public short getShort(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0;
        }
        return ((NBTTagShort)this.tagMap.get((Object)s)).shortValue;
    }

    public int getInteger(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0;
        }
        return ((NBTTagInt)this.tagMap.get((Object)s)).intValue;
    }

    public long func_764_f(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0L;
        }
        return ((NBTTagLong)this.tagMap.get((Object)s)).longValue;
    }

    public float func_752_g(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0.0f;
        }
        return ((NBTTagFloat)this.tagMap.get((Object)s)).floatValue;
    }

    public double func_757_h(String s) {
        if (!this.tagMap.containsKey(s)) {
            return 0.0;
        }
        return ((NBTTagDouble)this.tagMap.get((Object)s)).doubleValue;
    }

    public String func_755_i(String s) {
        if (!this.tagMap.containsKey(s)) {
            return "";
        }
        return ((NBTTagString)this.tagMap.get((Object)s)).stringValue;
    }

    public byte[] func_759_j(String s) {
        if (!this.tagMap.containsKey(s)) {
            return new byte[0];
        }
        return ((NBTTagByteArray)this.tagMap.get((Object)s)).byteArray;
    }

    public NBTTagCompound func_743_k(String s) {
        if (!this.tagMap.containsKey(s)) {
            return new NBTTagCompound();
        }
        return (NBTTagCompound)this.tagMap.get(s);
    }

    public NBTTagList func_753_l(String s) {
        if (!this.tagMap.containsKey(s)) {
            return new NBTTagList();
        }
        return (NBTTagList)this.tagMap.get(s);
    }

    public boolean tag(String s) {
        return this.getByte(s) != 0;
    }

    public String toString() {
        return "" + this.tagMap.size() + " entries";
    }
}

