/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.networknew.packet;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.networknew.NetHandler;
import com.mojang.minecraft.networknew.packet.Packet;
import com.mojang.minecraft.util.MathHelper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Packet21PickupSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte rotation;
    public byte pitch;
    public byte roll;
    public int itemID;
    public int count;
    public int itemDamage;

    public Packet21PickupSpawn() {
    }

    public Packet21PickupSpawn(EntityItem entityitem) {
        this.entityId = entityitem.entityId;
        this.itemID = entityitem.item.itemID;
        this.count = entityitem.item.stackSize;
        this.itemDamage = entityitem.item.itemDamage;
        this.xPosition = MathHelper.floor_double(entityitem.posX * 32.0);
        this.yPosition = MathHelper.floor_double(entityitem.posY * 32.0);
        this.zPosition = MathHelper.floor_double(entityitem.posZ * 32.0);
        this.rotation = (byte)(entityitem.motionX * 128.0);
        this.pitch = (byte)(entityitem.motionY * 128.0);
        this.roll = (byte)(entityitem.motionZ * 128.0);
    }

    public void readPacketData(DataInputStream datainputstream) throws IOException {
        this.entityId = datainputstream.readInt();
        this.itemID = datainputstream.readShort();
        this.count = datainputstream.readByte();
        this.itemDamage = datainputstream.readShort();
        this.xPosition = datainputstream.readInt();
        this.yPosition = datainputstream.readInt();
        this.zPosition = datainputstream.readInt();
        this.rotation = datainputstream.readByte();
        this.pitch = datainputstream.readByte();
        this.roll = datainputstream.readByte();
    }

    public void writePacketData(DataOutputStream dataoutputstream) throws IOException {
        dataoutputstream.writeInt(this.entityId);
        dataoutputstream.writeShort(this.itemID);
        dataoutputstream.writeByte(this.count);
        dataoutputstream.writeShort(this.itemDamage);
        dataoutputstream.writeInt(this.xPosition);
        dataoutputstream.writeInt(this.yPosition);
        dataoutputstream.writeInt(this.zPosition);
        dataoutputstream.writeByte(this.rotation);
        dataoutputstream.writeByte(this.pitch);
        dataoutputstream.writeByte(this.roll);
    }

    public void processPacket(NetHandler nethandler) {
        nethandler.handlePickupSpawn(this);
    }

    public int getPacketSize() {
        return 24;
    }
}

