/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityFX;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.render.Tessellator;

public class EntityPortalFX
extends EntityFX {
    private float field_4083_a;
    private double field_4086_p;
    private double field_4085_q;
    private double field_4084_r;

    public EntityPortalFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        super(world, d, d1, d2, d3, d4, d5);
        this.motionX = d3;
        this.motionY = d4;
        this.motionZ = d5;
        this.field_4086_p = this.posX = d;
        this.field_4085_q = this.posY = d1;
        this.field_4084_r = this.posZ = d2;
        float f = this.rand.nextFloat() * 0.6f + 0.4f;
        this.field_4083_a = this.particleScale = this.rand.nextFloat() * 0.2f + 0.5f;
        this.particleGreen = this.particleBlue = 1.0f * f;
        this.particleRed = this.particleBlue;
        this.particleGreen *= 0.3f;
        this.particleRed *= 0.9f;
        this.particleMaxAge = (int)(Math.random() * 10.0) + 40;
        this.noClip = true;
        this.particleTextureIndex = (int)(Math.random() * 8.0);
    }

    public void renderParticle(Tessellator tessellator, float f, float f1, float f2, float f3, float f4, float f5) {
        float f6 = ((float)this.particleAge + f) / (float)this.particleMaxAge;
        f6 = 1.0f - f6;
        f6 *= f6;
        f6 = 1.0f - f6;
        this.particleScale = this.field_4083_a * f6;
        super.renderParticle(tessellator, f, f1, f2, f3, f4, f5);
    }

    public float getEntityBrightness(float f) {
        float f1 = super.getEntityBrightness(f);
        float f2 = (float)this.particleAge / (float)this.particleMaxAge;
        f2 *= f2;
        f2 *= f2;
        return f1 * (1.0f - f2) + f2;
    }

    public void onUpdate() {
        float f;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        float f1 = f = (float)this.particleAge / (float)this.particleMaxAge;
        f = -f + f * f * 2.0f;
        f = 1.0f - f;
        this.posX = this.field_4086_p + this.motionX * (double)f;
        this.posY = this.field_4085_q + this.motionY * (double)f + (double)(1.0f - f1);
        this.posZ = this.field_4084_r + this.motionZ * (double)f;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.setEntityDead();
        }
    }
}

