/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity.item;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.nbt.NBTTagCompound;

public final class ItemStack {
    public int stackSize = 0;
    public int animationsToGo;
    public int itemID;
    public int itemDamage;
    public boolean isGold;

    public ItemStack(Block block) {
        this(block, 1);
    }

    public ItemStack(Block block, int i) {
        this(block.blockID, i);
    }

    public ItemStack(Item item) {
        this(item, 1);
        if (item.shiftedIndex == 283 || item.shiftedIndex == 284 || item.shiftedIndex == 285 || item.shiftedIndex == 286) {
            this.isGold = true;
        }
    }

    public ItemStack(Item item, int i) {
        this(item.shiftedIndex, i);
        if (item.shiftedIndex == 283 || item.shiftedIndex == 284 || item.shiftedIndex == 285 || item.shiftedIndex == 286) {
            this.isGold = true;
        }
    }

    public ItemStack(int i) {
        this(i, 1);
        if (i == 283 || i == 284 || i == 285 || i == 286) {
            this.isGold = true;
        }
    }

    public ItemStack(int i, int j) {
        this.itemID = i;
        this.stackSize = j;
        if (i == 283 || i == 284 || i == 285 || i == 286) {
            this.isGold = true;
        }
    }

    public ItemStack(int i, int j, int k) {
        this.itemID = i;
        this.stackSize = j;
        this.itemDamage = k;
        if (i == 283 || i == 284 || i == 285 || i == 286) {
            this.isGold = true;
        }
    }

    public ItemStack(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public ItemStack(Block block, int i, int j) {
        this(block.blockID, i, j);
    }

    public ItemStack splitStack(int i) {
        this.stackSize -= i;
        return new ItemStack(this.itemID, i, this.itemDamage);
    }

    public Item getItem() {
        return Item.itemsList[this.itemID];
    }

    public boolean getHasSubtypes() {
        return false;
    }

    public int getIconIndex() {
        return this.getItem().getIconIndex(this);
    }

    public boolean useItem(EntityPlayer entityplayer, World world, int i, int j, int k, int l) {
        return this.getItem().onItemUse(this, entityplayer, world, i, j, k, l);
    }

    public float getStrVsBlock(Block block) {
        return this.getItem().getStrVsBlock(this, block);
    }

    public ItemStack useItemRightClick(World world, EntityPlayer entityplayer) {
        return this.getItem().onItemRightClick(this, world, entityplayer);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("id", (short)this.itemID);
        nbttagcompound.setByte("Count", (byte)this.stackSize);
        nbttagcompound.setShort("Damage", (short)this.itemDamage);
        return nbttagcompound;
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.itemID = nbttagcompound.getShort("id");
        this.stackSize = nbttagcompound.getByte("Count");
        this.itemDamage = nbttagcompound.getShort("Damage");
        if (this.itemID == 283 || this.itemID == 284 || this.itemID == 285 || this.itemID == 286) {
            this.isGold = true;
        }
    }

    public int getMaxStackSize() {
        return this.getItem().func_200_b();
    }

    public boolean isStackable() {
        return this.getMaxStackSize() > 1 && (!this.isItemStackDamageable() || !this.isItemDamaged());
    }

    public boolean isItemStackDamageable() {
        return Item.itemsList[this.itemID].maxDamage > 0;
    }

    public boolean isItemDamaged() {
        return this.isItemStackDamageable() && this.itemDamage > 0;
    }

    public int getItemDamage() {
        return this.itemDamage;
    }

    public void setItemDamage(int i) {
        this.itemDamage = i;
    }

    public int getMaxDmg() {
        return Item.itemsList[this.itemID].getMaxDmg();
    }

    public void damageItem(int i) {
        this.itemDamage += i;
        if (this.itemDamage > this.getMaxDmg()) {
            --this.stackSize;
            if (this.stackSize < 0) {
                this.stackSize = 0;
            }
            this.itemDamage = 0;
        }
    }

    public void hitEntity(EntityLiving entityliving) {
        Item.itemsList[this.itemID].damageItemHit(this, entityliving);
    }

    public void onDestroyBlock(int i, int j, int k, int l) {
        Item.itemsList[this.itemID].damageItemMine(this, i, j, k, l);
    }

    public int getDamageVsEntity(Entity entity) {
        return Item.itemsList[this.itemID].getDamageVsEntity(entity);
    }

    public boolean canHarvestBlock(Block block) {
        return Item.itemsList[this.itemID].breaking(block);
    }

    public void func_1097_a(EntityPlayer entityplayer) {
    }

    public void useItemOnEntity(EntityLiving entityliving) {
        Item.itemsList[this.itemID].saddleEntity(this, entityliving);
    }

    public ItemStack copy() {
        return new ItemStack(this.itemID, this.stackSize, this.itemDamage);
    }

    public static boolean areItemStacksEqual(ItemStack itemstack, ItemStack itemstack1) {
        if (itemstack == null && itemstack1 == null) {
            return true;
        }
        if (itemstack == null || itemstack1 == null) {
            return false;
        }
        return itemstack.isItemStackEqual(itemstack1);
    }

    private boolean isItemStackEqual(ItemStack itemstack) {
        if (this.stackSize != itemstack.stackSize) {
            return false;
        }
        if (this.itemID != itemstack.itemID) {
            return false;
        }
        return this.itemDamage == itemstack.itemDamage;
    }

    public boolean isItemEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.itemDamage == itemstack.itemDamage;
    }

    public String getItemName() {
        return Item.itemsList[this.itemID].toString();
    }

    public static ItemStack copyItemStack(ItemStack itemstack) {
        return itemstack != null ? itemstack.copy() : null;
    }

    public String toString() {
        return Item.itemsList[this.itemID].toString();
    }

    public boolean isStackEqual(ItemStack itemstack) {
        return this.itemID == itemstack.itemID && this.stackSize == itemstack.stackSize && this.itemDamage == itemstack.itemDamage;
    }

    public boolean isGold() {
        return this.isGold;
    }
}

