/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldBlockPositionType;
import com.mojang.minecraft.level.chunk.ChunkProviderClient;
import com.mojang.minecraft.level.generate.IChunkProvider;
import com.mojang.minecraft.networknew.NetClientHandler;
import com.mojang.minecraft.networknew.packet.Packet255KickDisconnect;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.util.MCHashTable;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class WorldClient
extends World {
    private LinkedList<WorldBlockPositionType> field_1057_z = new LinkedList();
    private NetClientHandler sendQueue;
    private ChunkProviderClient field_1058_B;
    private boolean field_1056_C = false;
    private MCHashTable field_1055_D = new MCHashTable();
    private Set<Entity> field_1054_E = new HashSet<Entity>();
    private Set<Entity> field_1053_F = new HashSet<Entity>();

    public WorldClient(NetClientHandler netclienthandler) {
        super("MpServer");
        this.sendQueue = netclienthandler;
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
    }

    public void tick() {
        ++this.worldTime;
        int i = this.func_671_a(1.0f);
        if (i != this.skyLightSubtracted) {
            this.skyLightSubtracted = i;
            int j = 0;
            while (j < this.worldAccesses.size()) {
                ((IWorldAccess)this.worldAccesses.get(j)).updateAllRenderers();
                ++j;
            }
        }
        int k = 0;
        while (k < 10 && !this.field_1053_F.isEmpty()) {
            Entity entity = this.field_1053_F.iterator().next();
            this.entityJoinedWorld(entity);
            ++k;
        }
        this.sendQueue.processReadPackets();
        int l = 0;
        while (l < this.field_1057_z.size()) {
            WorldBlockPositionType worldblockpositiontype = this.field_1057_z.get(l);
            if (--worldblockpositiontype.field_1206_d == 0) {
                super.setBlockAndMetadata(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c, worldblockpositiontype.field_1205_e, worldblockpositiontype.field_1204_f);
                super.markBlockNeedsUpdate(worldblockpositiontype.field_1202_a, worldblockpositiontype.field_1201_b, worldblockpositiontype.field_1207_c);
                this.field_1057_z.remove(l--);
            }
            ++l;
        }
    }

    public void func_711_c(int i, int j, int k, int l, int i1, int j1) {
        int k1 = 0;
        while (k1 < this.field_1057_z.size()) {
            WorldBlockPositionType worldblockpositiontype = this.field_1057_z.get(k1);
            if (worldblockpositiontype.field_1202_a >= i && worldblockpositiontype.field_1201_b >= j && worldblockpositiontype.field_1207_c >= k && worldblockpositiontype.field_1202_a <= l && worldblockpositiontype.field_1201_b <= i1 && worldblockpositiontype.field_1207_c <= j1) {
                this.field_1057_z.remove(k1--);
            }
            ++k1;
        }
    }

    protected IChunkProvider getWorldChunkProvider(File file) {
        this.field_1058_B = new ChunkProviderClient(this);
        return this.field_1058_B;
    }

    public void func_622_a() {
        this.spawnX = 8;
        this.spawnY = 64;
        this.spawnZ = 8;
    }

    protected void func_652_h() {
    }

    public void scheduleUpdateTick(int i, int j, int k, int l) {
    }

    public boolean tickUpdates(boolean flag) {
        return false;
    }

    public void doPreChunk(int i, int j, boolean flag) {
        if (flag) {
            this.field_1058_B.prepareChunk(i, j);
        } else {
            this.field_1058_B.func_539_c(i, j);
        }
        if (!flag) {
            this.markBlocksDirty(i * 16, 0, j * 16, i * 16 + 15, 128, j * 16 + 15);
        }
    }

    public boolean entityJoinedWorld(Entity entity) {
        boolean flag = super.entityJoinedWorld(entity);
        if (entity instanceof EntityPlayerSP) {
            this.field_1054_E.add(entity);
        }
        return flag;
    }

    public void setEntityDead(Entity entity) {
        super.setEntityDead(entity);
        if (entity instanceof EntityPlayerSP) {
            this.field_1054_E.remove(entity);
        }
    }

    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        if (this.field_1053_F.contains(entity)) {
            this.field_1053_F.remove(entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        if (this.field_1054_E.contains(entity)) {
            this.field_1053_F.add(entity);
        }
    }

    public void func_712_a(int i, Entity entity) {
        Entity entity1 = this.func_709_b(i);
        if (entity1 != null) {
            this.setEntityDead(entity1);
        }
        this.field_1054_E.add(entity);
        entity.entityId = i;
        if (!this.entityJoinedWorld(entity)) {
            this.field_1053_F.add(entity);
        }
        this.field_1055_D.addKey(i, entity);
    }

    public Entity func_709_b(int i) {
        return (Entity)this.field_1055_D.func_1057_a(i);
    }

    public Entity removeEntityFromWorld(int i) {
        Entity entity = (Entity)this.field_1055_D.func_1052_b(i);
        if (entity != null) {
            this.field_1054_E.remove(entity);
            this.setEntityDead(entity);
        }
        return entity;
    }

    public boolean setBlockMetadata(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockMetadata(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadata(int i, int j, int k, int l, int i1) {
        int j1 = this.getBlockId(i, j, k);
        int k1 = this.getBlockMetadata(i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, j1, k1));
            return true;
        }
        return false;
    }

    public boolean setBlock(int i, int j, int k, int l) {
        int i1 = this.getBlockId(i, j, k);
        int j1 = this.getBlockMetadata(i, j, k);
        if (super.setBlock(i, j, k, l)) {
            this.field_1057_z.add(new WorldBlockPositionType(this, i, j, k, i1, j1));
            return true;
        }
        return false;
    }

    public boolean func_714_c(int i, int j, int k, int l, int i1) {
        this.func_711_c(i, j, k, i, j, k);
        if (super.setBlockAndMetadata(i, j, k, l, i1)) {
            this.notifyBlockChange(i, j, k, l);
            return true;
        }
        return false;
    }

    public void cacheTileEntity(int i, int j, int k, TileEntity tileentity) {
        if (this.field_1056_C) {
            return;
        }
    }

    public void sendQuittingDisconnectingPacket() {
        this.sendQueue.addToSendQueue(new Packet255KickDisconnect("Quitting"));
    }
}

