/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;
import java.util.ArrayList;
import java.util.Random;

public class BlockStairs
extends Block {
    private Block modelBlock;

    protected BlockStairs(int i, Block block) {
        super(i, block.blockIndexInTexture, block.blockMaterial);
        this.modelBlock = block;
        this.setHardness(block.blockHardness);
        this.setResistance(block.blockResistance / 3.0f);
        this.setStepSound(block.stepSound);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return super.getCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public int getRenderType() {
        return 10;
    }

    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist) {
        int l = world.getBlockMetadata(i, j, k);
        if (l == 0) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 1) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.5f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 2) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 0.5f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        } else if (l == 3) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
            this.setBlockBounds(0.0f, 0.0f, 0.5f, 1.0f, 0.5f, 1.0f);
            super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
        }
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.randomDisplayTick(world, i, j, k, random);
    }

    public void onBlockClicked(World world, int i, int j, int k, EntityPlayer entityplayer) {
        this.modelBlock.onBlockClicked(world, i, j, k, entityplayer);
    }

    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.modelBlock.getBlockBrightness(iblockaccess, i, j, k);
    }

    public float getExplosionResistance(Entity entity) {
        return this.modelBlock.getExplosionResistance(entity);
    }

    public int getRenderBlockPass() {
        return this.modelBlock.getRenderBlockPass();
    }

    public int idDropped(int i, Random random) {
        return this.blockID;
    }

    public int quantityDropped(Random random) {
        return 1;
    }

    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        return this.modelBlock.getBlockTextureFromSideAndMetadata(i, j);
    }

    public int getTextureIndex(int i) {
        return this.modelBlock.getTextureIndex(i);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        return this.modelBlock.getTextureIndex(iblockaccess, i, j, k, l);
    }

    public int tickRate() {
        return this.modelBlock.tickRate();
    }

    public AxisAlignedBB getSelectedCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return this.modelBlock.getSelectedCollisionBoundingBoxFromPool(world, i, j, k);
    }

    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        this.modelBlock.velocityToAddToEntity(world, i, j, k, entity, vec3d);
    }

    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    public boolean canCollideCheck(int i, boolean flag) {
        return this.modelBlock.canCollideCheck(i, flag);
    }

    public boolean canPlace(World world, int i, int j, int k) {
        return this.modelBlock.canPlace(world, i, j, k);
    }

    public void onBlockAdded(World world, int i, int j, int k) {
        this.onNeighborBlockChange(world, i, j, k, 0);
        this.modelBlock.onBlockAdded(world, i, j, k);
    }

    public void onBlockRemoval(World world, int i, int j, int k) {
        this.modelBlock.onBlockRemoval(world, i, j, k);
    }

    public void onEntityWalking(World world, int i, int j, int k, Entity entity) {
        this.modelBlock.onEntityWalking(world, i, j, k, entity);
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        this.modelBlock.updateTick(world, i, j, k, random);
    }

    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        return this.modelBlock.blockActivated(world, i, j, k, entityplayer);
    }

    public void onBlockDestroyedByExplosion(World world, int i, int j, int k) {
    }

    public void onBlockPlacedBy(World world, int i, int j, int k, EntityLiving entityliving) {
        int l = MathHelper.floor_double((double)(entityliving.rotationYaw * 4.0f / 360.0f) + 0.5) & 3;
        if (l == 0) {
            world.setBlockMetadataWithNotify(i, j, k, 2);
        }
        if (l == 1) {
            world.setBlockMetadataWithNotify(i, j, k, 1);
        }
        if (l == 2) {
            world.setBlockMetadataWithNotify(i, j, k, 3);
        }
        if (l == 3) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
        }
    }
}

