/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.render;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityBubbleFX;
import com.mojang.minecraft.entity.EntityExplodeFX;
import com.mojang.minecraft.entity.EntityFlameFX;
import com.mojang.minecraft.entity.EntityLavaFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.EntityReddustFX;
import com.mojang.minecraft.entity.EntitySlimeFX;
import com.mojang.minecraft.entity.EntitySmokeFX;
import com.mojang.minecraft.entity.EntitySorter;
import com.mojang.minecraft.entity.EntitySplashFX;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemRecord;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.entity.tile.TileEntityRenderer;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.GLAllocation;
import com.mojang.minecraft.render.ICamera;
import com.mojang.minecraft.render.IWorldAccess;
import com.mojang.minecraft.render.ImageBufferDownload;
import com.mojang.minecraft.render.RenderBlocks;
import com.mojang.minecraft.render.RenderEngine;
import com.mojang.minecraft.render.RenderList;
import com.mojang.minecraft.render.RenderManager;
import com.mojang.minecraft.render.RenderSorter;
import com.mojang.minecraft.render.Tessellator;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.render.WorldRenderer;
import com.mojang.minecraft.util.MathHelper;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;

public class RenderGlobal
implements IWorldAccess {
    public List<TileEntity> tileEntities;
    private World worldObj;
    private RenderEngine renderEngine;
    private List<WorldRenderer> worldRenderersToUpdate;
    private WorldRenderer[] sortedWorldRenderers;
    private WorldRenderer[] worldRenderers;
    private int d;
    private int field_1443_p;
    private int field_1442_q;
    private int field_1441_r;
    private int field_1440_s;
    private Minecraft mc;
    private RenderBlocks globalRenderBlocks;
    private IntBuffer glOcclusionQueryBase;
    private boolean occlusionEnabled = false;
    private int cloudOffsetX = 0;
    private int starGLCallList;
    private int glSkyList;
    private int glSkyList2;
    private int minBlockX;
    private int minBlockY;
    private int minBlockZ;
    private int maxBlockX;
    private int maxBlockY;
    private int maxBlockZ;
    private int renderDistance = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    int[] dummyBuf50k = null;
    IntBuffer occlusionResult;
    private int renderersLoaded;
    private int renderersBeingClipped;
    private int renderersBeingOccluded;
    private int renderersBeingRendered;
    private int renderersSkippingRenderPass;
    private List<WorldRenderer> glRenderLists;
    private RenderList[] allRenderLists = new RenderList[]{new RenderList(), new RenderList(), new RenderList(), new RenderList()};
    int boop = 0;
    int glDummyList;
    double prevSortX = -9999.0;
    double prevSortY = -9999.0;
    double prevSortZ = -9999.0;
    public float damagePartialTime;
    int frustrumCheckOffset = 0;
    FloatBuffer floatBuffer;
    boolean texClouds = true;
    float cloudHeight = 108.0f;

    public RenderGlobal(Minecraft minecraft, RenderEngine renderengine) {
        this.d = GL11.glGenLists((int)2);
        this.tileEntities = new ArrayList<TileEntity>();
        this.worldRenderersToUpdate = new ArrayList<WorldRenderer>();
        this.occlusionResult = GLAllocation.createDirectIntBuffer(64);
        this.glRenderLists = new ArrayList<WorldRenderer>();
        this.glDummyList = GLAllocation.func_1124_a(1);
        this.mc = minecraft;
        this.renderEngine = renderengine;
        this.floatBuffer = BufferUtils.createFloatBuffer((int)16);
        int byte0 = 64;
        this.field_1440_s = GLAllocation.func_1124_a(byte0 * byte0 * byte0 * 3);
        this.occlusionEnabled = minecraft.func_137_k().func_1213_a();
        if (this.occlusionEnabled) {
            this.occlusionResult.clear();
            this.glOcclusionQueryBase = GLAllocation.createDirectIntBuffer(byte0 * byte0 * byte0);
            this.glOcclusionQueryBase.clear();
            this.glOcclusionQueryBase.position(0);
            this.glOcclusionQueryBase.limit(byte0 * byte0 * byte0);
            ARBOcclusionQuery.glGenQueriesARB((IntBuffer)this.glOcclusionQueryBase);
        }
        this.starGLCallList = GLAllocation.func_1124_a(3);
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.func_950_f();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.instance;
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte1 = 64;
        int i = 256 / byte1 + 2;
        float f = 16.0f;
        int j = -byte1 * i;
        while (j <= byte1 * i) {
            int l = -byte1 * i;
            while (l <= byte1 * i) {
                tessellator.startDrawingQuads();
                tessellator.addVertex(j + 0, f, l + 0);
                tessellator.addVertex(j + byte1, f, l + 0);
                tessellator.addVertex(j + byte1, f, l + byte1);
                tessellator.addVertex(j + 0, f, l + byte1);
                tessellator.draw();
                l += byte1;
            }
            j += byte1;
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        tessellator.startDrawingQuads();
        int k = -byte1 * i;
        while (k <= byte1 * i) {
            int i1 = -byte1 * i;
            while (i1 <= byte1 * i) {
                tessellator.addVertex(k + byte1, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + 0);
                tessellator.addVertex(k + 0, f, i1 + byte1);
                tessellator.addVertex(k + byte1, f, i1 + byte1);
                i1 += byte1;
            }
            k += byte1;
        }
        tessellator.draw();
        GL11.glEndList();
    }

    private void func_950_f() {
        Random random = new Random(10842L);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        int i = 0;
        while (i < 1500) {
            double d = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.25f + random.nextFloat() * 0.25f;
            double d4 = d * d + d1 * d1 + d2 * d2;
            if (!(d4 >= 1.0) && !(d4 <= 0.01)) {
                d4 = 1.0 / Math.sqrt(d4);
                double d5 = (d *= d4) * 100.0;
                double d6 = (d1 *= d4) * 100.0;
                double d7 = (d2 *= d4) * 100.0;
                double d8 = Math.atan2(d, d2);
                double d9 = Math.sin(d8);
                double d10 = Math.cos(d8);
                double d11 = Math.atan2(Math.sqrt(d * d + d2 * d2), d1);
                double d12 = Math.sin(d11);
                double d13 = Math.cos(d11);
                double d14 = random.nextDouble() * Math.PI * 2.0;
                double d15 = Math.sin(d14);
                double d16 = Math.cos(d14);
                int j = 0;
                while (j < 4) {
                    double d22;
                    double d17 = 0.0;
                    double d18 = (double)((j & 2) - 1) * d3;
                    double d19 = (double)((j + 1 & 2) - 1) * d3;
                    double d20 = d17;
                    double d21 = d18 * d16 - d19 * d15;
                    double d23 = d22 = d19 * d16 + d18 * d15;
                    double d24 = d21 * d12 + d20 * d13;
                    double d25 = d20 * d12 - d21 * d13;
                    double d26 = d25 * d9 - d23 * d10;
                    double d27 = d24;
                    double d28 = d23 * d9 + d25 * d10;
                    tessellator.addVertex(d5 + d26, d6 + d27, d7 + d28);
                    ++j;
                }
            }
            ++i;
        }
        tessellator.draw();
    }

    public void func_946_a(World world) {
        this.cloudHeight = world.cloudHeight;
        if (this.worldObj != null) {
            this.worldObj.func_672_b(this);
        }
        this.prevSortX = -9999.0;
        this.prevSortY = -9999.0;
        this.prevSortZ = -9999.0;
        RenderManager.subManager.func_852_a(world);
        this.worldObj = world;
        this.globalRenderBlocks = new RenderBlocks(world);
        if (world != null) {
            world.func_613_a(this);
            this.func_958_a();
        }
    }

    public void func_958_a() {
        int j;
        Block.leaves.func_310_a(this.mc.options.fancyGraphics);
        this.renderDistance = this.mc.options.renderDistance;
        if (this.worldRenderers != null) {
            int i = 0;
            while (i < this.worldRenderers.length) {
                this.worldRenderers[i].func_1204_c();
                ++i;
            }
        }
        if ((j = 64 << 3 - this.renderDistance) > 400) {
            j = 400;
        }
        this.field_1443_p = j / 16 + 1;
        this.field_1442_q = 8;
        this.field_1441_r = j / 16 + 1;
        this.worldRenderers = new WorldRenderer[this.field_1443_p * this.field_1442_q * this.field_1441_r];
        this.sortedWorldRenderers = new WorldRenderer[this.field_1443_p * this.field_1442_q * this.field_1441_r];
        int k = 0;
        int l = 0;
        this.minBlockX = 0;
        this.minBlockY = 0;
        this.minBlockZ = 0;
        this.maxBlockX = this.field_1443_p;
        this.maxBlockY = this.field_1442_q;
        this.maxBlockZ = this.field_1441_r;
        int i1 = 0;
        while (i1 < this.worldRenderersToUpdate.size()) {
            this.worldRenderersToUpdate.get((int)i1).needsUpdate = false;
            ++i1;
        }
        this.worldRenderersToUpdate.clear();
        this.tileEntities.clear();
        int j1 = 0;
        while (j1 < this.field_1443_p) {
            int k1 = 0;
            while (k1 < this.field_1442_q) {
                int l1 = 0;
                while (l1 < this.field_1441_r) {
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1] = new WorldRenderer(this.worldObj, this.tileEntities, j1 * 16, k1 * 16, l1 * 16, 16, this.field_1440_s + k);
                    if (this.occlusionEnabled) {
                        this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].field_1732_z = this.glOcclusionQueryBase.get(l);
                    }
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].field_1733_y = false;
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].isAnOccludedChunk = true;
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].isInFrustrum = true;
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].chunkIndex = l++;
                    this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1].func_1194_f();
                    this.sortedWorldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1] = this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1];
                    this.worldRenderersToUpdate.add(this.worldRenderers[(l1 * this.field_1442_q + k1) * this.field_1443_p + j1]);
                    k += 3;
                    ++l1;
                }
                ++k1;
            }
            ++j1;
        }
        if (this.worldObj != null) {
            EntityPlayerSP entityplayersp = this.mc.thePlayer;
            this.func_956_b(MathHelper.floor_double(entityplayersp.posX), MathHelper.floor_double(entityplayersp.posY), MathHelper.floor_double(entityplayersp.posZ));
            Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityplayersp));
        }
        this.renderEntitiesStartupCounter = 2;
    }

    public void handleTileEntityRendering(Vec3D vec3d, ICamera icamera, float f) {
        Entity entity;
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
            return;
        }
        TileEntityRenderer.instance.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRender, this.mc.thePlayer, f);
        RenderManager.subManager.cacheActiveRenderInfo(this.worldObj, this.renderEngine, this.mc.fontRender, this.mc.thePlayer, this.mc.options, f);
        this.countEntitiesTotal = 0;
        this.countEntitiesRendered = 0;
        this.countEntitiesHidden = 0;
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        RenderManager.renderPosX = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
        RenderManager.renderPosY = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
        RenderManager.renderPosZ = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
        TileEntityRenderer.field_1553_b = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * (double)f;
        TileEntityRenderer.field_1552_c = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * (double)f;
        TileEntityRenderer.field_1551_d = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * (double)f;
        List<Entity> list = this.worldObj.getLoadedEntityList();
        this.countEntitiesTotal = list.size();
        int i = 0;
        while (i < this.worldObj.weatherEffects.size()) {
            entity = this.worldObj.weatherEffects.get(i);
            ++this.countEntitiesRendered;
            if (entity.isInRangeToRenderVec3D(vec3d)) {
                RenderManager.subManager.renderEntity(entity, f);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            entity = list.get(i);
            if (entity.isInRangeToRenderVec3D(vec3d) && icamera.func_342_a(entity.boundingBox) && (entity != this.mc.thePlayer || this.mc.options.thirdPersonView)) {
                ++this.countEntitiesRendered;
                RenderManager.subManager.renderEntity(entity, f);
            }
            ++i;
        }
        int j = 0;
        while (j < this.tileEntities.size()) {
            TileEntityRenderer.instance.renderTileEntity(this.tileEntities.get(j), f);
            ++j;
        }
    }

    public String func_953_b() {
        return "Chunks: " + this.renderersBeingRendered + "/" + this.renderersLoaded + ". Frustrum: " + this.renderersBeingClipped + ", Occluded: " + this.renderersBeingOccluded + ", Entities: " + this.renderersSkippingRenderPass;
    }

    public String func_957_c() {
        return "Entities: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ". Occluded: " + this.countEntitiesHidden + ", Invisible: " + (this.countEntitiesTotal - this.countEntitiesHidden - this.countEntitiesRendered);
    }

    private void func_956_b(int i, int j, int k) {
        i -= 8;
        j -= 8;
        k -= 8;
        this.minBlockX = Integer.MAX_VALUE;
        this.minBlockY = Integer.MAX_VALUE;
        this.minBlockZ = Integer.MAX_VALUE;
        this.maxBlockX = Integer.MIN_VALUE;
        this.maxBlockY = Integer.MIN_VALUE;
        this.maxBlockZ = Integer.MIN_VALUE;
        int l = this.field_1443_p * 16;
        int i1 = l / 2;
        int j1 = 0;
        while (j1 < this.field_1443_p) {
            int k1 = j1 * 16;
            int l1 = k1 + i1 - i;
            if (l1 < 0) {
                l1 -= l - 1;
            }
            if ((k1 -= (l1 /= l) * l) < this.minBlockX) {
                this.minBlockX = k1;
            }
            if (k1 > this.maxBlockX) {
                this.maxBlockX = k1;
            }
            int i2 = 0;
            while (i2 < this.field_1441_r) {
                int j2 = i2 * 16;
                int k2 = j2 + i1 - k;
                if (k2 < 0) {
                    k2 -= l - 1;
                }
                if ((j2 -= (k2 /= l) * l) < this.minBlockZ) {
                    this.minBlockZ = j2;
                }
                if (j2 > this.maxBlockZ) {
                    this.maxBlockZ = j2;
                }
                int l2 = 0;
                while (l2 < this.field_1442_q) {
                    int i3 = l2 * 16;
                    if (i3 < this.minBlockY) {
                        this.minBlockY = i3;
                    }
                    if (i3 > this.maxBlockY) {
                        this.maxBlockY = i3;
                    }
                    WorldRenderer worldrenderer = this.worldRenderers[(i2 * this.field_1442_q + l2) * this.field_1443_p + j1];
                    boolean flag = worldrenderer.needsUpdate;
                    worldrenderer.setPosition(k1, i3, j2);
                    if (!flag && worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    ++l2;
                }
                ++i2;
            }
            ++j1;
        }
    }

    public int func_943_a(EntityPlayer entityplayer, int i, double d) {
        if (this.mc.options.renderDistance != this.renderDistance) {
            this.func_958_a();
        }
        if (i == 0) {
            this.renderersLoaded = 0;
            this.renderersBeingClipped = 0;
            this.renderersBeingOccluded = 0;
            this.renderersBeingRendered = 0;
            this.renderersSkippingRenderPass = 0;
        }
        double d1 = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * d;
        double d2 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * d;
        double d3 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * d;
        double d4 = entityplayer.posX - this.prevSortX;
        double d5 = entityplayer.posY - this.prevSortY;
        double d6 = entityplayer.posZ - this.prevSortZ;
        if (d4 * d4 + d5 * d5 + d6 * d6 > 16.0) {
            this.prevSortX = entityplayer.posX;
            this.prevSortY = entityplayer.posY;
            this.prevSortZ = entityplayer.posZ;
            this.func_956_b(MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ));
            try {
                Arrays.sort(this.sortedWorldRenderers, new EntitySorter(entityplayer));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int j = 0;
        if (this.occlusionEnabled && !this.mc.options.anaglyph && i == 0) {
            int k = 0;
            int l = 16;
            this.checkOcclusionQueryResult(k, l);
            int i1 = k;
            while (i1 < l) {
                this.sortedWorldRenderers[i1].isAnOccludedChunk = true;
                ++i1;
            }
            j += this.func_952_a(k, l, i, d);
            do {
                int byte0 = l;
                if ((l *= 2) > this.sortedWorldRenderers.length) {
                    l = this.sortedWorldRenderers.length;
                }
                GL11.glDisable((int)3553);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3008);
                GL11.glDisable((int)2912);
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GL11.glDepthMask((boolean)false);
                this.checkOcclusionQueryResult(byte0, l);
                GL11.glPushMatrix();
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int j1 = byte0;
                while (j1 < l) {
                    if (this.sortedWorldRenderers[j1].func_1196_e()) {
                        this.sortedWorldRenderers[j1].isInFrustrum = false;
                    } else {
                        float f3;
                        int k1;
                        if (!this.sortedWorldRenderers[j1].isInFrustrum) {
                            this.sortedWorldRenderers[j1].isAnOccludedChunk = true;
                        }
                        if (this.sortedWorldRenderers[j1].isInFrustrum && !this.sortedWorldRenderers[j1].field_1733_y && this.cloudOffsetX % (k1 = (int)(1.0f + (f3 = MathHelper.sqrt_float(this.sortedWorldRenderers[j1].distanceToEntitySquared(entityplayer))) / 128.0f)) == j1 % k1) {
                            WorldRenderer worldrenderer = this.sortedWorldRenderers[j1];
                            float f4 = (float)((double)worldrenderer.field_1755_i - d1);
                            float f5 = (float)((double)worldrenderer.field_1754_j - d2);
                            float f6 = (float)((double)worldrenderer.field_1753_k - d3);
                            float f7 = f4 - f;
                            float f8 = f5 - f1;
                            float f9 = f6 - f2;
                            if (f7 != 0.0f || f8 != 0.0f || f9 != 0.0f) {
                                GL11.glTranslatef((float)f7, (float)f8, (float)f9);
                                f += f7;
                                f1 += f8;
                                f2 += f9;
                            }
                            ARBOcclusionQuery.glBeginQueryARB((int)35092, (int)this.sortedWorldRenderers[j1].field_1732_z);
                            this.sortedWorldRenderers[j1].func_1201_d();
                            ARBOcclusionQuery.glEndQueryARB((int)35092);
                            this.sortedWorldRenderers[j1].field_1733_y = true;
                        }
                    }
                    ++j1;
                }
                GL11.glPopMatrix();
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)2912);
                j += this.func_952_a(byte0, l, i, d);
            } while (l < this.sortedWorldRenderers.length);
        } else {
            j += this.func_952_a(0, this.sortedWorldRenderers.length, i, d);
        }
        return j;
    }

    private void checkOcclusionQueryResult(int i, int j) {
        int k = i;
        while (k < j) {
            if (this.sortedWorldRenderers[k].field_1733_y) {
                this.occlusionResult.clear();
                ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k].field_1732_z, (int)34919, (IntBuffer)this.occlusionResult);
                if (this.occlusionResult.get(0) != 0) {
                    this.sortedWorldRenderers[k].field_1733_y = false;
                    this.occlusionResult.clear();
                    ARBOcclusionQuery.glGetQueryObjectuARB((int)this.sortedWorldRenderers[k].field_1732_z, (int)34918, (IntBuffer)this.occlusionResult);
                    this.sortedWorldRenderers[k].isAnOccludedChunk = this.occlusionResult.get(0) != 0;
                }
            }
            ++k;
        }
    }

    private int func_952_a(int startIndex, int endIndex, int renderPass, double partialTicks) {
        this.glRenderLists.clear();
        int l = 0;
        int i1 = startIndex;
        while (i1 < endIndex) {
            int j1;
            if (renderPass == 0) {
                ++this.renderersLoaded;
                if (this.sortedWorldRenderers[i1].skipRenderPass[renderPass]) {
                    ++this.renderersSkippingRenderPass;
                } else if (!this.sortedWorldRenderers[i1].isInFrustrum) {
                    ++this.renderersBeingClipped;
                } else if (this.occlusionEnabled && !this.sortedWorldRenderers[i1].isAnOccludedChunk) {
                    ++this.renderersBeingOccluded;
                } else {
                    ++this.renderersBeingRendered;
                }
            }
            if ((!this.sortedWorldRenderers[i1].skipRenderPass[renderPass] || this.sortedWorldRenderers[i1].isInFrustrum || this.sortedWorldRenderers[i1].isAnOccludedChunk) && (j1 = this.sortedWorldRenderers[i1].func_1200_a(renderPass)) >= 0) {
                this.glRenderLists.add(this.sortedWorldRenderers[i1]);
                ++l;
            }
            ++i1;
        }
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d1 = entityplayersp.lastTickPosX + (entityplayersp.posX - entityplayersp.lastTickPosX) * partialTicks;
        double d2 = entityplayersp.lastTickPosY + (entityplayersp.posY - entityplayersp.lastTickPosY) * partialTicks;
        double d3 = entityplayersp.lastTickPosZ + (entityplayersp.posZ - entityplayersp.lastTickPosZ) * partialTicks;
        int k1 = 0;
        int l1 = 0;
        while (l1 < this.allRenderLists.length) {
            this.allRenderLists[l1].func_859_b();
            ++l1;
        }
        int i2 = 0;
        while (i2 < this.glRenderLists.size()) {
            WorldRenderer worldrenderer = this.glRenderLists.get(i2);
            int j2 = -1;
            int k2 = 0;
            while (k2 < k1) {
                if (this.allRenderLists[k2].func_862_a(worldrenderer.field_1755_i, worldrenderer.field_1754_j, worldrenderer.field_1753_k)) {
                    j2 = k2;
                }
                ++k2;
            }
            if (j2 < 0) {
                j2 = k1++;
                this.allRenderLists[j2].func_861_a(worldrenderer.field_1755_i, worldrenderer.field_1754_j, worldrenderer.field_1753_k, d1, d2, d3);
            }
            this.allRenderLists[j2].func_858_a(worldrenderer.func_1200_a(renderPass));
            ++i2;
        }
        this.func_944_a(renderPass, partialTicks);
        return l;
    }

    public void func_944_a(int i, double d) {
        int j = 0;
        while (j < this.allRenderLists.length) {
            this.allRenderLists[j].func_860_a();
            ++j;
        }
    }

    public void func_945_d() {
        ++this.cloudOffsetX;
    }

    public final void renderWater() {
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/water.png"));
        float var1 = this.worldObj.getBrightness(0, 0, 0);
        GL11.glColor4f((float)var1, (float)var1, (float)var1, (float)1.0f);
        GL11.glCallList((int)(this.d + 1));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    public void renderSky(float f) {
        GL11.glDisable((int)3553);
        Vec3D vec3d = this.worldObj.func_626_b(f);
        float f1 = (float)vec3d.xCoord;
        float f2 = (float)vec3d.yCoord;
        float f3 = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float f4 = (f1 * 30.0f + f2 * 59.0f + f3 * 11.0f) / 100.0f;
            float f5 = (f1 * 30.0f + f2 * 70.0f) / 100.0f;
            float f7 = (f1 * 30.0f + f3 * 70.0f) / 100.0f;
            f1 = f4;
            f2 = f5;
            f3 = f7;
        }
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        Tessellator tessellator = Tessellator.instance;
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)f1, (float)f2, (float)f3);
        GL11.glCallList((int)this.glSkyList);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glPushMatrix();
        float f6 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)f6, (float)f8, (float)f9);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(this.worldObj.func_619_c(f) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f10 = 30.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/sun.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f10, 100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, -f10, 1.0, 0.0);
        tessellator.addVertexWithUV(f10, 100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(-f10, 100.0, f10, 0.0, 1.0);
        tessellator.draw();
        f10 = 20.0f;
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/terrain/moon.png"));
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV(-f10, -100.0, f10, 1.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, f10, 0.0, 1.0);
        tessellator.addVertexWithUV(f10, -100.0, -f10, 0.0, 0.0);
        tessellator.addVertexWithUV(-f10, -100.0, -f10, 1.0, 0.0);
        tessellator.draw();
        GL11.glDisable((int)3553);
        float f11 = this.worldObj.func_679_f(f);
        if (f11 > 0.0f) {
            GL11.glColor4f((float)f11, (float)f11, (float)f11, (float)f11);
            GL11.glCallList((int)this.starGLCallList);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glColor3f((float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.2f + 0.04f), (float)(f3 * 0.6f + 0.1f));
        GL11.glDisable((int)3553);
        GL11.glCallList((int)this.glSkyList2);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    public void func_947_b(float f) {
        if (this.mc.options.clouds) {
            if (this.mc.options.fancyGraphics) {
                this.renderFancyClouds(f);
                return;
            }
            GL11.glDisable((int)2884);
            float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
            int byte0 = 32;
            int i = 256 / byte0;
            Tessellator tessellator = Tessellator.instance;
            GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds.png"));
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            Vec3D vec3d = this.worldObj.func_628_d(f);
            float f2 = (float)vec3d.xCoord;
            float f3 = (float)vec3d.yCoord;
            float f4 = (float)vec3d.zCoord;
            if (this.mc.options.anaglyph) {
                float f5 = (f2 * 30.0f + f3 * 59.0f + f4 * 11.0f) / 100.0f;
                float f7 = (f2 * 30.0f + f3 * 70.0f) / 100.0f;
                float f8 = (f2 * 30.0f + f4 * 70.0f) / 100.0f;
                f2 = f5;
                f3 = f7;
                f4 = f8;
            }
            float f6 = 4.882813E-4f;
            double d = this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f);
            double d1 = this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f;
            int j = MathHelper.floor_double(d / 2048.0);
            int k = MathHelper.floor_double(d1 / 2048.0);
            float f9 = 120.0f - f1 + 0.33f;
            float f10 = (float)((d -= (double)(j * 2048)) * (double)f6);
            float f11 = (float)((d1 -= (double)(k * 2048)) * (double)f6);
            tessellator.startDrawingQuads();
            tessellator.setColorRGBA_F(f2, f3, f4, 0.8f);
            int l = -byte0 * i;
            while (l < byte0 * i) {
                int i1 = -byte0 * i;
                while (i1 < byte0 * i) {
                    tessellator.addVertexWithUV(l + 0, f9, i1 + byte0, (float)(l + 0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + byte0, (float)(l + byte0) * f6 + f10, (float)(i1 + byte0) * f6 + f11);
                    tessellator.addVertexWithUV(l + byte0, f9, i1 + 0, (float)(l + byte0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    tessellator.addVertexWithUV(l + 0, f9, i1 + 0, (float)(l + 0) * f6 + f10, (float)(i1 + 0) * f6 + f11);
                    i1 += byte0;
                }
                l += byte0;
            }
            tessellator.draw();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2884);
        }
    }

    private FloatBuffer a(float f1, float f2, float f3, float f4) {
        this.floatBuffer.clear();
        this.floatBuffer.put(f1).put(0.0f).put(f3).put(0.0f);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public void renderFancyClouds(float f) {
        GL11.glDisable((int)2884);
        float f1 = (float)(this.mc.thePlayer.lastTickPosY + (this.mc.thePlayer.posY - this.mc.thePlayer.lastTickPosY) * (double)f);
        Tessellator tessellator = Tessellator.instance;
        float f2 = 12.0f;
        float f3 = 4.0f;
        double d = (this.mc.thePlayer.prevPosX + (this.mc.thePlayer.posX - this.mc.thePlayer.prevPosX) * (double)f + (double)(((float)this.cloudOffsetX + f) * 0.03f)) / (double)f2;
        double d1 = (this.mc.thePlayer.prevPosZ + (this.mc.thePlayer.posZ - this.mc.thePlayer.prevPosZ) * (double)f) / (double)f2 + (double)0.33f;
        float f4 = 108.0f - f1 - (108.0f - this.cloudHeight) + 0.33f;
        int i = MathHelper.floor_double(d / 2048.0);
        int j = MathHelper.floor_double(d1 / 2048.0);
        d -= (double)(i * 2048);
        d1 -= (double)(j * 2048);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            this.renderEngine.getTex("/fluff.png");
            GL11.glTexGeni((int)8192, (int)9472, (int)9217);
            GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this.a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGeni((int)8193, (int)9472, (int)9217);
            GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this.a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3553);
            GL11.glMatrixMode((int)5890);
            GL11.glLoadIdentity();
            GL11.glScalef((float)0.25f, (float)0.25f, (float)0.25f);
            GL11.glTranslatef((float)((float)d), (float)((float)d1), (float)0.0f);
            GL11.glMatrixMode((int)5888);
            GL13.glActiveTexture((int)33984);
            GL11.glEnable((int)3553);
        }
        GL11.glBindTexture((int)3553, (int)this.renderEngine.getTex("/clouds.png"));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Vec3D vec3d = this.worldObj.func_628_d(f);
        float f5 = (float)vec3d.xCoord;
        float f6 = (float)vec3d.yCoord;
        float f7 = (float)vec3d.zCoord;
        if (this.mc.options.anaglyph) {
            float f8 = (f5 * 30.0f + f6 * 59.0f + f7 * 11.0f) / 100.0f;
            float f10 = (f5 * 30.0f + f6 * 70.0f) / 100.0f;
            float f12 = (f5 * 30.0f + f7 * 70.0f) / 100.0f;
            f5 = f8;
            f6 = f10;
            f7 = f12;
        }
        float f9 = (float)(d * 0.0);
        float f11 = (float)(d1 * 0.0);
        float f13 = 0.00390625f;
        f9 = (float)MathHelper.floor_double(d) * f13;
        f11 = (float)MathHelper.floor_double(d1) * f13;
        float f14 = (float)(d - (double)MathHelper.floor_double(d));
        float f15 = (float)(d1 - (double)MathHelper.floor_double(d1));
        int k = 8;
        int byte0 = 3;
        float f16 = 9.765625E-4f;
        GL11.glScalef((float)f2, (float)1.0f, (float)f2);
        int l = 0;
        while (l < 2) {
            if (l == 0) {
                GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            } else {
                GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
            int i1 = -byte0 + 1;
            while (i1 <= byte0) {
                int j1 = -byte0 + 1;
                while (j1 <= byte0) {
                    tessellator.startDrawingQuads();
                    float f17 = i1 * k;
                    float f18 = j1 * k;
                    float f19 = f17 - f14;
                    float f20 = f18 - f15;
                    if (f4 > -f3 - 1.0f) {
                        tessellator.setColorRGBA_F(f5 * 0.7f, f6 * 0.7f, f7 * 0.7f, 0.8f);
                        tessellator.setNormal(0.0f, -1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + 0.0f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)k, (f17 + (float)k) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    if (f4 <= f3 + 1.0f) {
                        tessellator.setColorRGBA_F(f5, f6, f7, 0.8f);
                        tessellator.setNormal(0.0f, 1.0f, 0.0f);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3 - f16, f20 + (float)k, (f17 + 0.0f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + f3 - f16, f20 + (float)k, (f17 + (float)k) * f13 + f9, (f18 + (float)k) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + (float)k, f4 + f3 - f16, f20 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                        tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3 - f16, f20 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                    }
                    tessellator.setColorRGBA_F(f5 * 0.9f, f6 * 0.9f, f7 * 0.9f, 0.8f);
                    if (i1 > -1) {
                        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
                        int k1 = 0;
                        while (k1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + f3, f20 + (float)k, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + f3, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k1 + 0.0f, f4 + 0.0f, f20 + 0.0f, (f17 + (float)k1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            ++k1;
                        }
                    }
                    if (i1 <= 1) {
                        tessellator.setNormal(1.0f, 0.0f, 0.0f);
                        int l1 = 0;
                        while (l1 < k) {
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + f3, f20 + (float)k, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + (float)k) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + f3, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)l1 + 1.0f - f16, f4 + 0.0f, f20 + 0.0f, (f17 + (float)l1 + 0.5f) * f13 + f9, (f18 + 0.0f) * f13 + f11);
                            ++l1;
                        }
                    }
                    tessellator.setColorRGBA_F(f5 * 0.8f, f6 * 0.8f, f7 * 0.8f, 0.8f);
                    if (j1 > -1) {
                        tessellator.setNormal(0.0f, 0.0f, -1.0f);
                        int i2 = 0;
                        while (i2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + f3, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + (float)k) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)i2 + 0.0f, (f17 + 0.0f) * f13 + f9, (f18 + (float)i2 + 0.5f) * f13 + f11);
                            ++i2;
                        }
                    }
                    if (j1 <= 1) {
                        tessellator.setNormal(0.0f, 0.0f, 1.0f);
                        int j2 = 0;
                        while (j2 < k) {
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + f3, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + f3, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + (float)k, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + (float)k) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            tessellator.addVertexWithUV(f19 + 0.0f, f4 + 0.0f, f20 + (float)j2 + 1.0f - f16, (f17 + 0.0f) * f13 + f9, (f18 + (float)j2 + 0.5f) * f13 + f11);
                            ++j2;
                        }
                    }
                    tessellator.draw();
                    ++j1;
                }
                ++i1;
            }
            ++l;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        if (this.texClouds) {
            GL13.glActiveTexture((int)33985);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)3168);
            GL11.glDisable((int)3169);
            GL13.glActiveTexture((int)33984);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean func_948_a(EntityPlayer entityplayer, boolean flag) {
        block27: {
            WorldRenderer chunk;
            if (!this.mc.options.fastRender) break block27;
            RenderSorter cmp = new RenderSorter(entityplayer);
            WorldRenderer[] toAdd = new WorldRenderer[3];
            ArrayList<WorldRenderer> nearChunks = null;
            float dist = 1024.0f;
            int pendingChunkSize = this.worldRenderersToUpdate.size();
            int pendingChunkRemoved = 0;
            int i = 0;
            while (i < pendingChunkSize) {
                block30: {
                    block29: {
                        block28: {
                            chunk = this.worldRenderersToUpdate.get(i);
                            if (flag) break block28;
                            if (!(chunk.distanceToEntitySquared(entityplayer) > dist)) break block29;
                            int index = 0;
                            while (index < 3) {
                                if (toAdd[index] != null && cmp.doCompare(toAdd[index], chunk) == 1) break;
                                ++index;
                            }
                            if (--index > 0) {
                                int x = index;
                                while (--x != 0) {
                                    toAdd[x - 1] = toAdd[x];
                                }
                                toAdd[index] = chunk;
                            }
                            break block30;
                        }
                        if (!chunk.isInFrustrum) break block30;
                    }
                    if (nearChunks == null) {
                        nearChunks = new ArrayList<WorldRenderer>();
                    }
                    ++pendingChunkRemoved;
                    nearChunks.add(chunk);
                    this.worldRenderersToUpdate.set(i, null);
                }
                ++i;
            }
            if (nearChunks != null) {
                if (nearChunks.size() > 1) {
                    Collections.sort(nearChunks, new RenderSorter(entityplayer));
                }
                i = nearChunks.size() - 1;
                while (i >= 0) {
                    chunk = (WorldRenderer)nearChunks.get(i);
                    chunk.updateRenderer();
                    chunk.needsUpdate = false;
                    --i;
                }
            }
            int secondaryRemoved = 0;
            int i2 = 2;
            while (i2 >= 0) {
                WorldRenderer chunk2 = toAdd[i2];
                if (chunk2 != null) {
                    if (!chunk2.isInFrustrum && i2 != 2) {
                        toAdd[i2] = null;
                        toAdd[0] = null;
                        break;
                    }
                    toAdd[i2].updateRenderer();
                    toAdd[i2].needsUpdate = false;
                    ++secondaryRemoved;
                }
                --i2;
            }
            int cursor = 0;
            int target = 0;
            int arraySize = this.worldRenderersToUpdate.size();
            while (cursor != arraySize) {
                WorldRenderer chunk3 = this.worldRenderersToUpdate.get(cursor);
                if (chunk3 != null && chunk3 != toAdd[0] && chunk3 != toAdd[1] && chunk3 != toAdd[2]) {
                    if (target != cursor) {
                        this.worldRenderersToUpdate.set(target, chunk3);
                    }
                    ++target;
                }
                ++cursor;
            }
            while (--cursor >= target) {
                this.worldRenderersToUpdate.remove(cursor);
            }
            return pendingChunkSize == pendingChunkRemoved + secondaryRemoved;
        }
        try {
            Collections.sort(this.worldRenderersToUpdate, new RenderSorter(entityplayer));
            int i = this.worldRenderersToUpdate.size() - 1;
            int j = this.worldRenderersToUpdate.size();
            int k = 0;
            while (k < j) {
                block34: {
                    block31: {
                        WorldRenderer worldrenderer;
                        block33: {
                            block32: {
                                worldrenderer = this.worldRenderersToUpdate.get(i - k);
                                if (flag) break block31;
                                if (!(worldrenderer.distanceToEntitySquared(entityplayer) > 1024.0f)) break block32;
                                if (worldrenderer.isInFrustrum ? k >= 3 : k >= 1) {
                                    return false;
                                }
                                break block33;
                            }
                            if (!worldrenderer.isInFrustrum) break block34;
                        }
                        worldrenderer.updateRenderer();
                        this.worldRenderersToUpdate.remove(worldrenderer);
                        worldrenderer.needsUpdate = false;
                    }
                    return this.worldRenderersToUpdate.size() == 0;
                }
                ++k;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return flag;
    }

    public void func_959_a(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)((MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.4f) * 0.5f));
        if (i == 0) {
            if (this.damagePartialTime > 0.0f) {
                GL11.glBlendFunc((int)774, (int)768);
                int j = this.renderEngine.getTex("/terrain.png");
                GL11.glBindTexture((int)3553, (int)j);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                GL11.glPushMatrix();
                int k = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                Block block = k <= 0 ? null : Block.allBlocks[k];
                GL11.glDisable((int)3008);
                GL11.glPolygonOffset((float)-3.0f, (float)-3.0f);
                GL11.glEnable((int)32823);
                tessellator.startDrawingQuads();
                double d = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
                double d2 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
                tessellator.setTranslationD(-d, -d1, -d2);
                tessellator.disableColor();
                if (block == null) {
                    block = Block.stone;
                }
                this.globalRenderBlocks.func_1223_a(block, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ, 240 + (int)(this.damagePartialTime * 10.0f));
                tessellator.draw();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3008);
                GL11.glDepthMask((boolean)true);
                GL11.glPopMatrix();
            }
        } else if (itemstack != null) {
            GL11.glBlendFunc((int)770, (int)771);
            float f1 = MathHelper.sin((float)System.currentTimeMillis() / 100.0f) * 0.2f + 0.8f;
            GL11.glColor4f((float)f1, (float)f1, (float)f1, (float)(MathHelper.sin((float)System.currentTimeMillis() / 200.0f) * 0.2f + 0.5f));
            int l = this.renderEngine.getTex("/terrain.png");
            GL11.glBindTexture((int)3553, (int)l);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3008);
    }

    public void func_955_b(EntityPlayer entityplayer, MovingObjectPosition movingobjectposition, int i, ItemStack itemstack, float f) {
        if (i == 0 && movingobjectposition.typeOfHit == 0) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GL11.glLineWidth((float)2.0f);
            GL11.glDisable((int)3553);
            GL11.glDepthMask((boolean)false);
            float f1 = 0.002f;
            int j = this.worldObj.getBlockId(movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
            if (j > 0) {
                Block.allBlocks[j].setBlockBoundsBasedOnState(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ);
                double d = entityplayer.lastTickPosX + (entityplayer.posX - entityplayer.lastTickPosX) * (double)f;
                double d1 = entityplayer.lastTickPosY + (entityplayer.posY - entityplayer.lastTickPosY) * (double)f;
                double d2 = entityplayer.lastTickPosZ + (entityplayer.posZ - entityplayer.lastTickPosZ) * (double)f;
                this.func_942_a(Block.allBlocks[j].getSelectedCollisionBoundingBoxFromPool(this.worldObj, movingobjectposition.blockX, movingobjectposition.blockY, movingobjectposition.blockZ).expand(f1, f1, f1).getOffsetBoundingBox(-d, -d1, -d2));
            }
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    private void func_942_a(AxisAlignedBB axisalignedbb) {
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(3);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.draw();
        tessellator.startDrawing(1);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.minZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.maxX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.minY, axisalignedbb.maxZ);
        tessellator.addVertex(axisalignedbb.minX, axisalignedbb.maxY, axisalignedbb.maxZ);
        tessellator.draw();
    }

    public void func_949_a(int i, int j, int k, int l, int i1, int j1) {
        int k1 = MathHelper.func_1111_a(i, 16);
        int l1 = MathHelper.func_1111_a(j, 16);
        int i2 = MathHelper.func_1111_a(k, 16);
        int j2 = MathHelper.func_1111_a(l, 16);
        int k2 = MathHelper.func_1111_a(i1, 16);
        int l2 = MathHelper.func_1111_a(j1, 16);
        int i3 = k1;
        while (i3 <= j2) {
            int j3 = i3 % this.field_1443_p;
            if (j3 < 0) {
                j3 += this.field_1443_p;
            }
            int k3 = l1;
            while (k3 <= k2) {
                int l3 = k3 % this.field_1442_q;
                if (l3 < 0) {
                    l3 += this.field_1442_q;
                }
                int i4 = i2;
                while (i4 <= l2) {
                    int j4 = i4 % this.field_1441_r;
                    if (j4 < 0) {
                        j4 += this.field_1441_r;
                    }
                    int k4 = (j4 * this.field_1442_q + l3) * this.field_1443_p + j3;
                    WorldRenderer worldrenderer = this.worldRenderers[k4];
                    if (!worldrenderer.needsUpdate) {
                        this.worldRenderersToUpdate.add(worldrenderer);
                    }
                    worldrenderer.func_1194_f();
                    ++i4;
                }
                ++k3;
            }
            ++i3;
        }
    }

    public void func_934_a(int i, int j, int k) {
        this.func_949_a(i - 1, j - 1, k - 1, i + 1, j + 1, k + 1);
    }

    public void markBlockRangeNeedsUpdate(int i, int j, int k, int l, int i1, int j1) {
        this.func_949_a(i - 1, j - 1, k - 1, l + 1, i1 + 1, j1 + 1);
    }

    public void func_960_a(ICamera icamera, float f) {
        int i = 0;
        while (i < this.worldRenderers.length) {
            if (!(this.worldRenderers[i].func_1196_e() || this.worldRenderers[i].isInFrustrum && (i + this.frustrumCheckOffset & 0xF) != 0)) {
                this.worldRenderers[i].func_1199_a(icamera);
            }
            ++i;
        }
        ++this.frustrumCheckOffset;
    }

    public void playRecord(String s, int i, int j, int k) {
        if (s != null) {
            if (s.equalsIgnoreCase("magnet")) {
                this.mc.ingameGUI.func_553_b("Markus Alexei - Magnetic Circuit");
            } else {
                this.mc.ingameGUI.func_553_b("C418 - " + s);
            }
            if (s.equals("where are we now")) {
                this.mc.soundMGR.func_331_a("wait", i, j, k, 1.0f, 1.0f);
            }
            if (s.equals("magnet")) {
                this.mc.soundMGR.func_331_a("magnet", i, j, k, 1.0f, 1.0f);
            } else {
                this.mc.soundMGR.func_331_a(s, i, j, k, 1.0f, 1.0f);
            }
        }
    }

    public void displayInfoGUI(String s) {
        if (s != null) {
            this.mc.ingameGUI.showInfo(s);
        }
    }

    public void makeSound(String soundURL, double d, double d1, double d2, float f, float f1) {
        float f2 = 16.0f;
        if (f > 1.0f) {
            f2 *= f;
        }
        if (this.mc.thePlayer.getDistanceSq(d, d1, d2) < (double)(f2 * f2)) {
            this.mc.soundMGR.playSound(soundURL, (float)d, (float)d1, (float)d2, f, f1);
        }
    }

    public void makeAmbience(String soundURL, double d, double d1, double d2, float f, float f1) {
        this.mc.soundMGR.playLoop(soundURL, (float)d, (float)d1, (float)d2, f, f1);
    }

    public void updateAmbience(String soundURL, double d, double d1, double d2, float f, float f1) {
        this.mc.soundMGR.updateLoop(soundURL, (float)d, (float)d1, (float)d2, f, f1);
    }

    public boolean isAmbienceEnabled() {
        return this.mc.soundMGR.isAmbienceEnabled();
    }

    public void spawnParticle(String s, double d, double d1, double d2, double d3, double d4, double d5) {
        double d6 = this.mc.thePlayer.posX - d;
        double d7 = this.mc.thePlayer.posY - d1;
        double d8 = this.mc.thePlayer.posZ - d2;
        if (d6 * d6 + d7 * d7 + d8 * d8 > 256.0) {
            return;
        }
        if (s == "bubble") {
            this.mc.effectRenderer.addEffect(new EntityBubbleFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "smoke") {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2));
        } else if (s == "explode") {
            this.mc.effectRenderer.addEffect(new EntityExplodeFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "flame") {
            this.mc.effectRenderer.addEffect(new EntityFlameFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "lava") {
            this.mc.effectRenderer.addEffect(new EntityLavaFX(this.worldObj, d, d1, d2));
        } else if (s == "splash") {
            this.mc.effectRenderer.addEffect(new EntitySplashFX(this.worldObj, d, d1, d2, d3, d4, d5));
        } else if (s == "largesmoke") {
            this.mc.effectRenderer.addEffect(new EntitySmokeFX(this.worldObj, d, d1, d2, 2.5f));
        } else if (s == "reddust") {
            this.mc.effectRenderer.addEffect(new EntityReddustFX(this.worldObj, d, d1, d2));
        } else if (s == "snowballpoof") {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.snowball));
        } else if (s == "slime") {
            this.mc.effectRenderer.addEffect(new EntitySlimeFX(this.worldObj, d, d1, d2, Item.slimeBall));
        }
    }

    public void func_941_a(Entity entity) {
        if (entity.skinURL != null) {
            this.renderEngine.func_1075_a(entity.skinURL, new ImageBufferDownload());
        }
    }

    public void func_938_b(Entity entity) {
        if (entity.skinURL != null) {
            this.renderEngine.func_1073_b(entity.skinURL);
        }
    }

    public void updateAllRenderers() {
        int i = 0;
        while (i < this.worldRenderers.length) {
            if (this.worldRenderers[i].field_1747_A) {
                if (!this.worldRenderers[i].needsUpdate) {
                    this.worldRenderersToUpdate.add(this.worldRenderers[i]);
                }
                this.worldRenderers[i].func_1194_f();
            }
            ++i;
        }
    }

    public void hashTileEntity(int i, int j, int k, TileEntity tileentity) {
    }

    public void func_28136_a(EntityPlayer entityplayer, int i, int j, int k, int l, int i1) {
        Random random = this.worldObj.rand;
        switch (i) {
            default: {
                break;
            }
            case 1001: {
                this.worldObj.playSoundEffect(j, k, l, "random.click", 1.0f, 1.2f);
                break;
            }
            case 1000: {
                this.worldObj.playSoundEffect(j, k, l, "random.click", 1.0f, 1.0f);
                break;
            }
            case 1002: {
                this.worldObj.playSoundEffect(j, k, l, "random.bow", 1.0f, 1.2f);
                break;
            }
            case 2000: {
                int j1 = i1 % 3 - 1;
                int k1 = i1 / 3 % 3 - 1;
                double d = (double)j + (double)j1 * 0.6 + 0.5;
                double d1 = (double)k + 0.5;
                double d2 = (double)l + (double)k1 * 0.6 + 0.5;
                int l1 = 0;
                while (l1 < 10) {
                    double d3 = random.nextDouble() * 0.2 + 0.01;
                    double d4 = d + (double)j1 * 0.01 + (random.nextDouble() - 0.5) * (double)k1 * 0.5;
                    double d5 = d1 + (random.nextDouble() - 0.5) * 0.5;
                    double d6 = d2 + (double)k1 * 0.01 + (random.nextDouble() - 0.5) * (double)j1 * 0.5;
                    double d7 = (double)j1 * d3 + random.nextGaussian() * 0.01;
                    double d8 = -0.03 + random.nextGaussian() * 0.01;
                    double d9 = (double)k1 * d3 + random.nextGaussian() * 0.01;
                    this.spawnParticle("smoke", d4, d5, d6, d7, d8, d9);
                    ++l1;
                }
                break;
            }
            case 2001: {
                int i2 = i1 & 0xFF;
                if (i2 > 0) {
                    Block block = Block.allBlocks[i2];
                    this.mc.soundMGR.playSound(block.stepSound.stepSoundDir(), (float)j + 0.5f, (float)k + 0.5f, (float)l + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
                }
                this.mc.effectRenderer.addBlockDestroyEffects(j, k, l);
                break;
            }
            case 1003: {
                if (Math.random() < 0.5) {
                    this.worldObj.playSoundEffect((double)j + 0.5, (double)k + 0.5, (double)l + 0.5, "random.door_open", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                    break;
                }
                this.worldObj.playSoundEffect((double)j + 0.5, (double)k + 0.5, (double)l + 0.5, "random.door_close", 1.0f, this.worldObj.rand.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case 1004: {
                this.worldObj.playSoundEffect((float)j + 0.5f, (float)k + 0.5f, (float)l + 0.5f, "random.fizz", 0.5f, 2.6f + (random.nextFloat() - random.nextFloat()) * 0.8f);
                break;
            }
            case 1005: {
                if (Item.itemsList[i1] instanceof ItemRecord) {
                    this.worldObj.playRecord(((ItemRecord)Item.itemsList[i1]).recordName, j, k, l);
                    break;
                }
                this.worldObj.playRecord(null, j, k, l);
            }
        }
    }
}

