/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.nbt.NBTTagCompound;
import com.mojang.minecraft.render.Vec3D;
import com.mojang.minecraft.util.MathHelper;

public class EntityFish
extends Entity {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private boolean inGround = false;
    public int shake = 0;
    public EntityPlayer angler;
    private int ticksInGround;
    private int ticksInAir = 0;
    private int ticksCatchable = 0;
    public Entity bobber = null;
    private int field_6388_l;
    private double field_6387_m;
    private double field_6386_n;
    private double field_6385_o;
    private double field_6384_p;
    private double field_6383_q;
    private double velocityX;
    private double velocityY;
    private double velocityZ;

    public EntityFish(World world) {
        super(world);
        this.setSize(0.25f, 0.25f);
    }

    public EntityFish(World world, double d, double d1, double d2) {
        this(world);
        this.setPosition(d, d1, d2);
    }

    public EntityFish(World world, EntityPlayer entityplayer) {
        super(world);
        this.angler = entityplayer;
        this.angler.fishEntity = this;
        this.setSize(0.25f, 0.25f);
        this.setLocationAndAngles(entityplayer.posX, entityplayer.posY + 1.62 - (double)entityplayer.yOffset, entityplayer.posZ, entityplayer.rotationYaw, entityplayer.rotationPitch);
        this.posX -= (double)(MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.posY -= (double)0.1f;
        this.posZ -= (double)(MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        float f = 0.4f;
        this.motionX = -MathHelper.sin(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.motionZ = MathHelper.cos(this.rotationYaw / 180.0f * 3.141593f) * MathHelper.cos(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.motionY = -MathHelper.sin(this.rotationPitch / 180.0f * 3.141593f) * f;
        this.func_4042_a(this.motionX, this.motionY, this.motionZ, 1.5f, 1.0f);
    }

    @Override
    protected void entityInit() {
    }

    @Override
    public boolean isInRangeToRenderDist(double d) {
        double d1 = this.boundingBox.getAverageEdgeLength() * 4.0;
        return d < (d1 *= 64.0) * d1;
    }

    public void func_4042_a(double d, double d1, double d2, float f, float f1) {
        float f2 = MathHelper.sqrt_double(d * d + d1 * d1 + d2 * d2);
        d /= (double)f2;
        d1 /= (double)f2;
        d2 /= (double)f2;
        d += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d1 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        d2 += this.rand.nextGaussian() * (double)0.0075f * (double)f1;
        this.motionX = d *= (double)f;
        this.motionY = d1 *= (double)f;
        this.motionZ = d2 *= (double)f;
        float f3 = MathHelper.sqrt_double(d * d + d2 * d2);
        this.rotationYaw = (float)(Math.atan2(d, d2) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(d1, f3) * 180.0 / 3.1415927410125732);
        this.ticksInGround = 0;
    }

    @Override
    public void setPositionAndRotation2(double d, double d1, double d2, float f, float f1, int i) {
        this.field_6387_m = d;
        this.field_6386_n = d1;
        this.field_6385_o = d2;
        this.field_6384_p = f;
        this.field_6383_q = f1;
        this.field_6388_l = i;
        this.motionX = this.velocityX;
        this.motionY = this.velocityY;
        this.motionZ = this.velocityZ;
    }

    @Override
    public void setVelocity(double d, double d1, double d2) {
        this.velocityX = this.motionX = d;
        this.velocityY = this.motionY = d1;
        this.velocityZ = this.motionZ = d2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_6388_l > 0) {
            d = this.posX + (this.field_6387_m - this.posX) / (double)this.field_6388_l;
            d1 = this.posY + (this.field_6386_n - this.posY) / (double)this.field_6388_l;
            d2 = this.posZ + (this.field_6385_o - this.posZ) / (double)this.field_6388_l;
            d4 = this.field_6384_p - (double)this.rotationYaw;
            while (d4 < -180.0) {
                d4 += 360.0;
            }
            while (d4 >= 180.0) {
                d4 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d4 / (double)this.field_6388_l);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_6383_q - (double)this.rotationPitch) / (double)this.field_6388_l);
            --this.field_6388_l;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
            return;
        }
        if (!this.worldObj.multiplayerWorld) {
            itemstack = this.angler.getCurrentEquippedItem();
            if (this.angler.isDead || !this.angler.isEntityAlive() || itemstack == null || itemstack.getItem() != Item.fishingRod || this.getDistanceSqToEntity(this.angler) > 1024.0) {
                this.setEntityDead();
                this.angler.fishEntity = null;
                return;
            }
            if (this.bobber != null) {
                if (this.bobber.isDead) {
                    this.bobber = null;
                } else {
                    this.posX = this.bobber.posX;
                    this.posY = this.bobber.boundingBox.minY + (double)this.bobber.height * 0.8;
                    this.posZ = this.bobber.posZ;
                    return;
                }
            }
        }
        if (this.shake > 0) {
            --this.shake;
        }
        if (!this.inGround) ** GOTO lbl49
        i = this.worldObj.getBlockId(this.xTile, this.yTile, this.zTile);
        if (i != this.inTile) {
            this.inGround = false;
            this.motionX *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionY *= (double)(this.rand.nextFloat() * 0.2f);
            this.motionZ *= (double)(this.rand.nextFloat() * 0.2f);
            this.ticksInGround = 0;
            this.ticksInAir = 0;
        } else {
            ++this.ticksInGround;
            if (this.ticksInGround == 1200) {
                this.setEntityDead();
            }
            return;
lbl49:
            // 1 sources

            ++this.ticksInAir;
        }
        vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        movingobjectposition = this.worldObj.rayTraceBlocks(vec3d, vec3d1);
        vec3d = Vec3D.createVector(this.posX, this.posY, this.posZ);
        vec3d1 = Vec3D.createVector(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (movingobjectposition != null) {
            vec3d1 = Vec3D.createVector(movingobjectposition.hitVec.xCoord, movingobjectposition.hitVec.yCoord, movingobjectposition.hitVec.zCoord);
        }
        entity = null;
        list = this.worldObj.getEntitiesWithinAABBExcludingEntity(this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        d3 = 0.0;
        j = 0;
        while (j < list.size()) {
            entity1 = list.get(j);
            if (entity1.canBeCollidedWith() && (entity1 != this.angler || this.ticksInAir >= 5) && (movingobjectposition1 = (axisalignedbb = entity1.boundingBox.expand(f2 = 0.3f, f2, f2)).func_1169_a(vec3d, vec3d1)) != null && ((d6 = vec3d.distanceTo(movingobjectposition1.hitVec)) < d3 || d3 == 0.0)) {
                entity = entity1;
                d3 = d6;
            }
            ++j;
        }
        if (entity != null) {
            movingobjectposition = new MovingObjectPosition(entity);
        }
        if (movingobjectposition != null) {
            if (movingobjectposition.entityHit != null) {
                if (movingobjectposition.entityHit.attackEntityFrom(this.angler, 0)) {
                    this.bobber = movingobjectposition.entityHit;
                }
            } else {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            return;
        }
        this.moveEntity(this.motionX, this.motionY, this.motionZ);
        f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / 3.1415927410125732);
        this.rotationPitch = (float)(Math.atan2(this.motionY, f) * 180.0 / 3.1415927410125732);
        while (this.rotationPitch < -180.0f) {
            this.rotationPitch -= 360.0f;
        }
        this.rotationPitch *= 0.2f;
        this.rotationYaw *= 0.2f;
        f1 = 0.92f;
        if (this.onGround) {
            f1 = 0.5f;
        }
        k = 5;
        d5 = 0.0;
        l = 0;
        while (l < k) {
            d8 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(l + 0) / (double)k - 0.125 + 0.125;
            d9 = this.boundingBox.minY + (this.boundingBox.maxY - this.boundingBox.minY) * (double)(l + 1) / (double)k - 0.125 + 0.125;
            axisalignedbb1 = AxisAlignedBB.getBoundingBoxFromPool(this.boundingBox.minX, d8, this.boundingBox.minZ, this.boundingBox.maxX, d9, this.boundingBox.maxZ);
            if (this.worldObj.isAABBInMaterial(axisalignedbb1, Material.water)) {
                d5 += 1.0 / (double)k;
            }
            ++l;
        }
        if (d5 > 0.0) {
            if (this.ticksCatchable > 0) {
                --this.ticksCatchable;
            } else {
                c = 500;
                if (this.rand.nextInt(c) == 0) {
                    this.ticksCatchable = this.rand.nextInt(30) + 10;
                    this.motionY -= 0.20000000298023224;
                    this.worldObj.playSoundAtEntity(this, "random.splash", 0.25f, 1.0f + (this.rand.nextFloat() - this.rand.nextFloat()) * 0.4f);
                    f3 = MathHelper.floor_double(this.boundingBox.minY);
                    i1 = 0;
                    while ((float)i1 < 1.0f + this.width * 20.0f) {
                        f4 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                        f6 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                        this.worldObj.spawnParticle("bubble", this.posX + (double)f4, f3 + 1.0f, this.posZ + (double)f6, this.motionX, this.motionY - (double)(this.rand.nextFloat() * 0.2f), this.motionZ);
                        ++i1;
                    }
                    j1 = 0;
                    while ((float)j1 < 1.0f + this.width * 20.0f) {
                        f5 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                        f7 = (this.rand.nextFloat() * 2.0f - 1.0f) * this.width;
                        this.worldObj.spawnParticle("splash", this.posX + (double)f5, f3 + 1.0f, this.posZ + (double)f7, this.motionX, this.motionY, this.motionZ);
                        ++j1;
                    }
                }
            }
        }
        if (this.ticksCatchable > 0) {
            this.motionY -= (double)(this.rand.nextFloat() * this.rand.nextFloat() * this.rand.nextFloat()) * 0.2;
        }
        d7 = d5 * 2.0 - 1.0;
        this.motionY += 0.03999999910593033 * d7;
        if (d5 > 0.0) {
            f1 = (float)((double)f1 * 0.9);
            this.motionY *= 0.8;
        }
        this.motionX *= (double)f1;
        this.motionY *= (double)f1;
        this.motionZ *= (double)f1;
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.setShort("xTile", (short)this.xTile);
        nbttagcompound.setShort("yTile", (short)this.yTile);
        nbttagcompound.setShort("zTile", (short)this.zTile);
        nbttagcompound.setByte("inTile", (byte)this.inTile);
        nbttagcompound.setByte("shake", (byte)this.shake);
        nbttagcompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.xTile = nbttagcompound.getShort("xTile");
        this.yTile = nbttagcompound.getShort("yTile");
        this.zTile = nbttagcompound.getShort("zTile");
        this.inTile = nbttagcompound.getByte("inTile") & 0xFF;
        this.shake = nbttagcompound.getByte("shake") & 0xFF;
        this.inGround = nbttagcompound.getByte("inGround") == 1;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    public int catchFish() {
        int byte0 = 0;
        if (this.bobber != null) {
            double d = this.angler.posX - this.posX;
            double d2 = this.angler.posY - this.posY;
            double d4 = this.angler.posZ - this.posZ;
            double d6 = MathHelper.sqrt_double(d * d + d2 * d2 + d4 * d4);
            double d8 = 0.1;
            this.bobber.motionX += d * d8;
            this.bobber.motionY += d2 * d8 + (double)MathHelper.sqrt_double(d6) * 0.08;
            this.bobber.motionZ += d4 * d8;
            byte0 = 3;
        } else if (this.ticksCatchable > 0) {
            EntityItem entityitem = new EntityItem(this.worldObj, this.posX, this.posY, this.posZ, new ItemStack(Item.fishRaw));
            double d1 = this.angler.posX - this.posX;
            double d3 = this.angler.posY - this.posY;
            double d5 = this.angler.posZ - this.posZ;
            double d7 = MathHelper.sqrt_double(d1 * d1 + d3 * d3 + d5 * d5);
            double d9 = 0.1;
            entityitem.motionX = d1 * d9;
            entityitem.motionY = d3 * d9 + (double)MathHelper.sqrt_double(d7) * 0.08;
            entityitem.motionZ = d5 * d9;
            this.worldObj.entityJoinedWorld(entityitem);
            byte0 = 1;
        }
        if (this.inGround) {
            byte0 = 2;
        }
        this.setEntityDead();
        this.angler.fishEntity = null;
        return byte0;
    }
}

