/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.entity;

import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.util.MathHelper;
import com.mojang.minecraft.util.SkinUrlGetPost;

public class EntityOtherPlayerMP
extends EntityPlayer {
    private int field_785_bg;
    private double field_784_bh;
    private double field_783_bi;
    private double field_782_bj;
    private double field_780_bk;
    private double field_786_bl;
    float field_781_a = 0.0f;

    public EntityOtherPlayerMP(World world, String s) {
        super(world);
        this.playerName = s;
        this.yOffset = 0.0f;
        this.stepHeight = 0.0f;
        if (s != null && s.length() > 0) {
            try {
                this.skinURL = SkinUrlGetPost.getPostUrl(s);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Loading texture " + this.skinURL);
        }
        this.noClip = true;
        this.renderDistanceWeight = 10.0;
    }

    @Override
    public void setPositionAndRotation2(double d, double d1, double d2, float f, float f1, int i) {
        this.yOffset = 0.0f;
        this.field_784_bh = d;
        this.field_783_bi = d1;
        this.field_782_bj = d2;
        this.field_780_bk = f;
        this.field_786_bl = f1;
        this.field_785_bg = i;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.field_705_Q = this.limbSwingAmount;
        double d = this.posX - this.prevPosX;
        double d1 = this.posZ - this.prevPosZ;
        float f = MathHelper.sqrt_double(d * d + d1 * d1) * 4.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.limbSwingAmount += (f - this.limbSwingAmount) * 0.4f;
        this.limbSwing += this.limbSwingAmount;
    }

    @Override
    public float getShadowSize() {
        return 0.0f;
    }

    @Override
    public void onLivingUpdate() {
        super.updateEntityActionState();
        if (this.field_785_bg > 0) {
            double d = this.posX + (this.field_784_bh - this.posX) / (double)this.field_785_bg;
            double d1 = this.posY + (this.field_783_bi - this.posY) / (double)this.field_785_bg;
            double d2 = this.posZ + (this.field_782_bj - this.posZ) / (double)this.field_785_bg;
            double d3 = this.field_780_bk - (double)this.rotationYaw;
            while (d3 < -180.0) {
                d3 += 360.0;
            }
            while (d3 >= 180.0) {
                d3 -= 360.0;
            }
            this.rotationYaw = (float)((double)this.rotationYaw + d3 / (double)this.field_785_bg);
            this.rotationPitch = (float)((double)this.rotationPitch + (this.field_786_bl - (double)this.rotationPitch) / (double)this.field_785_bg);
            --this.field_785_bg;
            this.setPosition(d, d1, d2);
            this.setRotation(this.rotationYaw, this.rotationPitch);
        }
        this.field_775_e = this.field_774_f;
        float f = MathHelper.sqrt_double(this.motionX * this.motionX + this.motionZ * this.motionZ);
        float f1 = (float)Math.atan(-this.motionY * (double)0.2f) * 15.0f;
        if (f > 0.1f) {
            f = 0.1f;
        }
        if (!this.onGround || this.health <= 0) {
            f = 0.0f;
        }
        if (this.onGround || this.health <= 0) {
            f1 = 0.0f;
        }
        this.field_774_f += (f - this.field_774_f) * 0.4f;
        this.field_709_M += (f1 - this.field_709_M) * 0.8f;
    }

    @Override
    public void outfitWithItem(int i, int j, int k) {
        ItemStack itemstack = null;
        if (j >= 0) {
            itemstack = new ItemStack(j, 1, k);
        }
        if (i == 0) {
            this.inventory.mainInventory[this.inventory.currentItem] = itemstack;
        } else {
            this.inventory.armorInventory[i - 1] = itemstack;
        }
    }
}

