/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityChicken;
import com.mojang.minecraft.entity.EntityCow;
import com.mojang.minecraft.entity.EntityCreeper;
import com.mojang.minecraft.entity.EntityGiant;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityLightningBolt;
import com.mojang.minecraft.entity.EntityMob;
import com.mojang.minecraft.entity.EntityMobs;
import com.mojang.minecraft.entity.EntityPig;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntitySheep;
import com.mojang.minecraft.entity.EntitySkeleton;
import com.mojang.minecraft.entity.EntitySlime;
import com.mojang.minecraft.entity.EntitySpider;
import com.mojang.minecraft.entity.EntityZombie;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.gui.ChatAllowedCharacters;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.player.controller.PlayerControllerCreative;
import com.mojang.minecraft.player.controller.PlayerControllerSP;
import com.mojang.minecraft.util.IdMap;
import java.io.UnsupportedEncodingException;
import java.util.Random;
import org.lwjgl.input.Keyboard;

public class GuiChat
extends GuiScreen {
    static String[] PLAYER_COLORS = new String[]{"c", "b", "a", "5", "6", "e", "d", "7"};
    private String message = "";
    private int updateCounter = 0;

    @Override
    public void initGui() {
        Keyboard.enableRepeatEvents((boolean)true);
    }

    @Override
    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    public void updateScreen() {
        ++this.updateCounter;
    }

    public void sendText(String s) {
        this.mc.ingameGUI.addChatMessage(s);
    }

    public static String computePlayerColor(String name) {
        byte[] pName = null;
        try {
            pName = name.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int length = pName.length;
        int oddShift = 1 - length % 2;
        int value = 0;
        int i = 0;
        while (i < length) {
            byte by = pName[i];
            int rev = length - (i + 1) + oddShift;
            value = rev % 4 >= 2 ? (value -= by) : (value += by);
            ++i;
        }
        if ((value %= 8) < 0) {
            value = PLAYER_COLORS.length + value;
        }
        System.out.println(value);
        return PLAYER_COLORS[value];
    }

    @Override
    protected void keyTyped(char c, int i) {
        String s;
        if (i == 1) {
            this.mc.setCurrentScreen(null);
            return;
        }
        if (c == '\u0016') {
            int j;
            s = GuiScreen.getClipboardString();
            if (s == null) {
                s = "";
            }
            if ((j = 32 - this.message.length()) > s.length()) {
                j = s.length();
            }
            if (j > 0) {
                this.message = String.valueOf(this.message) + s.substring(0, j);
            }
        }
        if (i == 28) {
            s = this.message.trim();
            if (s.length() > 0) {
                this.mc.thePlayer.sendChatMessage(this.message.trim());
            }
            this.mc.setCurrentScreen(null);
            if (!this.mc.isServer()) {
                if (this.message.startsWith("/") && !this.mc.thePlayer.worldObj.cheatsDisabled) {
                    this.handleCommand(this.message.replaceFirst("/", ""));
                } else if (!this.message.startsWith("/")) {
                    this.sendText("<\u00a7" + GuiChat.computePlayerColor(this.mc.session.username) + this.mc.session.username + "\u00a7f> " + this.message);
                }
            }
            return;
        }
        if (i == 14 && this.message.length() > 0) {
            this.message = this.message.substring(0, this.message.length() - 1);
        }
        if (ChatAllowedCharacters.allowedCharacters.indexOf(c) >= 0 && this.message.length() < 100) {
            this.message = String.valueOf(this.message) + c;
        }
    }

    private Block getBlockIfExist(int id) {
        int i = 0;
        while (i < Block.allBlocks.length) {
            if (Block.allBlocks[i] != null && Block.allBlocks[i].blockID == id) {
                return Block.allBlocks[i];
            }
            ++i;
        }
        return null;
    }

    private Item getItemIfExist(int id) {
        int i = 0;
        while (i < Item.itemsList.length) {
            if (Item.itemsList[i] != null && Item.itemsList[i].shiftedIndex == id) {
                return Item.itemsList[i];
            }
            ++i;
        }
        return null;
    }

    private void handleCommand(String command) {
        String[] commandArgs = command.split(" ");
        if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
            block90: {
                if (commandArgs.length <= 3 && commandArgs.length >= 2) {
                    try {
                        int id;
                        block89: {
                            id = 0;
                            try {
                                id = Integer.parseInt(commandArgs[1]);
                            }
                            catch (Exception ex) {
                                id = IdMap.getItem(commandArgs[1]);
                                if (id != -1) break block89;
                                this.sendText("Invalid item: " + commandArgs[1]);
                                if (commandArgs[1].equals("null")) {
                                    this.mc.func_105_a(null, "");
                                }
                                return;
                            }
                        }
                        Block blk = this.getBlockIfExist(id);
                        Item itm = null;
                        int size = 64;
                        if (commandArgs.length == 3) {
                            size = Integer.parseInt(commandArgs[2]);
                        }
                        if (blk == null) {
                            itm = this.getItemIfExist(id);
                            if (itm != null) {
                                if (commandArgs.length < 3) {
                                    size = itm.maxStackSize;
                                }
                                this.sendText("Giving " + size + " of item " + id);
                                EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm, size));
                                entityitem.delayBeforeCanPickup = 10;
                                this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                            } else {
                                this.sendText("\u00a7cInvalid item: " + id);
                            }
                            break block90;
                        }
                        this.sendText("Giving " + size + " of item " + id);
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                    catch (Exception ex) {
                        this.sendText("\u00a7cInvalid syntax for command: " + command);
                        ex.printStackTrace();
                    }
                } else if (commandArgs.length < 2) {
                    this.sendText("\u00a7cThis requires 2 or more arguments!");
                } else {
                    this.sendText("\u00a7cThis command cannot accept more than 3 arguments!");
                }
            }
            return;
        }
        if (commandArgs.length == 2) {
            if (commandArgs[0].equalsIgnoreCase("setwinter")) {
                try {
                    commandArgs[1] = commandArgs[1].toLowerCase();
                    if (commandArgs[1].equalsIgnoreCase("true") || commandArgs[1].equalsIgnoreCase("false")) {
                        this.mc.thePlayer.worldObj.snowCovered = Boolean.parseBoolean(commandArgs[1]);
                    } else {
                        this.sendText("\u00a7cYou cannot set winter to " + commandArgs[1] + "!");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("summon")) {
                Random rand = new Random();
                Entity entitysummon = null;
                if (commandArgs[1].equalsIgnoreCase("slime")) {
                    entitysummon = new EntitySlime(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("mob")) {
                    entitysummon = new EntityMob(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("monster")) {
                    entitysummon = new EntityMobs(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("zombie")) {
                    entitysummon = new EntityZombie(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("creeper")) {
                    entitysummon = new EntityCreeper(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("skeleton")) {
                    entitysummon = new EntitySkeleton(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("sheep")) {
                    entitysummon = new EntitySheep(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("pig")) {
                    entitysummon = new EntityPig(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("cow")) {
                    entitysummon = new EntityCow(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("chicken")) {
                    entitysummon = new EntityChicken(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("giant")) {
                    entitysummon = new EntityGiant(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("spider")) {
                    entitysummon = new EntitySpider(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("player")) {
                    entitysummon = new EntityPlayer(this.mc.thePlayer.worldObj);
                } else if (commandArgs[1].equalsIgnoreCase("lightning")) {
                    entitysummon = new EntityLightningBolt(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY - 2.0, this.mc.thePlayer.posZ);
                }
                if (entitysummon != null) {
                    entitysummon.setLocationAndAngles(this.mc.thePlayer.posX, this.mc.thePlayer.posY + 0.5, this.mc.thePlayer.posZ, rand.nextFloat() * 360.0f, 0.0f);
                    this.mc.thePlayer.worldObj.entityJoinedWorld(entitysummon);
                } else {
                    this.sendText("\u00a7cA " + commandArgs[1] + " is not a valid entity!");
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("gamemode")) {
                if (commandArgs[1].equalsIgnoreCase("survival") || commandArgs[1].equalsIgnoreCase("s") || commandArgs[1].equalsIgnoreCase("0")) {
                    this.mc.playerController = new PlayerControllerSP(this.mc);
                    this.mc.thePlayer.isCreative = false;
                    this.sendText("Your game mode has been set to survival.");
                } else if (commandArgs[1].equalsIgnoreCase("creative") || commandArgs[1].equalsIgnoreCase("c") || commandArgs[1].equalsIgnoreCase("1")) {
                    this.mc.playerController = new PlayerControllerCreative(this.mc);
                    this.mc.thePlayer.isCreative = true;
                    this.sendText("Your game mode has been set to creative.");
                } else {
                    this.sendText("\u00a7c" + commandArgs[1] + " is not a valid game mode!");
                }
                return;
            }
        } else if (commandArgs.length == 3) {
            if (commandArgs[0].equalsIgnoreCase("time")) {
                try {
                    if (commandArgs[1].equalsIgnoreCase("add")) {
                        int ticks = Integer.parseInt(commandArgs[2]);
                        this.mc.thePlayer.worldObj.worldTime += (long)ticks;
                    } else if (commandArgs[1].equalsIgnoreCase("set")) {
                        if (commandArgs[2].equalsIgnoreCase("day")) {
                            this.mc.thePlayer.worldObj.worldTime = 0L;
                        } else if (commandArgs[2].equalsIgnoreCase("night")) {
                            this.mc.thePlayer.worldObj.worldTime = 13000L;
                        } else {
                            int ticks = Integer.parseInt(commandArgs[2]);
                            this.mc.thePlayer.worldObj.worldTime = ticks;
                        }
                    } else {
                        this.sendText("\u00a7cInvalid parameter for time command: " + commandArgs[1] + ". Use 'add' or 'set'");
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 4) {
            if (commandArgs[0].equalsIgnoreCase("give") || commandArgs[0].equalsIgnoreCase("i")) {
                try {
                    int id = Integer.parseInt(commandArgs[1]);
                    int size = Integer.parseInt(commandArgs[2]);
                    int damage = Integer.parseInt(commandArgs[3]);
                    Block blk = this.getBlockIfExist(id);
                    Item itm = null;
                    if (blk == null) {
                        itm = this.getItemIfExist(id);
                        if (itm != null) {
                            this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                            EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(itm.shiftedIndex, size, damage));
                            entityitem.delayBeforeCanPickup = 10;
                            this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                        } else {
                            this.sendText("\u00a7cInvalid item: " + id);
                        }
                    } else {
                        this.sendText("Giving " + size + " of item " + id + " with damage " + damage);
                        this.sendText("Damage invalid for block, ignoring");
                        EntityItem entityitem = new EntityItem(this.mc.thePlayer.worldObj, this.mc.thePlayer.posX, this.mc.thePlayer.posY, this.mc.thePlayer.posZ, new ItemStack(blk, size));
                        entityitem.delayBeforeCanPickup = 10;
                        this.mc.thePlayer.worldObj.entityJoinedWorld(entityitem);
                    }
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("teleport") || commandArgs[0].equalsIgnoreCase("tp")) {
                try {
                    int x = Integer.parseInt(commandArgs[1]);
                    int y = Integer.parseInt(commandArgs[2]);
                    int z = Integer.parseInt(commandArgs[3]);
                    if (this.mc.thePlayer.worldObj.getBlockId(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.thePlayer.worldObj, x, y, z);
                    this.mc.thePlayer.setPosition(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
        } else if (commandArgs.length == 1) {
            if (commandArgs[0].equalsIgnoreCase("spawn")) {
                try {
                    int x = this.mc.thePlayer.worldObj.spawnX;
                    int y = this.mc.thePlayer.worldObj.spawnY;
                    int z = this.mc.thePlayer.worldObj.spawnZ;
                    if (this.mc.thePlayer.worldObj.getBlockId(x, y, z) != 0) {
                        // empty if block
                    }
                    y = this.getHighestBlock(this.mc.thePlayer.worldObj, x, y, z);
                    this.mc.thePlayer.setPosition(x, y, z);
                }
                catch (Exception ex) {
                    this.sendText("\u00a7cInvalid syntax for command: " + command);
                    ex.printStackTrace();
                }
                return;
            }
            if (commandArgs[0].equalsIgnoreCase("help")) {
                this.sendText("\u00a7b---------------Command help (Page 1 of 1)---------------");
                this.sendText("\u00a7e/teleport/tp <x> <y> <z> - teleport to a location");
                this.sendText("\u00a7e/give <item> [quantity] - gives requested item");
                this.sendText("\u00a7e/i <item> [quantity] - alias to give");
                this.sendText("\u00a7e/time <set/add> <ticks> - changes the time");
                this.sendText("\u00a7e/setwinter <true/false> - sets the world's climate");
                this.sendText("\u00a7e/summon <entity> - spawns the requested entity");
                this.sendText("\u00a7e/spawn - sends you to the spawn location");
                this.sendText("\u00a7e/gamemode <survival/creative> - sets your current gamemode");
                this.sendText("\u00a7b-----------------------------------------------------");
                return;
            }
        }
        this.sendText("\u00a7cInvalid command: " + command);
    }

    private int getHighestBlock(World world, int x, int y, int z) {
        int i = 128;
        while (i > 0) {
            if (world.getBlockId(x, i, z) != 0) {
                return i + 2;
            }
            --i;
        }
        return 0;
    }

    @Override
    public void drawScreen(int i, int j, float f) {
        this.drawRect(2, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        this.drawString(this.fontRenderer, "> " + this.message + (this.updateCounter / 6 % 2 != 0 ? "" : "_"), 4, this.height - 12, 0xE0E0E0);
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        System.out.println(this.message);
        if (k != 0 || this.mc.ingameGUI.field_933_a == null) {
            return;
        }
        if (this.message.length() > 0 && !this.message.endsWith(" ")) {
            this.message = String.valueOf(this.message) + " ";
        }
        this.message = String.valueOf(this.message) + this.mc.ingameGUI.field_933_a;
        int byte0 = 100;
        if (this.message.length() > byte0) {
            this.message = this.message.substring(0, byte0);
        }
    }
}

