/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.gui;

import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.render.RenderItem;
import com.mojang.minecraft.gui.GuiScreen;
import com.mojang.minecraft.player.inventory.Container;
import com.mojang.minecraft.player.inventory.InventoryPlayer;
import com.mojang.minecraft.player.inventory.Slot;
import com.mojang.minecraft.render.RenderHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainer
extends GuiScreen {
    private static RenderItem itemRenderer = new RenderItem();
    public int xSize = 176;
    public int ySize = 166;
    protected Container inventorySlots;

    public GuiContainer(Container container) {
        this.inventorySlots = container;
    }

    @Override
    public void initGui() {
        super.initGui();
        this.mc.thePlayer.craftingInventory = this.inventorySlots;
    }

    @Override
    public void drawScreen(int i, int j, float f) {
        this.drawDefaultBackground();
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawGuiContainerBackgroundLayer(f);
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderHelper.enableStandardItemLighting();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)k, (float)l, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        int i1 = 0;
        while (i1 < this.inventorySlots.slots.size()) {
            Slot slotinventory = (Slot)this.inventorySlots.slots.get(i1);
            this.drawSlotInventory(slotinventory);
            if (this.getIsMouseOverSlot(slotinventory, i, j)) {
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2929);
                int j1 = slotinventory.xDisplayPosition;
                int k1 = slotinventory.yDisplayPosition;
                this.drawGradientRect(j1, k1, j1 + 16, k1 + 16, -2130706433, -2130706433);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)2929);
            }
            ++i1;
        }
        InventoryPlayer inventoryplayer = this.mc.thePlayer.inventory;
        if (inventoryplayer.itemStack != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, i - k - 8, j - l - 8);
            itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, inventoryplayer.itemStack, i - k - 8, j - l - 8);
        }
        GL11.glDisable((int)32826);
        RenderHelper.disableStandardItemLighting();
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        this.drawGuiContainerForegroundLayer();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    protected void drawGuiContainerForegroundLayer() {
    }

    protected abstract void drawGuiContainerBackgroundLayer(float var1);

    private void drawSlotInventory(Slot slot) {
        int k;
        int i = slot.xDisplayPosition;
        int j = slot.yDisplayPosition;
        ItemStack itemstack = slot.getStack();
        if (itemstack == null && (k = slot.getBackgroundIconIndex()) >= 0) {
            GL11.glDisable((int)2896);
            this.mc.renderEngine.bindTex(this.mc.renderEngine.getTex("/gui/items.png"));
            this.drawTexturedModalRect(i, j, k % 16 * 16, k / 16 * 16, 16, 16);
            GL11.glEnable((int)2896);
            return;
        }
        itemRenderer.renderItemBlock(this.fontRenderer, this.mc.renderEngine, itemstack, i, j);
        itemRenderer.renderTextDmg(this.fontRenderer, this.mc.renderEngine, itemstack, i, j);
    }

    private Slot getSlotAtPosition(int i, int j) {
        int k = 0;
        while (k < this.inventorySlots.slots.size()) {
            Slot slotinventory = (Slot)this.inventorySlots.slots.get(k);
            if (this.getIsMouseOverSlot(slotinventory, i, j)) {
                return slotinventory;
            }
            ++k;
        }
        return null;
    }

    private boolean getIsMouseOverSlot(Slot slot, int i, int j) {
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        return (i -= k) >= slot.xDisplayPosition - 1 && i < slot.xDisplayPosition + 16 + 1 && (j -= l) >= slot.yDisplayPosition - 1 && j < slot.yDisplayPosition + 16 + 1;
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (k == 0 || k == 1) {
            Slot slot = this.getSlotAtPosition(i, j);
            int l = (this.width - this.xSize) / 2;
            int i1 = (this.height - this.ySize) / 2;
            boolean flag = i < l || j < i1 || i >= l + this.xSize || j >= i1 + this.ySize;
            int j1 = -1;
            if (slot != null) {
                j1 = slot.slotNumber;
            }
            if (flag) {
                j1 = -999;
            }
            if (j1 != -1) {
                boolean flag1 = j1 != -999 && (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54));
                this.mc.playerController.func_27174_a(this.inventorySlots.windowId, j1, k, flag1, this.mc.thePlayer);
            }
        }
    }

    @Override
    protected void func_573_b(int i, int j, int k) {
        if (k != 0) {
            // empty if block
        }
    }

    @Override
    protected void keyTyped(char c, int i) {
        if (i == 1 || i == this.mc.options.keyBindInventory.keyCode) {
            this.mc.thePlayer.closeScreen();
        }
    }

    @Override
    public void onGuiClosed() {
        if (this.mc.thePlayer == null) {
            return;
        }
        this.mc.playerController.func_20086_a(this.inventorySlots.windowId, this.mc.thePlayer);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }
}

