/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.generate.noise;

import com.mojang.minecraft.level.generate.noise.NoiseGenerator;
import java.util.Random;

public class InfdevNoiseGeneratorPerlin
extends NoiseGenerator {
    private int[] permutations = new int[512];
    private double xCoord;
    private double yCoord;
    private double zCoord;

    public InfdevNoiseGeneratorPerlin() {
        this(new Random());
    }

    public InfdevNoiseGeneratorPerlin(Random random) {
        this.xCoord = random.nextDouble() * 256.0;
        this.yCoord = random.nextDouble() * 256.0;
        this.zCoord = random.nextDouble() * 256.0;
        int i = 0;
        while (i < 256) {
            this.permutations[i] = i;
            ++i;
        }
        int j = 0;
        while (j < 256) {
            int k = random.nextInt(256 - j) + j;
            int l = this.permutations[j];
            this.permutations[j] = this.permutations[k];
            this.permutations[k] = l;
            this.permutations[j + 256] = this.permutations[j];
            ++j;
        }
    }

    private double generateNoise(double d1, double d2, double d3) {
        double d4 = d1 + this.xCoord;
        double d5 = d2 + this.yCoord;
        double d6 = d3 + this.zCoord;
        d1 = (int)d4;
        int i = (int)d5;
        d2 = (int)d6;
        if (d4 < d1) {
            d1 -= 1.0;
        }
        if (d5 < (double)i) {
            --i;
        }
        if (d6 < d2) {
            d2 -= 1.0;
        }
        int j = (int)d1 & 0xFF;
        d3 = i & 0xFF;
        int k = (int)d2 & 0xFF;
        double d7 = (d4 -= d1) * d4 * d4 * (d4 * (d4 * 6.0 - 15.0) + 10.0);
        double d8 = (d5 -= (double)i) * d5 * d5 * (d5 * (d5 * 6.0 - 15.0) + 10.0);
        double d9 = (d6 -= d2) * d6 * d6 * (d6 * (d6 * 6.0 - 15.0) + 10.0);
        d1 = (double)this.permutations[j] + d3;
        i = this.permutations[(int)d1] + k;
        d1 = this.permutations[(int)d1 + 1] + k;
        d2 = (double)this.permutations[j + 1] + d3;
        j = this.permutations[(int)d2] + k;
        d2 = this.permutations[(int)d2 + 1] + k;
        return this.lerp(d9, this.lerp(d8, this.lerp(d7, this.grad(this.permutations[i], d4, d5, d6), this.grad(this.permutations[j], d4 - 1.0, d5, d6)), this.lerp(d7, this.grad(this.permutations[(int)d1], d4, d5 - 1.0, d6), this.grad(this.permutations[(int)d2], d4 - 1.0, d5 - 1.0, d6))), this.lerp(d8, this.lerp(d7, this.grad(this.permutations[i + 1], d4, d5, d6 - 1.0), this.grad(this.permutations[j + 1], d4 - 1.0, d5, d6 - 1.0)), this.lerp(d7, this.grad(this.permutations[(int)d1 + 1], d4, d5 - 1.0, d6 - 1.0), this.grad(this.permutations[(int)d2 + 1], d4 - 1.0, d5 - 1.0, d6 - 1.0))));
    }

    private double lerp(double d1, double d2, double d3) {
        return d2 + d1 * (d3 - d2);
    }

    private double grad(int i, double d1, double d2, double d3) {
        double d4;
        double d = d4 = (i &= 0xF) >= 8 ? d2 : d1;
        double d5 = i >= 4 ? (i != 12 && i != 14 ? d3 : d1) : d2;
        return ((i & 1) != 0 ? -d4 : d4) + ((i & 2) != 0 ? -d5 : d5);
    }

    public double func_801_a(double d1, double d2) {
        return this.generateNoise(d1, d2, 0.0);
    }

    public double a(double d1, double d2, double d3) {
        return this.generateNoise(d1, d2, d3);
    }

    public void func_805_a(double[] ad, int i, int j, int k, int l, int i1, int j1, double d1, double d2, double d3, double d4) {
        int l1 = 0;
        double d5 = 1.0 / d4;
        d4 = -1.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        int l2 = 0;
        while (l2 < l) {
            double d10 = (double)(i + l2) * d1 + this.xCoord;
            int k1 = (int)d10;
            if (d10 < (double)k1) {
                --k1;
            }
            int i3 = k1 & 0xFF;
            double d11 = (d10 -= (double)k1) * d10 * d10 * (d10 * (d10 * 6.0 - 15.0) + 10.0);
            int j3 = 0;
            while (j3 < j1) {
                double d12 = (double)(k + j3) * d3 + this.zCoord;
                k1 = (int)d12;
                if (d12 < (double)k1) {
                    --k1;
                }
                int k3 = k1 & 0xFF;
                double d13 = (d12 -= (double)k1) * d12 * d12 * (d12 * (d12 * 6.0 - 15.0) + 10.0);
                int l3 = 0;
                while (l3 < i1) {
                    double d14 = (double)(j + l3) * d2 + this.yCoord;
                    k1 = (int)d14;
                    if (d14 < (double)k1) {
                        --k1;
                    }
                    int j2 = k1 & 0xFF;
                    double d15 = (d14 -= (double)k1) * d14 * d14 * (d14 * (d14 * 6.0 - 15.0) + 10.0);
                    if (l3 == 0 || (double)j2 != d4) {
                        d4 = j2;
                        k1 = this.permutations[i3] + j2;
                        int i2 = this.permutations[k1] + k3;
                        k1 = this.permutations[k1 + 1] + k3;
                        j2 = this.permutations[i3 + 1] + j2;
                        int k2 = this.permutations[j2] + k3;
                        j2 = this.permutations[j2 + 1] + k3;
                        d6 = this.lerp(d11, this.grad(this.permutations[i2], d10, d14, d12), this.grad(this.permutations[k2], d10 - 1.0, d14, d12));
                        d7 = this.lerp(d11, this.grad(this.permutations[k1], d10, d14 - 1.0, d12), this.grad(this.permutations[j2], d10 - 1.0, d14 - 1.0, d12));
                        d8 = this.lerp(d11, this.grad(this.permutations[i2 + 1], d10, d14, d12 - 1.0), this.grad(this.permutations[k2 + 1], d10 - 1.0, d14, d12 - 1.0));
                        d9 = this.lerp(d11, this.grad(this.permutations[k1 + 1], d10, d14 - 1.0, d12 - 1.0), this.grad(this.permutations[j2 + 1], d10 - 1.0, d14 - 1.0, d12 - 1.0));
                    }
                    double d16 = this.lerp(d15, d6, d7);
                    double d17 = this.lerp(d15, d8, d9);
                    double d18 = this.lerp(d13, d16, d17);
                    int n = l1++;
                    ad[n] = ad[n] + d18 * d5;
                    ++l3;
                }
                ++j3;
            }
            ++l2;
        }
    }
}

