/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public abstract class BlockFluids
extends Block {
    protected int field_458_d = 1;
    protected static boolean isStationary;

    protected BlockFluids(int i, Material material) {
        super(i, (material != Material.lava ? 12 : 14) * 16 + 13, material);
        float f = 0.0f;
        float f1 = 0.0f;
        isStationary = true;
        if (material == Material.lava) {
            this.field_458_d = 2;
        }
        this.setBlockBounds(0.0f + f1, 0.0f + f, 0.0f + f1, 1.0f + f1, 1.0f + f, 1.0f + f1);
        this.setTickOnLoad(true);
    }

    public static float getFluidLevel(int i) {
        if (i >= 8) {
            i = 0;
        }
        float f = (float)(i + 1) / 9.0f;
        return f;
    }

    @Override
    public int getTextureIndex(int i) {
        if (i < 7 && isStationary || i == 0 || i == 1) {
            return this.blockIndexInTexture;
        }
        return this.blockIndexInTexture + 1;
    }

    public boolean getIsStationary(IBlockAccess world, int x, int y, int z) {
        Vec3D flowDir = this.getFlowDirectionVector(world, x, y, z);
        return flowDir.yCoord >= 0.0;
    }

    protected int func_290_h(World world, int i, int j, int k) {
        if (world.getMaterialXYZ(i, j, k) != this.blockMaterial) {
            return -1;
        }
        return world.getBlockMetadata(i, j, k);
    }

    protected int getIfSameMaterialAndHeight(IBlockAccess iblockaccess, int i, int j, int k) {
        if (iblockaccess.getMaterialXYZ(i, j, k) != this.blockMaterial) {
            return -1;
        }
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 8) {
            l = 0;
        }
        return l;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return true;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public boolean canCollideCheck(int i, boolean flag) {
        return flag && i == 0;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.getMaterialXYZ(i, j, k);
        if (material == this.blockMaterial) {
            return false;
        }
        if (material == Material.ice) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.shouldSideBeRendered(iblockaccess, i, j, k, l);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public int getRenderType() {
        return 4;
    }

    @Override
    public int idDropped(int i, Random random) {
        return 0;
    }

    @Override
    public int quantityDropped(Random random) {
        return 0;
    }

    private Vec3D getFlowDirectionVector(IBlockAccess iblockaccess, int x, int y, int z) {
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        int materialAndHeightCheck = this.getIfSameMaterialAndHeight(iblockaccess, x, y, z);
        int sideCheck = 0;
        while (sideCheck < 4) {
            int materialAndHeightCheckSides;
            int sideCheckX = x;
            int sideCheckY = y;
            int sideCheckZ = z;
            if (sideCheck == 0) {
                --sideCheckX;
            }
            if (sideCheck == 1) {
                --sideCheckZ;
            }
            if (sideCheck == 2) {
                ++sideCheckX;
            }
            if (sideCheck == 3) {
                ++sideCheckZ;
            }
            if ((materialAndHeightCheckSides = this.getIfSameMaterialAndHeight(iblockaccess, sideCheckX, sideCheckY, sideCheckZ)) < 0) {
                if (!iblockaccess.getMaterialXYZ(sideCheckX, sideCheckY, sideCheckZ).blocksMovement() && (materialAndHeightCheckSides = this.getIfSameMaterialAndHeight(iblockaccess, sideCheckX, sideCheckY - 1, sideCheckZ)) >= 0) {
                    int heightDifference = materialAndHeightCheckSides - (materialAndHeightCheck - 8);
                    vec3d = vec3d.addVector((sideCheckX - x) * heightDifference, (sideCheckY - y) * heightDifference, (sideCheckZ - z) * heightDifference);
                }
            } else if (materialAndHeightCheckSides >= 0) {
                int heightDifference2 = materialAndHeightCheckSides - materialAndHeightCheck;
                vec3d = vec3d.addVector((sideCheckX - x) * heightDifference2, (sideCheckY - y) * heightDifference2, (sideCheckZ - z) * heightDifference2);
            }
            ++sideCheck;
        }
        if (iblockaccess.getBlockMetadata(x, y, z) >= 8) {
            boolean flag = false;
            if (flag || this.shouldSideBeRendered(iblockaccess, x, y, z - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x, y, z + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x - 1, y, z, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x + 1, y, z, 5)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x, y + 1, z - 1, 2)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x, y + 1, z + 1, 3)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x - 1, y + 1, z, 4)) {
                flag = true;
            }
            if (flag || this.shouldSideBeRendered(iblockaccess, x + 1, y + 1, z, 5)) {
                flag = true;
            }
            if (flag) {
                vec3d = vec3d.normalize().addVector(0.0, -6.0, 0.0);
            }
        }
        vec3d = vec3d.normalize();
        return vec3d;
    }

    @Override
    public void velocityToAddToEntity(World world, int i, int j, int k, Entity entity, Vec3D vec3d) {
        Vec3D vec3d1 = this.getFlowDirectionVector(world, i, j, k);
        vec3d.xCoord += vec3d1.xCoord;
        vec3d.yCoord += vec3d1.yCoord;
        vec3d.zCoord += vec3d1.zCoord;
    }

    @Override
    public int tickRate() {
        if (this.blockMaterial == Material.water) {
            return 5;
        }
        return this.blockMaterial != Material.lava ? 0 : 30;
    }

    @Override
    public float getBlockBrightness(IBlockAccess iblockaccess, int i, int j, int k) {
        float f1;
        float f = iblockaccess.getBrightness(i, j, k);
        return f <= (f1 = iblockaccess.getBrightness(i, j + 1, k)) ? f1 : f;
    }

    @Override
    public void updateTick(World world, int i, int j, int k, Random random) {
        super.updateTick(world, i, j, k, random);
    }

    @Override
    public int getRenderBlockPass() {
        return this.blockMaterial != Material.water ? 0 : 1;
    }

    @Override
    public void randomDisplayTick(World world, int i, int j, int k, Random random) {
        int l;
        if (this.blockMaterial == Material.water && random.nextInt(64) == 0 && (l = world.getBlockMetadata(i, j, k)) > 0 && l < 8) {
            world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "liquid.water", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
        }
        if (this.blockMaterial == Material.lava && world.getMaterialXYZ(i, j + 1, k) == Material.air && !world.isBlockNormalCube(i, j + 1, k) && random.nextInt(100) == 0) {
            double d = (float)i + random.nextFloat();
            double d1 = (double)j + this.maxY;
            double d2 = (float)k + random.nextFloat();
            world.spawnParticle("lava", d, d1, d2, 0.0, 0.0, 0.0);
            int l2 = world.getBlockMetadata(i, j, k);
            if (l2 > 0 && l2 < 8) {
                world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "liquid.lava", random.nextFloat() * 0.25f + 0.75f, random.nextFloat() * 1.0f + 0.5f);
            }
        }
    }

    public static double getFlowDirectionRadians(IBlockAccess iblockaccess, int i, int j, int k, Material material) {
        Vec3D vec3d = null;
        if (material == Material.water) {
            vec3d = ((BlockFluids)Block.waterMoving).getFlowDirectionVector(iblockaccess, i, j, k);
        }
        if (material == Material.lava) {
            vec3d = ((BlockFluids)Block.lavaMoving).getFlowDirectionVector(iblockaccess, i, j, k);
        }
        if (vec3d.xCoord == 0.0 && vec3d.zCoord == 0.0) {
            isStationary = vec3d.yCoord == 0.0;
            return -1000.0;
        }
        isStationary = false;
        return Math.atan2(vec3d.zCoord, vec3d.xCoord) - 1.5707963267948966;
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        this.func_287_j(world, i, j, k);
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        this.func_287_j(world, i, j, k);
    }

    private void func_287_j(World world, int i, int j, int k) {
        if (world.getBlockId(i, j, k) != this.blockID) {
            return;
        }
        if (this.blockMaterial == Material.lava) {
            boolean flag = false;
            if (flag || world.getMaterialXYZ(i, j, k - 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j, k + 1) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i - 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i + 1, j, k) == Material.water) {
                flag = true;
            }
            if (flag || world.getMaterialXYZ(i, j + 1, k) == Material.water) {
                flag = true;
            }
            if (flag) {
                int l = world.getBlockMetadata(i, j, k);
                if (l == 0) {
                    world.setBlockWithNotify(i, j, k, Block.obsidian.blockID);
                    if (new Random().nextInt(500) == 1) {
                        world.setBlockWithNotify(i, j, k, Block.bleedingObsidian.blockID);
                    }
                } else if (l <= 4) {
                    world.setBlockWithNotify(i, j, k, Block.cobblestone.blockID);
                }
                this.triggerLavaMixEffects(world, i, j, k);
            }
        }
    }

    protected void triggerLavaMixEffects(World world, int i, int j, int k) {
        world.playSoundEffect((float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        int l = 0;
        while (l < 8) {
            world.spawnParticle("largesmoke", (double)i + Math.random(), (double)j + 1.2, (double)k + Math.random(), 0.0, 0.0, 0.0);
            ++l;
        }
    }
}

