/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.item.Item;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;

public class BlockJukeBox
extends Block {
    protected BlockJukeBox(int i, int j) {
        super(i, j, Material.wood);
    }

    @Override
    public int getTextureIndex(int i) {
        return this.blockIndexInTexture + (i != 1 ? 0 : 1);
    }

    @Override
    public boolean blockActivated(World world, int i, int j, int k, EntityPlayer entityplayer) {
        int l = world.getBlockMetadata(i, j, k);
        if (l > 0) {
            this.ejectRecord(world, i, j, k, l);
            return true;
        }
        return false;
    }

    public void ejectRecord(World world, int i, int j, int k, int l) {
        world.playRecord(null, i, j, k);
        if (!world.multiplayerWorld) {
            world.setBlockMetadataWithNotify(i, j, k, 0);
            int i1 = Item.record13.shiftedIndex + l - 1;
            float f = 0.7f;
            double d = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.6;
            double d2 = (double)(world.rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)i + d, (double)j + d1, (double)k + d2, new ItemStack(i1));
            entityitem.delayBeforeCanPickup = 10;
            world.entityJoinedWorld(entityitem);
        }
    }

    @Override
    public void dropBlockAsItemWithChance(World world, int i, int j, int k, int l, float f) {
        if (world.multiplayerWorld) {
            return;
        }
        if (l > 0) {
            this.ejectRecord(world, i, j, k, l);
        }
        super.dropBlockAsItemWithChance(world, i, j, k, l, f);
    }
}

