/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.MovingObjectPosition;
import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.MinecartTrackLogic;
import com.mojang.minecraft.level.tile.material.Material;
import com.mojang.minecraft.level.tile.phys.AxisAlignedBB;
import com.mojang.minecraft.render.Vec3D;
import java.util.Random;

public class BlockMinecartTrack
extends Block {
    protected BlockMinecartTrack(int i, int j) {
        super(i, j, Material.circuits);
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return null;
    }

    @Override
    public boolean isOpaqueCube() {
        return false;
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, int i, int j, int k, Vec3D vec3d, Vec3D vec3d1) {
        this.setBlockBoundsBasedOnState(world, i, j, k);
        return super.collisionRayTrace(world, i, j, k, vec3d, vec3d1);
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess iblockaccess, int i, int j, int k) {
        int l = iblockaccess.getBlockMetadata(i, j, k);
        if (l >= 2 && l <= 5) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    @Override
    public int getBlockTextureFromSideAndMetadata(int i, int j) {
        if (j >= 6) {
            return this.blockIndexInTexture - 16;
        }
        return this.blockIndexInTexture;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public int getRenderType() {
        return 9;
    }

    @Override
    public int quantityDropped(Random random) {
        return 1;
    }

    @Override
    public boolean canPlace(World world, int i, int j, int k) {
        return world.isBlockNormalCube(i, j - 1, k);
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        if (!world.multiplayerWorld) {
            world.setBlockMetadataWithNotify(i, j, k, 15);
            this.func_304_h(world, i, j, k);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (world.multiplayerWorld) {
            return;
        }
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = false;
        if (!world.isBlockNormalCube(i, j - 1, k)) {
            flag = true;
        }
        if (i1 == 2 && !world.isBlockNormalCube(i + 1, j, k)) {
            flag = true;
        }
        if (i1 == 3 && !world.isBlockNormalCube(i - 1, j, k)) {
            flag = true;
        }
        if (i1 == 4 && !world.isBlockNormalCube(i, j, k - 1)) {
            flag = true;
        }
        if (i1 == 5 && !world.isBlockNormalCube(i, j, k + 1)) {
            flag = true;
        }
        if (flag) {
            this.dropBlockAsItem(world, i, j, k, world.getBlockMetadata(i, j, k));
            world.setBlockWithNotify(i, j, k, 0);
        } else if (l > 0 && Block.allBlocks[l].canProvidePower() && MinecartTrackLogic.func_791_a(new MinecartTrackLogic(this, world, i, j, k)) == 3) {
            this.func_304_h(world, i, j, k);
        }
    }

    private void func_304_h(World world, int i, int j, int k) {
        if (world.multiplayerWorld) {
            return;
        }
        new MinecartTrackLogic(this, world, i, j, k).func_792_a(world.isBlockIndirectlyGettingPowered(i, j, k));
    }
}

