/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockStep
extends Block {
    private boolean isDouble;

    public BlockStep(int i, boolean flag) {
        super(i, 6, Material.rock);
        this.isDouble = flag;
        if (!flag) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
        }
        this.setLightOpacity(255);
    }

    @Override
    public int getTextureIndex(int i) {
        return i > 1 ? 5 : 6;
    }

    @Override
    public boolean isOpaqueCube() {
        return this.isDouble;
    }

    @Override
    public void onNeighborBlockChange(World world, int i, int j, int k, int l) {
        if (this != Block.stairSingle) {
            return;
        }
    }

    @Override
    public void onBlockAdded(World world, int i, int j, int k) {
        int l;
        if (this != Block.stairSingle) {
            super.onBlockAdded(world, i, j, k);
        }
        if ((l = world.getBlockId(i, j - 1, k)) == BlockStep.stairSingle.blockID) {
            world.setBlockWithNotify(i, j, k, 0);
            world.setBlockWithNotify(i, j - 1, k, Block.stairDouble.blockID);
        }
    }

    @Override
    public int idDropped(int i, Random random) {
        return Block.stairSingle.blockID;
    }

    @Override
    public int quantityDropped(Random random) {
        if (!this.isDouble) {
            return 1;
        }
        return 2;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return this.isDouble;
    }

    @Override
    public boolean shouldSideBeRendered(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (this != Block.stairSingle) {
            super.shouldSideBeRendered(iblockaccess, i, j, k, l);
        }
        if (l == 1) {
            return true;
        }
        if (!super.shouldSideBeRendered(iblockaccess, i, j, k, l)) {
            return false;
        }
        if (l == 0) {
            return true;
        }
        return iblockaccess.getBlockId(i, j, k) != this.blockID;
    }
}

