/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.level.tile;

import com.mojang.minecraft.entity.tile.IBlockAccess;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.tile.Block;
import com.mojang.minecraft.level.tile.material.Material;
import java.util.Random;

public class BlockGrass
extends Block {
    private boolean goldCheck;

    protected BlockGrass(int i) {
        super(i, Material.ground);
        this.blockIndexInTexture = 3;
        this.setTickOnLoad(true);
    }

    public int getTextureIndex(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        if (l == 1) {
            return 0;
        }
        if (l == 0) {
            return 2;
        }
        Material material = iblockaccess.getMaterialXYZ(i, j + 1, k);
        return material != Material.snow && material != Material.builtSnow ? 3 : 68;
    }

    public int getTextureIndex(int i) {
        if (i == 1) {
            return 0;
        }
        if (i == 0) {
            return 2;
        }
        return this.blockIndexInTexture;
    }

    public void updateTick(World world, int i, int j, int k, Random random) {
        int j1;
        int i1;
        int l;
        if (world.multiplayerWorld) {
            return;
        }
        if (world.getBlockLightValue(i, j + 1, k) < 4 && world.getMaterialXYZ(i, j + 1, k).func_881_b()) {
            if (random.nextInt(4) != 0) {
                return;
            }
            world.setBlockWithNotify(i, j, k, Block.dirt.blockID);
        } else if (world.getBlockLightValue(i, j + 1, k) >= 9 && world.getBlockId(l = i + random.nextInt(3) - 1, i1 = j + random.nextInt(5) - 3, j1 = k + random.nextInt(3) - 1) == Block.dirt.blockID && world.getBlockLightValue(l, i1 + 1, j1) >= 4 && !world.getMaterialXYZ(l, i1 + 1, j1).func_881_b()) {
            world.setBlockWithNotify(l, i1, j1, Block.grass.blockID);
        }
    }

    public void goldTouch() {
        this.goldCheck = true;
        System.out.println("I AM GOLD");
    }

    public void notGoldTouch() {
        this.goldCheck = false;
    }

    public int idDropped(int i, Random random) {
        if (this.goldCheck) {
            return Block.grass.blockID;
        }
        return Block.dirt.idDropped(0, random);
    }
}

