/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.network;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityBoat;
import com.mojang.minecraft.entity.EntityItem;
import com.mojang.minecraft.entity.EntityList;
import com.mojang.minecraft.entity.EntityLiving;
import com.mojang.minecraft.entity.EntityMinecart;
import com.mojang.minecraft.entity.EntityOtherPlayerMP;
import com.mojang.minecraft.entity.EntityPickupFX;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.entity.tile.TileEntity;
import com.mojang.minecraft.gui.GuiConnectFailed;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.chunk.Chunk;
import com.mojang.minecraft.network.NetHandler;
import com.mojang.minecraft.network.NetworkManager;
import com.mojang.minecraft.network.packet.Packet;
import com.mojang.minecraft.network.packet.Packet10Flying;
import com.mojang.minecraft.network.packet.Packet16BlockItemSwitch;
import com.mojang.minecraft.network.packet.Packet17AddToInventory;
import com.mojang.minecraft.network.packet.Packet18ArmAnimation;
import com.mojang.minecraft.network.packet.Packet1Login;
import com.mojang.minecraft.network.packet.Packet20NamedEntitySpawn;
import com.mojang.minecraft.network.packet.Packet21PickupSpawn;
import com.mojang.minecraft.network.packet.Packet22Collect;
import com.mojang.minecraft.network.packet.Packet23VehicleSpawn;
import com.mojang.minecraft.network.packet.Packet24MobSpawn;
import com.mojang.minecraft.network.packet.Packet255KickDisconnect;
import com.mojang.minecraft.network.packet.Packet29DestroyEntity;
import com.mojang.minecraft.network.packet.Packet2Handshake;
import com.mojang.minecraft.network.packet.Packet30Entity;
import com.mojang.minecraft.network.packet.Packet34EntityTeleport;
import com.mojang.minecraft.network.packet.Packet3Chat;
import com.mojang.minecraft.network.packet.Packet4UpdateTime;
import com.mojang.minecraft.network.packet.Packet50PreChunk;
import com.mojang.minecraft.network.packet.Packet51MapChunk;
import com.mojang.minecraft.network.packet.Packet52MultiBlockChange;
import com.mojang.minecraft.network.packet.Packet53BlockChange;
import com.mojang.minecraft.network.packet.Packet59ComplexEntity;
import com.mojang.minecraft.network.packet.Packet5PlayerInventory;
import com.mojang.minecraft.network.packet.Packet60HurtEntity;
import com.mojang.minecraft.network.packet.Packet61PlayerHealth;
import com.mojang.minecraft.network.packet.Packet62PlaySound;
import com.mojang.minecraft.network.packet.Packet6SpawnPosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Random;

public class NetClientHandler
extends NetHandler {
    private boolean initialHealth = true;
    private boolean disconnected = false;
    private NetworkManager networkManager;
    public String field_1209_a;
    private Minecraft mc;
    private WorldClient worldClient;
    private boolean field_1210_g = false;
    Random random = new Random();

    public NetClientHandler(Minecraft minecraft, String s, int i) throws UnknownHostException, IOException {
        this.mc = minecraft;
        Socket socket = new Socket(InetAddress.getByName(s), i);
        this.networkManager = new NetworkManager(socket, "Client", this);
    }

    public void handleSound(Packet62PlaySound packet62PlaySound) {
        this.mc.soundMGR.playSound(packet62PlaySound.name, packet62PlaySound.x, packet62PlaySound.y, packet62PlaySound.z, packet62PlaySound.volume, packet62PlaySound.pitch);
    }

    public void processReadPackets() {
        if (this.disconnected) {
            return;
        }
        this.networkManager.func_967_a();
    }

    public void handleLogin(Packet1Login packet1login) {
        this.worldClient.multiplayerWorld = true;
        this.mc.changeWorld1(this.worldClient);
    }

    public void func_832_a(Packet21PickupSpawn packet21pickupspawn) {
        double d = (double)packet21pickupspawn.field_530_b / 32.0;
        double d1 = (double)packet21pickupspawn.field_529_c / 32.0;
        double d2 = (double)packet21pickupspawn.field_528_d / 32.0;
        EntityItem entityitem = new EntityItem(this.worldClient, d, d1, d2, new ItemStack(packet21pickupspawn.itemid, packet21pickupspawn.stacksize, packet21pickupspawn.damage));
        entityitem.motionX = (double)packet21pickupspawn.field_527_e / 128.0;
        entityitem.motionY = (double)packet21pickupspawn.field_526_f / 128.0;
        entityitem.motionZ = (double)packet21pickupspawn.field_525_g / 128.0;
        entityitem.serverPosX = packet21pickupspawn.field_530_b;
        entityitem.serverPosY = packet21pickupspawn.field_529_c;
        entityitem.serverPosZ = packet21pickupspawn.field_528_d;
        this.worldClient.func_712_a(packet21pickupspawn.entid, entityitem);
    }

    public void func_835_a(Packet23VehicleSpawn packet23vehiclespawn) {
        double d = (double)packet23vehiclespawn.field_499_b / 32.0;
        double d1 = (double)packet23vehiclespawn.field_503_c / 32.0;
        double d2 = (double)packet23vehiclespawn.field_502_d / 32.0;
        Entity obj = null;
        if (packet23vehiclespawn.field_501_e == 10) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 0);
        }
        if (packet23vehiclespawn.field_501_e == 11) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 1);
        }
        if (packet23vehiclespawn.field_501_e == 12) {
            obj = new EntityMinecart(this.worldClient, d, d1, d2, 2);
        }
        if (packet23vehiclespawn.field_501_e == 1) {
            obj = new EntityBoat(this.worldClient, d, d1, d2);
        }
        if (obj != null) {
            obj.serverPosX = packet23vehiclespawn.field_499_b;
            obj.serverPosY = packet23vehiclespawn.field_503_c;
            obj.serverPosZ = packet23vehiclespawn.field_502_d;
            obj.rotationYaw = 0.0f;
            obj.rotationPitch = 0.0f;
            obj.entityId = packet23vehiclespawn.field_500_a;
            this.worldClient.func_712_a(packet23vehiclespawn.field_500_a, obj);
        }
    }

    public void func_839_a(Packet60HurtEntity packet60hurtentity) {
        Entity ent;
        if (packet60hurtentity.damage == -500 && (ent = this.worldClient.func_709_b(packet60hurtentity.entityId)) instanceof EntityLiving) {
            System.out.println("Entity Died");
            ((EntityLiving)ent).health = -5000;
            ((EntityLiving)ent).isDead = true;
            ((EntityLiving)ent).health = -5000;
        }
    }

    public void func_820_a(Packet20NamedEntitySpawn packet20namedentityspawn) {
        double d = (double)packet20namedentityspawn.field_540_c / 32.0;
        double d1 = (double)packet20namedentityspawn.field_539_d / 32.0;
        double d2 = (double)packet20namedentityspawn.field_538_e / 32.0;
        float f = (float)(packet20namedentityspawn.field_537_f * 360) / 256.0f;
        float f1 = (float)(packet20namedentityspawn.field_536_g * 360) / 256.0f;
        EntityOtherPlayerMP entityotherplayermp = new EntityOtherPlayerMP(this.mc.mcWorld, packet20namedentityspawn.field_533_b);
        entityotherplayermp.serverPosX = packet20namedentityspawn.field_540_c;
        entityotherplayermp.serverPosY = packet20namedentityspawn.field_539_d;
        entityotherplayermp.serverPosZ = packet20namedentityspawn.field_538_e;
        int i = packet20namedentityspawn.field_535_h;
        entityotherplayermp.inventory.mainInventory[entityotherplayermp.inventory.currentItem] = i == 0 ? null : new ItemStack(i);
        entityotherplayermp.setPositionAndRotation(d, d1, d2, f, f1);
        this.worldClient.func_712_a(packet20namedentityspawn.field_534_a, entityotherplayermp);
    }

    public void func_829_a(Packet34EntityTeleport packet34entityteleport) {
        Entity entity = this.worldClient.func_709_b(packet34entityteleport.field_509_a);
        if (entity == null) {
            return;
        }
        entity.serverPosX = packet34entityteleport.field_508_b;
        entity.serverPosY = packet34entityteleport.field_513_c;
        entity.serverPosZ = packet34entityteleport.field_512_d;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = (float)(packet34entityteleport.field_511_e * 360) / 256.0f;
        float f1 = (float)(packet34entityteleport.field_510_f * 360) / 256.0f;
        entity.setPositionAndRotation2(d, d1, d2, f, f1, 3);
    }

    public void func_827_a(Packet30Entity packet30entity) {
        Entity entity = this.worldClient.func_709_b(packet30entity.field_485_a);
        if (entity == null) {
            return;
        }
        entity.serverPosX += packet30entity.field_484_b;
        entity.serverPosY += packet30entity.field_490_c;
        entity.serverPosZ += packet30entity.field_489_d;
        double d = (double)entity.serverPosX / 32.0;
        double d1 = (double)entity.serverPosY / 32.0;
        double d2 = (double)entity.serverPosZ / 32.0;
        float f = packet30entity.field_486_g ? (float)(packet30entity.field_488_e * 360) / 256.0f : entity.rotationYaw;
        float f1 = packet30entity.field_486_g ? (float)(packet30entity.field_487_f * 360) / 256.0f : entity.rotationPitch;
        entity.setPositionAndRotation2(d, d1, d2, f, f1, 3);
    }

    public void func_839_a(Packet29DestroyEntity packet29destroyentity) {
        this.worldClient.removeEntityFromWorld(packet29destroyentity.field_507_a);
    }

    public void func_837_a(Packet10Flying packet10flying) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        double d = entityplayersp.posX;
        double d1 = entityplayersp.posY;
        double d2 = entityplayersp.posZ;
        float f = entityplayersp.rotationYaw;
        float f1 = entityplayersp.rotationPitch;
        if (packet10flying.field_554_h) {
            d = packet10flying.field_561_a;
            d1 = packet10flying.field_560_b;
            d2 = packet10flying.field_559_c;
        }
        if (packet10flying.field_553_i) {
            f = packet10flying.field_557_e;
            f1 = packet10flying.field_556_f;
        }
        entityplayersp.ySize = 0.0f;
        entityplayersp.motionZ = 0.0;
        entityplayersp.motionY = 0.0;
        entityplayersp.motionX = 0.0;
        entityplayersp.setPositionAndRotation(d, d1, d2, f, f1);
        packet10flying.field_561_a = entityplayersp.posX;
        packet10flying.field_560_b = entityplayersp.boundingBox.minY;
        packet10flying.field_559_c = entityplayersp.posZ;
        packet10flying.field_558_d = entityplayersp.posY;
        this.networkManager.func_972_a(packet10flying);
        if (!this.field_1210_g) {
            this.mc.thePlayer.prevPosX = this.mc.thePlayer.posX;
            this.mc.thePlayer.prevPosY = this.mc.thePlayer.posY;
            this.mc.thePlayer.prevPosZ = this.mc.thePlayer.posZ;
            this.field_1210_g = true;
            this.mc.setCurrentScreen(null);
        }
    }

    public void func_826_a(Packet50PreChunk packet50prechunk) {
        this.worldClient.doPreChunk(packet50prechunk.field_505_a, packet50prechunk.field_504_b, packet50prechunk.field_506_c);
    }

    public void func_824_a(Packet52MultiBlockChange packet52multiblockchange) {
        Chunk chunk = this.worldClient.getChunkFromChunkCoords(packet52multiblockchange.field_479_a, packet52multiblockchange.field_478_b);
        int i = packet52multiblockchange.field_479_a * 16;
        int j = packet52multiblockchange.field_478_b * 16;
        int k = 0;
        while (k < packet52multiblockchange.field_480_f) {
            short word0 = packet52multiblockchange.field_483_c[k];
            int l = packet52multiblockchange.field_482_d[k] & 0xFF;
            byte byte0 = packet52multiblockchange.field_481_e[k];
            int i1 = word0 >> 12 & 0xF;
            int j1 = word0 >> 8 & 0xF;
            int k1 = word0 & 0xFF;
            chunk.setBlockIDWithMetadata(i1, k1, j1, l, byte0);
            this.worldClient.markRangeForUpdate(i1 + i, k1, j1 + j, i1 + i, k1, j1 + j);
            this.worldClient.markBlocksDirty(i1 + i, k1, j1 + j, i1 + i, k1, j1 + j);
            ++k;
        }
    }

    public void func_833_a(Packet51MapChunk packet51mapchunk) {
        this.worldClient.markRangeForUpdate(packet51mapchunk.field_573_a, packet51mapchunk.field_572_b, packet51mapchunk.field_579_c, packet51mapchunk.field_573_a + packet51mapchunk.field_578_d - 1, packet51mapchunk.field_572_b + packet51mapchunk.field_577_e - 1, packet51mapchunk.field_579_c + packet51mapchunk.field_576_f - 1);
        this.worldClient.setChunkData(packet51mapchunk.field_573_a, packet51mapchunk.field_572_b, packet51mapchunk.field_579_c, packet51mapchunk.field_578_d, packet51mapchunk.field_577_e, packet51mapchunk.field_576_f, packet51mapchunk.field_575_g);
    }

    public void func_822_a(Packet53BlockChange packet53blockchange) {
        this.worldClient.func_714_c(packet53blockchange.X, packet53blockchange.Y, packet53blockchange.Z, packet53blockchange.ID, packet53blockchange.Metadata);
    }

    public void func_844_a(Packet255KickDisconnect packet255kickdisconnect) {
        this.networkManager.func_974_a("Got kicked");
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.setCurrentScreen(new GuiConnectFailed("Disconnected by server", packet255kickdisconnect.field_582_a));
    }

    public void func_823_a(String s) {
        if (this.disconnected) {
            return;
        }
        this.disconnected = true;
        this.mc.changeWorld1(null);
        this.mc.setCurrentScreen(new GuiConnectFailed("Connection lost", s));
    }

    public void addToSendQueue(Packet packet) {
        if (this.disconnected) {
            return;
        }
        this.networkManager.func_972_a(packet);
    }

    public void func_834_a(Packet22Collect packet22collect) {
        EntityItem entityitem = (EntityItem)this.worldClient.func_709_b(packet22collect.field_581_a);
        EntityLiving obj = (EntityLiving)this.worldClient.func_709_b(packet22collect.field_580_b);
        if (obj == null) {
            obj = this.mc.thePlayer;
        }
        if (entityitem != null) {
            this.worldClient.playSoundAtEntity(entityitem, "random.pop", 0.2f, ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            this.mc.effectRenderer.addEffect(new EntityPickupFX(this.mc.mcWorld, entityitem, obj, -0.5f));
            this.worldClient.removeEntityFromWorld(packet22collect.field_581_a);
        }
    }

    public void func_841_a(Packet16BlockItemSwitch packet16blockitemswitch) {
        Entity entity = this.worldClient.func_709_b(packet16blockitemswitch.field_563_a);
        if (entity == null) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        int i = packet16blockitemswitch.field_562_b;
        entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = i == 0 ? null : new ItemStack(i);
    }

    public void func_831_a(Packet3Chat packet3chat) {
        this.mc.ingameGUI.addChatMessage(packet3chat.field_517_a);
    }

    public void func_825_a(Packet18ArmAnimation packet18armanimation) {
        Entity entity = this.worldClient.func_709_b(packet18armanimation.field_522_a);
        if (entity == null) {
            return;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        entityplayer.swingItem();
    }

    public void func_830_a(Packet17AddToInventory packet17addtoinventory) {
        this.mc.thePlayer.inventory.addItemStackToInventory(new ItemStack(packet17addtoinventory.field_497_a, packet17addtoinventory.field_496_b, packet17addtoinventory.field_498_c));
    }

    public void func_838_a(Packet2Handshake packet2handshake) {
        if (packet2handshake.field_532_a.equals("-")) {
            this.addToSendQueue(new Packet1Login(this.mc.session.username, "Password", 2));
        } else {
            try {
                URL url = new URL("http://www.minecraft.net/game/joinserver.jsp?user=" + this.mc.session.username + "&sessionId=" + this.mc.session.sessionId + "&serverId=" + packet2handshake.field_532_a);
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(url.openStream()));
                String s = bufferedreader.readLine();
                bufferedreader.close();
                if (s.equalsIgnoreCase("ok")) {
                    this.addToSendQueue(new Packet1Login(this.mc.session.username, "Password", 2));
                } else {
                    this.networkManager.func_974_a("Failed to login: " + s);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.networkManager.func_974_a("Internal client error: " + exception.toString());
            }
        }
    }

    public void disconnect() {
        this.disconnected = true;
        this.networkManager.func_974_a("Closed");
    }

    public void func_828_a(Packet24MobSpawn packet24mobspawn) {
        double d = (double)packet24mobspawn.field_552_c / 32.0;
        double d1 = (double)packet24mobspawn.field_551_d / 32.0;
        double d2 = (double)packet24mobspawn.field_550_e / 32.0;
        float f = (float)(packet24mobspawn.field_549_f * 360) / 256.0f;
        float f1 = (float)(packet24mobspawn.field_548_g * 360) / 256.0f;
        EntityLiving entityliving = (EntityLiving)EntityList.createEntity(packet24mobspawn.field_546_b, this.mc.mcWorld);
        entityliving.serverPosX = packet24mobspawn.field_552_c;
        entityliving.serverPosY = packet24mobspawn.field_551_d;
        entityliving.serverPosZ = packet24mobspawn.field_550_e;
        entityliving.setPositionAndRotation(d, d1, d2, f, f1);
        entityliving.isMultiplayerEntity = true;
        entityliving.entityId = packet24mobspawn.field_547_a;
        this.worldClient.func_712_a(packet24mobspawn.field_547_a, entityliving);
    }

    public void setHealth(Packet61PlayerHealth packet61PlayerHealth) {
        if (this.mc.thePlayer != null) {
            if (packet61PlayerHealth.health < this.mc.thePlayer.health && !this.initialHealth) {
                this.mc.thePlayer.attackEntityFrom(null, this.mc.thePlayer.health - packet61PlayerHealth.health);
            }
            if (this.initialHealth) {
                this.initialHealth = false;
            }
            this.mc.thePlayer.health = packet61PlayerHealth.health;
        }
    }

    public void func_846_a(Packet4UpdateTime packet4updatetime) {
        this.mc.mcWorld.setWorldTime(packet4updatetime.field_564_a);
    }

    public void func_843_a(Packet5PlayerInventory packet5playerinventory) {
        EntityPlayerSP entityplayersp = this.mc.thePlayer;
        if (packet5playerinventory.field_571_a == -1) {
            entityplayersp.inventory.mainInventory = packet5playerinventory.field_570_b;
        }
        if (packet5playerinventory.field_571_a == -2) {
            entityplayersp.inventory.craftingInventory = packet5playerinventory.field_570_b;
        }
        if (packet5playerinventory.field_571_a == -3) {
            entityplayersp.inventory.armorInventory = packet5playerinventory.field_570_b;
        }
    }

    public void func_842_a(Packet59ComplexEntity packet59complexentity) {
        TileEntity tileentity = this.worldClient.getBlockTileEntity(packet59complexentity.field_474_a, packet59complexentity.field_473_b, packet59complexentity.field_477_c);
        if (tileentity != null) {
            tileentity.func_482_a(packet59complexentity.field_475_e);
            this.worldClient.markBlocksDirty(packet59complexentity.field_474_a, packet59complexentity.field_473_b, packet59complexentity.field_477_c, packet59complexentity.field_474_a, packet59complexentity.field_473_b, packet59complexentity.field_477_c);
        }
    }

    public void func_845_a(Packet6SpawnPosition packet6spawnposition) {
        this.worldClient.spawnX = packet6spawnposition.field_515_a;
        this.worldClient.spawnY = packet6spawnposition.field_514_b;
        this.worldClient.spawnZ = packet6spawnposition.field_516_c;
    }
}

