/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.minecraft.player.controller;

import com.mojang.minecraft.Minecraft;
import com.mojang.minecraft.entity.Entity;
import com.mojang.minecraft.entity.EntityPlayer;
import com.mojang.minecraft.entity.EntityPlayerSP;
import com.mojang.minecraft.entity.item.ItemStack;
import com.mojang.minecraft.level.World;
import com.mojang.minecraft.level.WorldClient;
import com.mojang.minecraft.level.tile.Block;

public class PlayerController {
    protected final Minecraft mc;
    public boolean isCreative = false;

    public PlayerController(Minecraft minecraft) {
        this.mc = minecraft;
    }

    public void func_717_a(World world) {
    }

    public void clickBlock(int i, int j, int k, int l) {
        this.doDigBlock(i, j, k, l);
    }

    public boolean doDigBlock(int i, int j, int k, int l) {
        this.mc.effectRenderer.addBlockDestroyEffects(i, j, k);
        World world = this.mc.mcWorld;
        Block block = Block.allBlocks[world.getBlockId(i, j, k)];
        int i1 = world.getBlockMetadata(i, j, k);
        boolean flag = world.setBlockWithNotify(i, j, k, 0);
        if (block != null && flag) {
            this.mc.soundMGR.playSound(block.stepSound.stepSoundDir(), (float)i + 0.5f, (float)j + 0.5f, (float)k + 0.5f, (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getPitch() * 0.8f);
            if (!(world instanceof WorldClient)) {
                block.dropBlockAsItemWithChance(world, i, j, k, i1);
            }
        }
        return flag;
    }

    public void sendRemovingBlock(int i, int j, int k, int l) {
    }

    public void resetBlockRemoving() {
    }

    public void func_723_a(float f) {
    }

    public float getBlockReachDistance() {
        return 5.0f;
    }

    public boolean sendUseItem(EntityPlayer entityplayer, World world, ItemStack itemstack) {
        if (entityplayer.worldObj.multiplayerWorld) {
            int i = itemstack.stackSize;
            ItemStack itemstack1 = itemstack.useItemRightClick(world, entityplayer);
            if (itemstack1 != itemstack || itemstack1 != null && itemstack1.stackSize != i) {
                entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = itemstack1;
                if (itemstack1.stackSize == 0) {
                    entityplayer.inventory.mainInventory[entityplayer.inventory.currentItem] = null;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public void flipPlayer(EntityPlayer entityplayer) {
    }

    public void func_728_c() {
    }

    public boolean isVulnerable() {
        return true;
    }

    public void initiateInventory(EntityPlayer entityplayer) {
    }

    public boolean sendPlaceBlock(EntityPlayer entityplayer, World world, ItemStack itemstack, int i, int j, int k, int l) {
        int i1 = world.getBlockId(i, j, k);
        if (!entityplayer.getIsSneaking() && i1 > 0 && Block.allBlocks[i1].blockActivated(world, i, j, k, entityplayer)) {
            return true;
        }
        if (itemstack == null) {
            return false;
        }
        return itemstack.useItem(entityplayer, world, i, j, k, l);
    }

    public EntityPlayer createPlayer(World world) {
        return new EntityPlayerSP(this.mc, world, this.mc.session);
    }

    public ItemStack func_27174_a(int window, int slot, int click, boolean flag, EntityPlayer entityplayer) {
        return entityplayer.craftingInventory.func_27280_a(slot, click, flag, entityplayer);
    }

    public void func_20086_a(int i, EntityPlayer entityplayer) {
        entityplayer.craftingInventory.onCraftGuiClosed(entityplayer);
        entityplayer.craftingInventory = entityplayer.inventorySlots;
    }

    public void attackEntity(EntityPlayer thePlayer, Entity entityHit) {
    }

    public void interactWithEntity(EntityPlayer thePlayer, Entity entityHit) {
    }
}

